package org.nuiton.wikitty.search;

import java.io.Serializable;

/**
 * LessOrEqual operator is used to build restriction containing "element &lt;=
 * value" where element could be a Integer, a Float or a Date. <br>
 * <br>
 * For example, use: RestrictionHelper.lessEq( myElement ,
 * RestrictionHelper.DATE_FORMAT.format(new Date()) )
 */
public class LessOrEqual extends BinaryOperator implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    /**
     * Default constructor
     */
    public LessOrEqual() {
        super();
    }

    /**
     * Equality test based attributes values
     * 
     * @param other Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LessOrEqual)) {
            return false;
        }

        final LessOrEqual lessOrEqual = (LessOrEqual) other;

        return super.equals(lessOrEqual);
    }

    public int hashCode() {
        int result = LessOrEqual.class.getName().hashCode();
        result = 29 * result + super.hashCode();
        return result;
    }

}