/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.TextParseUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaTransactionAware;

public abstract class TopiaTransactionInterceptor
extends AbstractInterceptor {
    private static final Log log = LogFactory.getLog(TopiaTransactionInterceptor.class);
    private static final long serialVersionUID = 1L;
    public static final String[] DEFAULT_EXCLUDE_METHODS = new String[]{"beginTransaction", "closeContext", "clear"};
    protected Set<String> excludeMethods;

    public Set<String> getExcludeMethods() {
        return this.excludeMethods;
    }

    public void setExcludeMethods(String excludeMethods) {
        this.excludeMethods = TextParseUtil.commaDelimitedStringToSet((String)excludeMethods);
    }

    protected abstract TopiaContext beginTransaction() throws TopiaException;

    public void init() {
        super.init();
        if (this.getExcludeMethods() == null) {
            this.excludeMethods = new HashSet<String>(Arrays.asList(DEFAULT_EXCLUDE_METHODS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        TopiaTransactionAware transactionAware = null;
        Object action = invocation.getProxy().getAction();
        if (action instanceof TopiaTransactionAware) {
            transactionAware = (TopiaTransactionAware)action;
        }
        if (transactionAware == null) {
            return invocation.invoke();
        }
        TopiaTransactionProxyInvocationHandler proxyInvocationHandler = new TopiaTransactionProxyInvocationHandler();
        TopiaContext proxy = (TopiaContext)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{TopiaContext.class, TopiaContextImplementor.class}, (InvocationHandler)proxyInvocationHandler);
        transactionAware.setTransaction(proxy);
        boolean doCommit = this.isCommitNeeded(action, invocation);
        try {
            String string = invocation.invoke();
            return string;
        }
        catch (Exception e) {
            doCommit = false;
            TopiaContext transaction = proxyInvocationHandler.getTransaction();
            if (transaction != null && !transaction.isClosed()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("rollback transaction " + transaction));
                }
                transaction.rollbackTransaction();
            }
            throw e;
        }
        finally {
            TopiaContext transaction = proxyInvocationHandler.getTransaction();
            if (transaction != null && !transaction.isClosed()) {
                try {
                    if (doCommit) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Commit transaction " + transaction));
                        }
                        transaction.commitTransaction();
                    }
                }
                finally {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Close transaction " + transaction));
                    }
                    transaction.closeContext();
                }
            }
        }
    }

    protected boolean isCommitNeeded(Object action, ActionInvocation invocation) throws NoSuchMethodException {
        Method method;
        Class<?> actionType = action.getClass();
        boolean noCommit = actionType.isAnnotationPresent(NoCommit.class);
        if (noCommit) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("NoCommit annotation found on action " + actionType.getName()));
            }
            return false;
        }
        String methodName = invocation.getProxy().getMethod();
        if (methodName == null) {
            methodName = "execute";
        }
        if ((noCommit = (method = actionType.getMethod(methodName, new Class[0])).isAnnotationPresent(NoCommit.class)) && log.isDebugEnabled()) {
            log.debug((Object)("NoCommit annotation found on action methodName  " + actionType.getName() + "#" + methodName));
        }
        return !noCommit;
    }

    public class TopiaTransactionProxyInvocationHandler
    implements InvocationHandler {
        protected TopiaContext transaction;

        public TopiaContext getTransaction() {
            return this.transaction;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (TopiaTransactionInterceptor.this.getExcludeMethods().contains(methodName)) {
                throw new IllegalAccessException("Not allowed to access method " + methodName + " on " + proxy);
            }
            if (this.transaction == null) {
                this.transaction = TopiaTransactionInterceptor.this.beginTransaction();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Open transaction " + this.transaction));
                }
            }
            try {
                Object result = method.invoke((Object)this.transaction, args);
                return result;
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Could not execute method " + method.getName()), (Throwable)eee);
                }
                throw eee;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface NoCommit {
    }
}

