package org.nuiton.web.security;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Mon Mar 17 17:27:11 CET 2014")
public abstract class SecurityUserAbstract extends AbstractTopiaEntity implements SecurityUser {

    /**
     * Nom de l'attribut en BD : login
     */
    protected String login;

    /**
     * Nom de l'attribut en BD : password
     */
    protected String password;

    /**
     * Nom de l'attribut en BD : externalId
     */
    protected String externalId;

    /**
     * Nom de l'attribut en BD : securityRole
     */
    protected Collection<SecurityRole> securityRole;

    private static final long serialVersionUID = 3631647531095843635L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, LOGIN, String.class, login);
        visitor.visit(this, PASSWORD, String.class, password);
        visitor.visit(this, EXTERNAL_ID, String.class, externalId);
        visitor.visit(this, SECURITY_ROLE, Collection.class, SecurityRole.class, securityRole);
        visitor.end(this);
    }

    @Override
    public void setLogin(String login) {
        String oldValue = this.login;
        fireOnPreWrite(LOGIN, oldValue, login);
        this.login = login;
        fireOnPostWrite(LOGIN, oldValue, login);
    }

    @Override
    public String getLogin() {
        fireOnPreRead(LOGIN, login);
        String result = this.login;
        fireOnPostRead(LOGIN, login);
        return result;
    }

    @Override
    public void setPassword(String password) {
        String oldValue = this.password;
        fireOnPreWrite(PASSWORD, oldValue, password);
        this.password = password;
        fireOnPostWrite(PASSWORD, oldValue, password);
    }

    @Override
    public String getPassword() {
        fireOnPreRead(PASSWORD, password);
        String result = this.password;
        fireOnPostRead(PASSWORD, password);
        return result;
    }

    @Override
    public void setExternalId(String externalId) {
        String oldValue = this.externalId;
        fireOnPreWrite(EXTERNAL_ID, oldValue, externalId);
        this.externalId = externalId;
        fireOnPostWrite(EXTERNAL_ID, oldValue, externalId);
    }

    @Override
    public String getExternalId() {
        fireOnPreRead(EXTERNAL_ID, externalId);
        String result = this.externalId;
        fireOnPostRead(EXTERNAL_ID, externalId);
        return result;
    }

    @Override
    public void addSecurityRole(SecurityRole securityRole) {
        fireOnPreWrite(SECURITY_ROLE, null, securityRole);
        if (this.securityRole == null) {
            this.securityRole = new ArrayList<SecurityRole>();
        }

        this.securityRole.add(securityRole);
        fireOnPostWrite(SECURITY_ROLE, this.securityRole.size(), null, securityRole);
    }

    @Override
    public void addAllSecurityRole(Collection<SecurityRole> securityRole) {
        if (securityRole == null) {
            return;
        }
        for (SecurityRole item : securityRole) {
            addSecurityRole(item);
        }
    }

    @Override
    public void setSecurityRole(Collection<SecurityRole> securityRole) {
        // Copy elements to keep data for fire with new reference
        Collection<SecurityRole> oldValue = this.securityRole != null ? new ArrayList<SecurityRole>(this.securityRole) : null;
        fireOnPreWrite(SECURITY_ROLE, oldValue, securityRole);
        this.securityRole = securityRole;
        fireOnPostWrite(SECURITY_ROLE, oldValue, securityRole);
    }

    @Override
    public void removeSecurityRole(SecurityRole securityRole) {
        fireOnPreWrite(SECURITY_ROLE, securityRole, null);
        if (this.securityRole == null || !this.securityRole.remove(securityRole)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(SECURITY_ROLE, this.securityRole.size() + 1, securityRole, null);
    }

    @Override
    public void clearSecurityRole() {
        if (this.securityRole == null) {
            return;
        }
        Collection<SecurityRole> oldValue = new ArrayList<SecurityRole>(this.securityRole);
        fireOnPreWrite(SECURITY_ROLE, oldValue, this.securityRole);
        this.securityRole.clear();
        fireOnPostWrite(SECURITY_ROLE, oldValue, this.securityRole);
    }

    @Override
    public Collection<SecurityRole> getSecurityRole() {
        return securityRole;
    }

    @Override
    public SecurityRole getSecurityRoleByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(securityRole, topiaId);
    }

    @Override
    public Collection<String> getSecurityRoleTopiaIds() {
        Collection<String> topiaIds = new ArrayList<String>();
        Collection<org.nuiton.web.security.SecurityRole> tmp = getSecurityRole();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeSecurityRole() {
        if (securityRole == null) {
            return 0;
        }
        return securityRole.size();
    }

    @Override
    public boolean isSecurityRoleEmpty() {
        int size = sizeSecurityRole();
        return size == 0;
    }

    @Override
    public boolean isSecurityRoleNotEmpty() {
        boolean empty = isSecurityRoleEmpty();
        return ! empty;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(LOGIN, this.login).
            append(PASSWORD, this.password).
            append(EXTERNAL_ID, this.externalId).
            append(SECURITY_ROLE, this.securityRole).
         toString();
        return result;
    }

} //SecurityUserAbstract
