/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.rss;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.rss.FeedRenderer;
import org.nuiton.rss.FeedRendererConfig;
import org.nuiton.rss.Field;
import org.nuiton.rss.HTMLCleaner;
import org.nuiton.rss.HTMLScriptCleaner;

public class FeedHTMLRenderer
implements FeedRenderer {
    private static final Log log = LogFactory.getLog(FeedHTMLRenderer.class);
    private static final String FEED_CSS_PREFIX = "feed-";
    private static final String FEED_ITEM_CSS_PREFIX = "feedItem-";
    protected Set<HTMLCleaner> cleaners = new HashSet();
    protected EnumMap<Field, String> templates = new EnumMap(Field.class);
    protected EnumMap<Field, String> classnames = new EnumMap(Field.class);
    protected EnumMap<Field, String> feedProperties = new EnumMap(Field.class);
    protected EnumMap<Field, String> itemProperties = new EnumMap(Field.class);

    public FeedHTMLRenderer(HTMLCleaner ... cleaners) {
        if (cleaners.length == 0) {
            this.addHTMLCleaner((HTMLCleaner)new HTMLScriptCleaner());
        }
        for (HTMLCleaner cleaner : cleaners) {
            this.addHTMLCleaner(cleaner);
        }
        this.templates.put(Field.NAME, "<span class=\"%1$s\">%2$s</span>\n");
        this.templates.put(Field.LINK, "<a class=\"%1$s\" href=\"%2$s\">%3$s</a>");
        this.templates.put(Field.IMAGE, "<span class=\"%1$s\"><img src=\"%2$s\"/></span>\n");
        this.templates.put(Field.DESCRIPTION, "<span class=\"%1$s\">%2$s</span>\n");
        this.templates.put(Field.AUTHOR, "<span class=\"%1$s\">%2$s</span>\n");
        this.templates.put(Field.TIME, "<span class=\"%1$s\">%2$s</span>\n");
        this.classnames.put(Field.NAME, "name");
        this.classnames.put(Field.LINK, "link");
        this.classnames.put(Field.IMAGE, "image");
        this.classnames.put(Field.DESCRIPTION, "description");
        this.classnames.put(Field.AUTHOR, "author");
        this.classnames.put(Field.TIME, "time");
        this.feedProperties.put(Field.NAME, "title");
        this.feedProperties.put(Field.LINK, "link");
        this.feedProperties.put(Field.IMAGE, "image.url");
        this.feedProperties.put(Field.DESCRIPTION, "description");
        this.feedProperties.put(Field.AUTHOR, "author");
        this.feedProperties.put(Field.TIME, "publishedDate");
        this.itemProperties.put(Field.NAME, "title");
        this.itemProperties.put(Field.LINK, "link");
        this.itemProperties.put(Field.IMAGE, null);
        this.itemProperties.put(Field.DESCRIPTION, "description.value");
        this.itemProperties.put(Field.AUTHOR, "author");
        this.itemProperties.put(Field.TIME, "publishedDate");
    }

    public FeedHTMLRenderer() {
        this(new HTMLCleaner[0]);
    }

    public void clearCleaners() {
        this.cleaners.clear();
    }

    public void addHTMLCleaner(HTMLCleaner cleaner) {
        this.cleaners.add(cleaner);
    }

    public String render(FeedRendererConfig config, SyndFeed feed, SyndEntry[] items) {
        StringBuffer sbGlobal = new StringBuffer();
        StringBuffer sbTemp = new StringBuffer();
        for (Field f : config.getFeedFieldOrder()) {
            this.renderField(f, FEED_CSS_PREFIX, this.feedProperties, (Object)feed, sbTemp);
        }
        String tmp = sbTemp.toString();
        if (!"".equals(tmp)) {
            sbGlobal.append("<div class='rss-feed'>\n").append(tmp).append("</div>\n");
        }
        sbGlobal.append("<ul class='rss-items'>\n");
        sbTemp = new StringBuffer();
        for (SyndEntry item : items) {
            sbTemp.append("<li>\n");
            for (Field f : config.getItemFieldOrder()) {
                this.renderField(f, FEED_ITEM_CSS_PREFIX, this.itemProperties, (Object)item, sbTemp);
            }
            sbTemp.append("</li>\n");
        }
        sbGlobal.append(sbTemp.toString()).append("</ul>\n");
        return sbGlobal.toString();
    }

    protected void renderField(Field f, String cssPrefix, EnumMap<Field, String> properties, Object src, StringBuffer buffer) {
        if (f == Field.LINK) {
            return;
        }
        String template = (String)this.templates.get(f);
        String classname = cssPrefix + (String)this.classnames.get(f);
        String prop = properties.get(f);
        if ("".equals(prop)) {
            return;
        }
        String value = null;
        try {
            String result;
            value = BeanUtils.getProperty((Object)src, (String)prop);
            if (f == Field.NAME) {
                String templateLink = (String)this.templates.get(Field.LINK);
                String classnameLink = FEED_CSS_PREFIX + (String)this.classnames.get(Field.LINK);
                String propLink = properties.get(Field.LINK);
                String value2 = BeanUtils.getProperty((Object)src, (String)propLink);
                value = this.render(templateLink, classnameLink, (Object)value2, (Object)value);
            }
            if ((result = this.render(template, classname, (Object)value)) != null && buffer != null) {
                buffer.append(result);
            }
        }
        catch (Exception eee) {
            log.warn((Object)("Can't get feed property value for property " + prop + ", value:" + value));
        }
    }

    protected String render(String template, String classname, Object value) {
        StringBuffer sb = new StringBuffer();
        if (value != null && !"".equals(value)) {
            if (value instanceof String) {
                for (HTMLCleaner cleaner : this.cleaners) {
                    value = cleaner.clean((String)value);
                }
            }
            sb.append(this.renderTemplate(template, new Object[]{classname, value}));
        }
        return sb.toString();
    }

    protected String render(String template, String classname, Object value, Object value2) {
        StringBuffer sb = new StringBuffer();
        if (value != null && !"".equals(value)) {
            if (value instanceof String) {
                for (HTMLCleaner cleaner : this.cleaners) {
                    value = cleaner.clean((String)value);
                }
            }
            sb.append(this.renderTemplate(template, new Object[]{classname, value, value2}));
        }
        return sb.toString();
    }

    protected String renderTemplate(String template, Object ... args) {
        try {
            String result = String.format(template, args);
            return result;
        }
        catch (Exception e) {
            log.warn((Object)("could not format template " + template + " with args : " + Arrays.toString(args)));
            return "";
        }
    }
}

