/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.rss;

import com.sun.syndication.feed.synd.SyndCategoryImpl;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.XmlReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.rss.FeedEntryComparator;
import org.nuiton.rss.FeedType;
import org.nuiton.rss.Field;
import org.nuiton.rss.RSSGenerator;
import org.nuiton.rss.RSSGeneratorConfig;
import org.nuiton.rss.RSSIOUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class RSSIOUtil {
    static final Log log = LogFactory.getLog(RSSIOUtil.class);

    public static SyndFeed readFeed(URL url) throws IllegalArgumentException, FeedException, IOException {
        SyndFeedInput input = new SyndFeedInput();
        SyndFeed feed = input.build((Reader)new XmlReader(url));
        return feed;
    }

    public static void saveFeed(File file, SyndFeed feed) throws IOException, FeedException {
        SyndFeedOutput output = new SyndFeedOutput();
        output.output(feed, file);
    }

    public static void saveFeed(Writer writer, SyndFeed feed) throws IOException, FeedException {
        SyndFeedOutput output = new SyndFeedOutput();
        output.output(feed, writer);
    }

    public static SyndFeed createFeed(EnumMap<Field, String> feedProperties, FeedType type, Map<Field, Object> values) throws ParseException {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType(type.getType());
        feed.setEncoding("utf-8");
        RSSIOUtil.fillFeed(values, feedProperties, (SyndFeed)feed, (boolean)false);
        return feed;
    }

    public static EnumSet<Field> updateFeed(URL url, EnumMap<Field, String> feedProperties, Map<Field, Object> values) throws ParseException, IllegalArgumentException, FeedException, IOException {
        SyndFeed feed = RSSIOUtil.readFeed((URL)url);
        return RSSIOUtil.updateFeed((SyndFeed)feed, feedProperties, values);
    }

    public static EnumSet<Field> updateFeed(SyndFeed feed, EnumMap<Field, String> feedProperties, Map<Field, Object> values) throws ParseException, IllegalArgumentException, FeedException, IOException {
        EnumSet modifieds = RSSIOUtil.fillFeed(values, feedProperties, (SyndFeed)feed, (boolean)true);
        return modifieds;
    }

    protected static SyndFeed addItemToFeed(SyndFeed feed, SyndEntry item, int nbEntries, Map<Field, Object> values) throws IOException, IllegalArgumentException, FeedException, ParseException {
        List entries = feed.getEntries();
        if (!entries.isEmpty()) {
            Collections.sort(entries, new FeedEntryComparator());
            while (entries.size() > nbEntries - 1) {
                entries.remove(0);
            }
        }
        entries.add(item);
        if (log.isDebugEnabled()) {
            log.debug((Object)("new item " + item));
        }
        return feed;
    }

    public static SyndEntry createFeedItem(EnumMap<Field, String> itemProperties, Map<Field, Object> values) throws ParseException {
        SyndEntryImpl feedEntry = new SyndEntryImpl();
        for (Map.Entry<Field, Object> entry : values.entrySet()) {
            Object realValue;
            Field field = entry.getKey();
            String name = itemProperties.get(field);
            if (name == null) {
                log.warn((Object)("the field " + field + " is not managed in item"));
                continue;
            }
            Object value = entry.getValue();
            switch (1.$SwitchMap$org$nuiton$rss$Field[field.ordinal()]) {
                case 1: {
                    realValue = RSSGenerator.DATE_PARSER.parse((String)value);
                    break;
                }
                case 2: {
                    SyndContentImpl description = new SyndContentImpl();
                    description.setType("text/plain");
                    feedEntry.setDescription((SyndContent)description);
                    realValue = String.valueOf(value);
                    break;
                }
                default: {
                    realValue = value;
                }
            }
            RSSIOUtil.setFieldValue((Object)feedEntry, (String)name, (Object)realValue);
        }
        return feedEntry;
    }

    protected static EnumSet<Field> fillFeed(Map<Field, Object> values, EnumMap<Field, String> feedProperties, SyndFeed feed, boolean treateModfied) throws ParseException {
        EnumSet<Field> modifieds = EnumSet.noneOf(Field.class);
        for (Map.Entry<Field, Object> entry : values.entrySet()) {
            ArrayList realValue;
            Field field = entry.getKey();
            String name = feedProperties.get(field);
            if (name == null) {
                log.warn((Object)("the field " + field + " is not managed in feed"));
                continue;
            }
            ArrayList value = entry.getValue();
            switch (1.$SwitchMap$org$nuiton$rss$Field[field.ordinal()]) {
                case 1: {
                    realValue = RSSGenerator.DATE_PARSER.parse((String)((Object)value));
                    break;
                }
                case 3: {
                    List<Object> categoriesAsList = new ArrayList();
                    if (value instanceof List) {
                        categoriesAsList = value;
                    } else {
                        String cats = String.valueOf(value);
                        String[] categories = cats.split(RSSGeneratorConfig.DEFAULT_LIST_SEPARATOR);
                        categoriesAsList = Arrays.asList(categories);
                    }
                    realValue = new ArrayList();
                    for (String cat : categoriesAsList) {
                        SyndCategoryImpl scat = new SyndCategoryImpl();
                        scat.setName(cat);
                        ((List)realValue).add(scat);
                    }
                    break;
                }
                default: {
                    realValue = value;
                }
            }
            if (treateModfied) {
                Object oldValue = RSSIOUtil.getFieldValue((Object)feed, (String)name);
                if (oldValue == null) {
                    if (realValue != null) {
                        modifieds.add(field);
                    }
                } else if (!oldValue.equals(realValue)) {
                    modifieds.add(field);
                }
            }
            RSSIOUtil.setFieldValue((Object)feed, (String)name, (Object)realValue);
        }
        return modifieds;
    }

    protected static void setFieldValue(Object dst, String name, Object value) {
        if (value == null) {
            log.warn((Object)("null value for field " + name + " is not managed"));
            return;
        }
        try {
            BeanUtils.setProperty((Object)dst, (String)name, (Object)value);
        }
        catch (Exception ex) {
            log.warn((Object)("could not access property " + name), (Throwable)ex);
        }
    }

    protected static Object getFieldValue(Object dst, String name) {
        try {
            return BeanUtils.getProperty((Object)dst, (String)name);
        }
        catch (Exception ex) {
            log.warn((Object)("could not access property " + name), (Throwable)ex);
            return null;
        }
    }

    protected RSSIOUtil() {
    }
}

