/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.migration.AbstractTopiaMigrationCallback;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.version.Version;
import org.nuiton.version.VersionComparator;

public abstract class TopiaMigrationCallbackByClassNG
extends AbstractTopiaMigrationCallback {
    private static final Log log = LogFactory.getLog(TopiaMigrationCallbackByClassNG.class);
    protected MigrationCallBackForVersionResolver callBackResolver;

    protected TopiaMigrationCallbackByClassNG(MigrationCallBackForVersionResolver callBackResolver) {
        this.callBackResolver = callBackResolver;
    }

    @Override
    public Version[] getAvailableVersions() {
        Set<Version> allVersions = this.callBackResolver.getAllVersions();
        return allVersions.toArray(new Version[allVersions.size()]);
    }

    @Override
    protected void migrateForVersion(Version version, TopiaSqlSupport sqlSupport, boolean showSql, boolean showProgression) throws Exception {
        MigrationCallBackForVersion migrator = this.callBackResolver.getCallBack(version);
        migrator.setCallBack(this);
        String[] queries = migrator.prepareMigration(sqlSupport, showSql, showProgression);
        this.executeSQL(sqlSupport, showSql, showProgression, queries);
    }

    public static class MigrationCallBackForVersionResolverByServiceLoader
    implements MigrationCallBackForVersionResolver {
        protected final Map<Version, MigrationCallBackForVersion> versionMigrationMapping = new TreeMap<Version, MigrationCallBackForVersion>((Comparator<Version>)new VersionComparator());

        public MigrationCallBackForVersionResolverByServiceLoader() {
            ServiceLoader<MigrationCallBackForVersion> load = ServiceLoader.load(MigrationCallBackForVersion.class);
            for (MigrationCallBackForVersion callBackForVersion : load) {
                Version version = callBackForVersion.getVersion();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Detects migration version " + version + " [" + callBackForVersion + "]"));
                }
                this.versionMigrationMapping.put(version, callBackForVersion);
            }
        }

        @Override
        public MigrationCallBackForVersion getCallBack(Version version) {
            return this.versionMigrationMapping.get(version);
        }

        @Override
        public Set<Version> getAllVersions() {
            return this.versionMigrationMapping.keySet();
        }
    }

    public static interface MigrationCallBackForVersionResolver {
        public Set<Version> getAllVersions();

        public MigrationCallBackForVersion getCallBack(Version var1);
    }

    public static abstract class MigrationCallBackForVersion {
        protected TopiaMigrationCallbackByClassNG callBack;

        public abstract Version getVersion();

        public void setCallBack(TopiaMigrationCallbackByClassNG callBack) {
            this.callBack = callBack;
        }

        protected String[] prepareMigration(TopiaSqlSupport sqlSupport, boolean showSql, boolean showProgression) throws TopiaException {
            ArrayList<String> queries = new ArrayList<String>();
            this.prepareMigrationScript(sqlSupport, queries, showSql, showProgression);
            return queries.toArray(new String[queries.size()]);
        }

        protected abstract void prepareMigrationScript(TopiaSqlSupport var1, List<String> var2, boolean var3, boolean var4) throws TopiaException;

        public void executeSQL(TopiaSqlSupport sqlSupport, String ... sqls) throws TopiaException {
            this.callBack.executeSQL(sqlSupport, sqls);
        }

        public void executeSQL(TopiaSqlSupport sqlSupport, boolean showSql, boolean showProgression, String ... sqls) throws TopiaException {
            this.callBack.executeSQL(sqlSupport, showSql, showProgression, sqls);
        }
    }
}

