/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration.kernel;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.LazyInitializationException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.collection.PersistentBag;
import org.hibernate.collection.PersistentList;
import org.hibernate.collection.PersistentSet;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.proxy.map.MapProxy;
import org.nuiton.topia.migration.common.MapAdapterAdmin;
import org.nuiton.topia.migration.common.MapAdapterImpl;
import org.nuiton.topia.migration.common.ProxyClass;
import org.nuiton.topia.migration.common.ProxyClassMapped;
import org.nuiton.topia.migration.common.SimpleProxyClass;
import org.nuiton.topia.migration.common.SimpleProxyClassMapped;
import org.nuiton.topia.migration.kernel.DependenciesHelper;
import org.nuiton.util.Version;

@Deprecated
public class ConfigurationAdapter {
    private SessionFactory sessionFactory;
    private Configuration configuration;
    private Version version;
    private static Log logger = LogFactory.getLog(ConfigurationAdapter.class);
    private DependenciesHelper dependenciesHelper;

    public ConfigurationAdapter(Configuration configuration, Version version) {
        this.configuration = configuration;
        this.sessionFactory = configuration.buildSessionFactory();
        this.version = version;
        this.dependenciesHelper = new DependenciesHelper(this.sessionFactory, configuration);
    }

    public DependenciesHelper getDependenciesHelper() {
        return this.dependenciesHelper;
    }

    public Version getVersion() {
        return this.version;
    }

    public Collection<ProxyClass> getClasses() {
        Iterator iClass = this.configuration.getClassMappings();
        LinkedList<ProxyClass> cClass = new LinkedList<ProxyClass>();
        while (iClass.hasNext()) {
            PersistentClass rc = (PersistentClass)iClass.next();
            String name = rc.getClassName();
            if (name == null) {
                name = rc.getEntityName();
            }
            cClass.add(new SimpleProxyClass(name));
        }
        return cClass;
    }

    public Collection<MapAdapterAdmin> getData(ProxyClass className) {
        LinkedList<MapAdapterAdmin> result = new LinkedList<MapAdapterAdmin>();
        Session session = this.sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        logger.debug((Object)("Fetching data for class : " + className.getCanonicalName()));
        String nomIdAttribute = this.configuration.getClassMapping(className.getCanonicalName()).getIdentifierProperty().getName();
        org.hibernate.Session dynamicSession = session.getSession(EntityMode.MAP);
        List lstReponse = dynamicSession.createCriteria(className.getCanonicalName()).list();
        for (Object o : lstReponse) {
            Map<String, Object> m = (Map<String, Object>)o;
            m = this.removeProxyMaps(m);
            MapAdapterImpl map = new MapAdapterImpl(m, className, nomIdAttribute, (Serializable)m.get(nomIdAttribute));
            map.setInnerVersion(this.getVersion());
            result.add(map);
        }
        tx.rollback();
        return result;
    }

    public MapAdapterAdmin getData(ProxyClass className, Serializable idVal) {
        Session session = this.sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        String nomIdAttribute = this.configuration.getClassMapping(className.getCanonicalName()).getIdentifierProperty().getName();
        org.hibernate.Session dynamicSession = session.getSession(EntityMode.MAP);
        Map<String, Object> m = (Map<String, Object>)dynamicSession.get(className.getCanonicalName(), idVal);
        MapAdapterImpl maa = null;
        if (m != null) {
            m = this.removeProxyMaps(m);
            maa = new MapAdapterImpl(m, className, nomIdAttribute, (Serializable)m.get(nomIdAttribute));
            maa.setInnerVersion(this.getVersion());
        }
        tx.commit();
        return maa;
    }

    public void saveMaps(Collection<MapAdapterAdmin> myMaps, Map<ProxyClassMapped, ProxyClassMapped> linkedClass) {
        logger.debug((Object)"Saving collection of maps");
        for (MapAdapterAdmin maMap : myMaps) {
            this.saveMap(maMap, linkedClass);
        }
    }

    public void saveMap(MapAdapterAdmin maMap, Map<ProxyClassMapped, ProxyClassMapped> linkedClass) {
        ProxyClass clazz = maMap.getInnerClass();
        Session session = this.sessionFactory.getCurrentSession();
        session.beginTransaction();
        org.hibernate.Session dynamicSession = session.getSession(EntityMode.MAP);
        Map<String, Object> mapData = this.removeImbricatedMaps(dynamicSession, maMap.getInnerMap(), linkedClass);
        this.deletePersistentCollection(mapData);
        this.modifyId(mapData, linkedClass);
        session.getTransaction().rollback();
        session = this.sessionFactory.getCurrentSession();
        session.beginTransaction();
        dynamicSession = session.getSession(EntityMode.MAP);
        dynamicSession.saveOrUpdate(clazz.getCanonicalName(), mapData);
        session.getTransaction().commit();
    }

    private void modifyId(Map<String, Object> mapData, Map<ProxyClassMapped, ProxyClassMapped> linkedClass) {
        String clazz = mapData.get("$type$").toString();
        ProxyClassMapped pc = null;
        if (linkedClass != null && linkedClass.containsKey(new SimpleProxyClassMapped(new SimpleProxyClass(clazz)))) {
            pc = linkedClass.get(new SimpleProxyClassMapped(new SimpleProxyClass(clazz)));
            clazz = pc.getProxyClass().getCanonicalName();
        }
        if (pc != null) {
            String nomIdAttribute = (String)((Object)pc.getIdAttribute());
            mapData.put(nomIdAttribute, pc.getMigrationClass().modifyId((Serializable)mapData.get(nomIdAttribute)));
            mapData.put("$type$", clazz);
        }
    }

    private void deletePersistentCollection(Map<String, Object> mapData) {
        HashMap<String, AbstractCollection> m = new HashMap<String, AbstractCollection>();
        for (String key : mapData.keySet()) {
            if (!(mapData.get(key) instanceof AbstractPersistentCollection)) continue;
            Collection c = (Collection)mapData.get(key);
            for (Object element : c) {
                if (!(element instanceof Map)) continue;
                this.deletePersistentCollection((Map)element);
            }
            if (mapData.get(key) instanceof PersistentSet) {
                m.put(key, new HashSet(c));
                continue;
            }
            if (mapData.get(key) instanceof PersistentBag) {
                m.put(key, new LinkedList(c));
                continue;
            }
            if (mapData.get(key) instanceof PersistentList) {
                m.put(key, new LinkedList(c));
                continue;
            }
            logger.error((Object)("Unknow collection type : " + mapData.get(key)));
        }
        for (String key : m.keySet()) {
            mapData.put(key, m.get(key));
        }
    }

    private Map<String, Object> removeProxy(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>(map);
        for (String key : map.keySet()) {
            if (!(map.get(key) instanceof MapProxy)) continue;
            Map<String, Object> m = this.deleteMapProxy((MapProxy)map.get(key));
            map.put(key, m);
        }
        return result;
    }

    private Map<String, Object> removeProxyMaps(Map<String, Object> map) {
        HashMap<String, Object> m = new HashMap<String, Object>(map);
        for (String key : m.keySet()) {
            if (m.get(key) instanceof Iterable) {
                Iterable pl = (Iterable)m.get(key);
                for (Object element : pl) {
                    if (!(element instanceof Map)) continue;
                    element = this.removeProxy((Map)element);
                }
                continue;
            }
            if (!(m.get(key) instanceof Map)) continue;
            map.put(key, this.removeProxy((Map)m.get(key)));
        }
        return map;
    }

    private Map<String, Object> deleteMapProxy(MapProxy element) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (element instanceof MapProxy) {
            MapProxy mp = element;
            result.putAll((Map<String, Object>)mp);
        }
        return result;
    }

    private Map<String, Object> convertToNewMap(Map<String, Object> element, org.hibernate.Session dynamicSession, Map<ProxyClassMapped, ProxyClassMapped> linkedClass) {
        String clazz = element.get("$type$").toString();
        ProxyClassMapped pc = null;
        if (linkedClass != null && linkedClass.containsKey(new SimpleProxyClassMapped(new SimpleProxyClass(clazz)))) {
            pc = linkedClass.get(new SimpleProxyClassMapped(new SimpleProxyClass(clazz)));
            clazz = pc.getProxyClass().getCanonicalName();
        }
        String nomIdAttribute = pc != null ? (String)((Object)pc.getIdAttribute()) : this.configuration.getClassMapping(clazz).getIdentifierProperty().getName();
        Object idElement = element.get(nomIdAttribute);
        if (pc != null) {
            idElement = pc.getMigrationClass().modifyId((Serializable)idElement);
        }
        Map newMap = null;
        try {
            newMap = (Map)dynamicSession.get(clazz, (Serializable)idElement);
        }
        catch (LazyInitializationException e) {
            newMap = null;
        }
        if (newMap != null) {
            element.clear();
            this.removeProxy(newMap);
            element.putAll(newMap);
        } else {
            logger.debug((Object)"No map found for specified identifier in new database, skip");
        }
        return newMap;
    }

    private Map<String, Object> removeImbricatedMaps(org.hibernate.Session dynamicSession, Map<String, Object> map, Map<ProxyClassMapped, ProxyClassMapped> linkedClass) {
        HashMap<String, Object> m = new HashMap<String, Object>(map);
        for (String key : m.keySet()) {
            if (m.get(key) instanceof Iterable) {
                Iterable pl = (Iterable)m.get(key);
                for (Map<String, Object> element : pl) {
                    element = this.convertToNewMap(element, dynamicSession, linkedClass);
                }
                continue;
            }
            if (!(m.get(key) instanceof Map)) continue;
            Map<String, Object> element = (Map<String, Object>)m.get(key);
            element = this.convertToNewMap(element, dynamicSession, linkedClass);
            map.put(key, element);
        }
        return map;
    }

    public String getNameIdAttribute(ProxyClass pc) {
        return this.configuration.getClassMapping(pc.getCanonicalName()).getIdentifierProperty().getName();
    }
}

