/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.csv.in;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportToMap;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.metadata.AssociationMeta;
import org.nuiton.topia.persistence.metadata.MetaFilenameAware;
import org.nuiton.topia.persistence.metadata.TableMeta;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.service.csv.CsvProgressModel;
import org.nuiton.topia.service.csv.in.CsvImportResult;
import org.nuiton.topia.service.csv.in.ImportModelFactory;
import org.nuiton.topia.service.csv.in.ImportStrategy;

public class TopiaCsvImports {
    private static final Log log = LogFactory.getLog(TopiaCsvImports.class);
    protected static final String UPDATE_ASSOCIATION = "UPDATE %s SET %s = '%%s' WHERE topiaId ='%%s';";
    protected static final String INSERT_ASSOCIATION = "INSERT INTO %s (%s,%s) VALUES('%%s','%%s');";

    protected TopiaCsvImports() {
    }

    public static <T extends TopiaEntityEnum, M extends MetaFilenameAware<T>> Map<M, ZipEntry> discoverEntries(String entryPrefix, Iterable<M> possibleMetas, ZipFile zipFile, List<String> missingEntries) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (MetaFilenameAware entry : possibleMetas) {
            String filename = entry.getFilename();
            ZipEntry zipEntry = zipFile.getEntry(entryPrefix + filename);
            if (zipEntry == null) {
                missingEntries.add(filename);
                continue;
            }
            result.put(entry, zipEntry);
        }
        return result;
    }

    public static <T extends TopiaEntityEnum, M extends MetaFilenameAware<T>> Map<M, File> discoverEntries(Iterable<M> possibleMetas, File directory, List<String> missingEntries) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (MetaFilenameAware entry : possibleMetas) {
            String filename = entry.getFilename();
            File zipEntry = new File(directory, filename);
            if (zipEntry.exists()) {
                result.put(entry, zipEntry);
                continue;
            }
            missingEntries.add(filename);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TopiaEntityEnum, E extends TopiaEntity> void importTable(Reader reader, ImportStrategy<T> importStrategy, TableMeta<T> meta, CsvImportResult<T> csvResult) throws TopiaException, IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import " + meta));
        }
        ImportModel model = importStrategy.getModelFactory().buildForImport(meta);
        try (Import importer = Import.newImport(model, (Reader)reader);){
            importStrategy.importTable(meta, importer, csvResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TopiaEntityEnum, E extends TopiaEntity> Iterable<E> importTableAndReturn(Reader reader, ImportStrategy<T> importStrategy, TableMeta<T> meta, CsvImportResult<T> csvResult) throws TopiaException, IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import " + meta));
        }
        ImportModel model = importStrategy.getModelFactory().buildForImport(meta);
        try (Import importer = Import.newImport(model, (Reader)reader);){
            Iterable iterable = importStrategy.importTableAndReturnThem(meta, importer, csvResult);
            return iterable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TopiaEntityEnum> void importAssociation(Reader reader, ImportStrategy<T> importStrategy, AssociationMeta<T> meta, CsvImportResult<T> csvResult) throws IOException, TopiaException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import " + meta));
        }
        ImportModelFactory<T> modelFactory = importStrategy.getModelFactory();
        ImportModel<Map<String, Object>> model = modelFactory.buildForImport(meta);
        try (ImportToMap importer = ImportToMap.newImportToMap(model, (Reader)reader, (boolean)false);){
            importStrategy.importAssociation(meta, importer, csvResult);
        }
    }

    public static <T extends TopiaEntityEnum, E extends TopiaEntity> void importAllEntities(TopiaDao<E> dao, TableMeta<T> meta, Import<E> importer, CsvImportResult<T> csvResult) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        for (TopiaEntity entity : importer) {
            Map properties = meta.prepareCreate(entity, entity.getTopiaId());
            TopiaEntity entityToSave = dao.create(properties);
            meta.copy(entity, entityToSave);
            if (csvResult == null) continue;
            csvResult.incrementsNumberUpdated();
            if (progressModel == null) continue;
            progressModel.incrementsProgress();
        }
    }

    public static <T extends TopiaEntityEnum, E extends TopiaEntity> void importAllEntities(TopiaHibernateSupport hibernateSupport, TopiaDao<E> dao, TableMeta<T> meta, Import<E> importer, CsvImportResult<T> csvResult, int nbRowBuffer) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        int compt = 0;
        for (TopiaEntity entity : importer) {
            Map properties = meta.prepareCreate(entity, entity.getTopiaId());
            TopiaEntity entityToSave = dao.create(properties);
            meta.copy(entity, entityToSave);
            if (csvResult != null) {
                csvResult.incrementsNumberUpdated();
                if (progressModel != null) {
                    progressModel.incrementsProgress();
                }
            }
            if (++compt % nbRowBuffer != 0) continue;
            hibernateSupport.getHibernateSession().flush();
        }
    }

    public static <T extends TopiaEntityEnum, E extends TopiaEntity> Iterable<E> importAllEntitiesAndReturnThem(TopiaDao<E> dao, TableMeta<T> meta, Import<E> importer, CsvImportResult<T> csvResult) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        ArrayList result = Lists.newArrayList();
        for (TopiaEntity entity : importer) {
            Map properties = meta.prepareCreate(entity, entity.getTopiaId());
            TopiaEntity entityToSave = dao.create(properties);
            meta.copy(entity, entityToSave);
            if (csvResult != null) {
                csvResult.incrementsNumberUpdated();
                if (progressModel != null) {
                    progressModel.incrementsProgress();
                }
            }
            result.add(entityToSave);
        }
        return result;
    }

    public static <T extends TopiaEntityEnum, E extends TopiaEntity> void importNotExistingEntities(TopiaDao<E> dao, TableMeta<T> meta, Map<String, TopiaEntity> universe, Import<E> importer, CsvImportResult<T> csvResult) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        for (TopiaEntity entity : importer) {
            String topiaId = entity.getTopiaId();
            Map properties = meta.prepareCreate(entity, null);
            TopiaEntity existingEntity = dao.forProperties(properties).findAnyOrNull();
            if (existingEntity == null) {
                TopiaEntity entityToSave = dao.create(properties);
                String newTopiaId = entityToSave.getTopiaId();
                Date topiaCreateDate = entityToSave.getTopiaCreateDate();
                meta.copy(entity, entityToSave);
                entityToSave.setTopiaId(newTopiaId);
                entityToSave.setTopiaCreateDate(topiaCreateDate);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Create entity [%s becomes %s] with naturalId %s", topiaId, newTopiaId, properties));
                }
                universe.put(topiaId, entityToSave);
                if (csvResult == null) continue;
                csvResult.incrementsNumberCreated();
                if (progressModel == null) continue;
                progressModel.incrementsProgress();
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Existing entity [%s] with naturalId %s, do not create anything", topiaId, properties));
            }
            universe.put(topiaId, existingEntity);
        }
    }

    public static <T extends TopiaEntityEnum> void importAssociation(TopiaSqlSupport sqlSupport, AssociationMeta<T> meta, ImportToMap importer, CsvImportResult<T> csvResult, int nbRowBuffer) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        TopiaEntityEnum source = meta.getSource();
        TopiaEntityEnum target = meta.getTarget();
        StringBuilder builder = new StringBuilder();
        String targetTableName = target.getContract().getSimpleName();
        String sourceTableName = source.getContract().getSimpleName();
        String table = targetTableName;
        String updateString = String.format(UPDATE_ASSOCIATION, table, sourceTableName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply " + updateString));
        }
        int compt = 0;
        for (Map row : importer) {
            String[] associations;
            String topiaId = (String)row.get("topiaId");
            for (String association : associations = (String[])row.get("target")) {
                if (!StringUtils.isNotEmpty((CharSequence)association)) continue;
                builder.append(String.format(updateString, topiaId, association)).append('\n');
                if (++compt % nbRowBuffer != 0) continue;
                sqlSupport.executeSql(builder.toString());
                builder = new StringBuilder();
            }
            if (csvResult == null) continue;
            csvResult.incrementsNumberUpdated();
            if (progressModel == null) continue;
            progressModel.incrementsProgress();
        }
        if (builder.length() > 0) {
            sqlSupport.executeSql(builder.toString());
        }
    }

    public static <T extends TopiaEntityEnum> void importNMAssociation(TopiaSqlSupport sqlSupport, AssociationMeta<T> meta, ImportToMap importer, CsvImportResult<T> csvResult, int nbRowBuffer) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        TopiaEntityEnum source = meta.getSource();
        TopiaEntityEnum target = meta.getTarget();
        StringBuilder builder = new StringBuilder();
        String targetTableName = target.getContract().getSimpleName();
        String sourceTableName = source.getContract().getSimpleName();
        String table = TopiaEntityHelper.getNormalizedAssociationTableName((String)sourceTableName, (String)targetTableName);
        String updateString = String.format(INSERT_ASSOCIATION, table, sourceTableName, targetTableName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply " + updateString));
        }
        int compt = 0;
        for (Map row : importer) {
            String[] associations;
            String topiaId = (String)row.get("topiaId");
            for (String association : associations = (String[])row.get("target")) {
                if (!StringUtils.isNotEmpty((CharSequence)association)) continue;
                builder.append(String.format(updateString, topiaId, association)).append('\n');
                if (++compt % nbRowBuffer != 0) continue;
                sqlSupport.executeSql(builder.toString());
                builder = new StringBuilder();
            }
            if (csvResult == null) continue;
            csvResult.incrementsNumberUpdated();
            if (progressModel == null) continue;
            progressModel.incrementsProgress();
        }
        if (builder.length() > 0) {
            sqlSupport.executeSql(builder.toString());
        }
    }

    public static <T extends TopiaEntityEnum> void importNMAssociation(TopiaSqlSupport sqlSupport, AssociationMeta<T> meta, Map<String, TopiaEntity> universe, ImportToMap importer, CsvImportResult<T> csvResult, int nbRowBuffer) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        TopiaEntityEnum source = meta.getSource();
        TopiaEntityEnum target = meta.getTarget();
        StringBuilder builder = new StringBuilder();
        String targetTableName = target.getContract().getSimpleName();
        String sourceTableName = source.getContract().getSimpleName();
        String table = TopiaEntityHelper.getNormalizedAssociationTableName((String)sourceTableName, (String)targetTableName);
        String updateString = String.format(INSERT_ASSOCIATION, table, sourceTableName, targetTableName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply " + updateString));
        }
        int compt = 0;
        for (Map row : importer) {
            String[] associations;
            String topiaId = (String)row.get("topiaId");
            for (String association : associations = (String[])row.get("target")) {
                if (!StringUtils.isNotEmpty((CharSequence)association)) continue;
                TopiaEntity targetEntity = universe.get(association);
                Preconditions.checkNotNull((Object)targetEntity, (Object)("Could not find target entity from id: " + association));
                builder.append(String.format(updateString, topiaId, targetEntity.getTopiaId())).append('\n');
                if (++compt % nbRowBuffer != 0) continue;
                sqlSupport.executeSql(builder.toString());
                builder = new StringBuilder();
            }
            if (csvResult == null) continue;
            csvResult.incrementsNumberUpdated();
            if (progressModel == null) continue;
            progressModel.incrementsProgress();
        }
        if (builder.length() > 0) {
            sqlSupport.executeSql(builder.toString());
        }
    }

    public static <T extends TopiaEntityEnum> void importAssociation(TopiaSqlSupport sqlSupport, AssociationMeta<T> meta, Map<String, TopiaEntity> universe, ImportToMap importer, CsvImportResult<T> csvResult, int nbRowBuffer) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        TopiaEntityEnum source = meta.getSource();
        TopiaEntityEnum target = meta.getTarget();
        StringBuilder builder = new StringBuilder();
        String targetTableName = target.getContract().getSimpleName();
        String sourceTableName = source.getContract().getSimpleName();
        String table = targetTableName;
        String updateString = String.format(UPDATE_ASSOCIATION, table, sourceTableName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply " + updateString));
        }
        int compt = 0;
        for (Map row : importer) {
            String[] associations;
            String topiaId = (String)row.get("topiaId");
            for (String association : associations = (String[])row.get("target")) {
                if (!StringUtils.isNotEmpty((CharSequence)association)) continue;
                TopiaEntity targetEntity = universe.get(association);
                Preconditions.checkNotNull((Object)targetEntity, (Object)("Could not find target entity from id: " + association));
                builder.append(String.format(updateString, topiaId, targetEntity.getTopiaId())).append('\n');
                if (++compt % nbRowBuffer != 0) continue;
                sqlSupport.executeSql(builder.toString());
                builder = new StringBuilder();
            }
            if (csvResult == null) continue;
            csvResult.incrementsNumberUpdated();
            if (progressModel == null) continue;
            progressModel.incrementsProgress();
        }
        if (builder.length() > 0) {
            sqlSupport.executeSql(builder.toString());
        }
    }
}

