package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaService.java 3149 2014-06-03 21:02:46Z bleny $
 * $HeadURL: https://svn.nuiton.org/topia/tags/topia-3.0-beta-6/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaService.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Map;

/**
 * Used to implement a service for Topia.
 *
 * A TopiaService is started at the very beginning of the {@link org.nuiton.topia.persistence.TopiaApplicationContext}
 * startup and provides user extra operations not available in the topia core replication, IO, etc.
 */
public interface TopiaService {

    /**
     * Initialize the service.
     *
     * @param topiaApplicationContext is the {@link org.nuiton.topia.persistence.TopiaApplicationContext}
     *                                to which the current service is attached. It's the service
     *                                responsibility to keep a reference to it.
     * @param serviceConfiguration all the configuration directives for this service.
     */
    void initTopiaService(TopiaApplicationContext topiaApplicationContext, Map<String, String> serviceConfiguration);

    /**
     * Retrieve entities of this service needed for persistence.
     *
     * @return List of entities full qualified name separated by a comma
     */
    Class<?>[] getPersistenceClasses();

}
