/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaService;
import org.nuiton.topia.persistence.support.TopiaServiceSupport;

public class TopiaServiceSupportImpl
implements TopiaServiceSupport {
    private static final Log log = LogFactory.getLog(TopiaServiceSupportImpl.class);
    protected static final String TOPIA_SERVICE_CONFIGURATION_PREFIX = "topia.service.";
    protected ImmutableMap<String, TopiaService> services;

    public void initServices(TopiaApplicationContext topiaApplicationContext) {
        ImmutableMap<String, String> topiaApplicationContextConfiguration = topiaApplicationContext.getConfiguration();
        HashMap<String, TopiaService> services = new HashMap<String, TopiaService>();
        HashMap<String, Map<String, String>> servicesConfigurations = new HashMap<String, Map<String, String>>();
        this.loadServices(topiaApplicationContextConfiguration, services, servicesConfigurations);
        this.callInitOnAllTopiaServices(topiaApplicationContext, services, servicesConfigurations);
        this.services = ImmutableMap.copyOf(services);
    }

    protected void loadServices(ImmutableMap<String, String> topiaApplicationContextConfiguration, Map<String, TopiaService> services, Map<String, Map<String, String>> servicesConfigurations) {
        for (Map.Entry entry : topiaApplicationContextConfiguration.entrySet()) {
            String prefixedConfigurationKey = (String)entry.getKey();
            String configurationValue = (String)entry.getValue();
            if (!prefixedConfigurationKey.startsWith(TOPIA_SERVICE_CONFIGURATION_PREFIX)) continue;
            String configurationKey = StringUtils.removeStart((String)prefixedConfigurationKey, (String)TOPIA_SERVICE_CONFIGURATION_PREFIX);
            String[] split = StringUtils.split((String)configurationKey, (char)'.');
            Preconditions.checkState((split.length > 0 ? 1 : 0) != 0, (Object)("'" + prefixedConfigurationKey + "' is not a valid configuration key"));
            String serviceName = split[0];
            if (split.length == 1) {
                try {
                    Class<?> forName = Class.forName(configurationValue);
                    Object newInstance = forName.getConstructor(new Class[0]).newInstance(new Object[0]);
                    TopiaService service1 = (TopiaService)newInstance;
                    services.put(serviceName, service1);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("instantiated service " + serviceName + ": " + service1));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new TopiaException("unable to find topia service class " + configurationValue, e);
                }
                catch (InstantiationException e) {
                    throw new TopiaException("unable to instantiate class " + configurationValue, e);
                }
                catch (IllegalAccessException e) {
                    throw new TopiaException("unable to instantiate class " + configurationValue, e);
                }
                catch (InvocationTargetException e) {
                    throw new TopiaException("unable to instantiate class " + configurationValue, e);
                }
                catch (NoSuchMethodException e) {
                    throw new TopiaException("unable to instantiate class " + configurationValue, e);
                }
            }
            Map<String, String> serviceConfiguration = servicesConfigurations.get(serviceName);
            if (serviceConfiguration == null) {
                serviceConfiguration = new LinkedHashMap<String, String>();
                servicesConfigurations.put(serviceName, serviceConfiguration);
            }
            String serviceConfigurationKey = StringUtils.removeStart((String)configurationKey, (String)(serviceName + "."));
            serviceConfiguration.put(serviceConfigurationKey, configurationValue);
        }
    }

    protected void callInitOnAllTopiaServices(TopiaApplicationContext topiaApplicationContext, Map<String, TopiaService> services, Map<String, Map<String, String>> servicesConfigurations) {
        for (Map.Entry<String, TopiaService> entry : services.entrySet()) {
            String serviceName = entry.getKey();
            TopiaService topiaService = entry.getValue();
            Map<String, String> serviceConfiguration = servicesConfigurations.get(serviceName);
            if (serviceConfiguration == null) {
                serviceConfiguration = Collections.emptyMap();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("will init service " + serviceName + " with configuration " + serviceConfiguration));
            }
            topiaService.initTopiaService(topiaApplicationContext, serviceConfiguration);
        }
    }

    @Override
    public Map<String, TopiaService> getServices() {
        return this.services;
    }

    @Override
    public <T extends TopiaService> Map<String, T> getServices(Class<T> interfaceService) {
        LinkedHashMap<String, TopiaService> result = new LinkedHashMap<String, TopiaService>();
        for (Map.Entry entry : this.services.entrySet()) {
            String serviceName = (String)entry.getKey();
            TopiaService service = (TopiaService)entry.getValue();
            if (!interfaceService.isAssignableFrom(service.getClass())) continue;
            result.put(serviceName, service);
        }
        return result;
    }
}

