package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: HqlAndParametersBuilderTest.java 2835 2013-10-11 14:16:48Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-4/topia-persistence/src/test/java/org/nuiton/topia/persistence/HqlAndParametersBuilderTest.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.junit.Assert;
import org.junit.Test;

public class HqlAndParametersBuilderTest {

    @Test
    public void testFindAvailableHqlParameterName() {

        HqlAndParametersBuilder hqlAndParametersBuilderTest =
                new HqlAndParametersBuilder(TopiaEntity.class);

        String availableHqlParameterName1 = hqlAndParametersBuilderTest.putHqlParameterWithAvailableName("survey.topiaId", "topiaId1");
        String availableHqlParameterName2 = hqlAndParametersBuilderTest.putHqlParameterWithAvailableName("survey.topiaId", "topiaId1");

        Assert.assertNotEquals(availableHqlParameterName1, availableHqlParameterName2);
        Assert.assertFalse(availableHqlParameterName1.contains("."));
        Assert.assertFalse(availableHqlParameterName2.contains("."));

    }

}
