package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaQueryBuilderRunQueryStep.java 2866 2013-11-08 11:51:51Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-4/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaQueryBuilderRunQueryStep.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Optional;

import java.util.List;

/**
 * @author bleny
 */
public interface TopiaQueryBuilderRunQueryStep<E extends TopiaEntity> {

    boolean exists();

    long count();

    E findUnique();

    E findUniqueOrNull();

    Optional<E> tryFindUnique();

    E findFirst();

    E findFirstOrNull();

    Optional<E> tryFindFirst();

    E findAny();

    E findAnyOrNull();

    Optional<E> tryFindAny();

    List<E> findAll();

    Iterable<E> findAllLazy();

    List<E> find(int startIndex, int endIndex);

    List<String> findAllIds();

    List<String> findIds(int startIndex, int endIndex);

}
