package org.nuiton.topiatest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class CompanyAbstract extends TopiaEntityAbstract implements Company {

    public String name;
    public Collection<Employe> employe;
    public Collection<Bill> storeBill;
    public Collection<Department> department;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Company.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Company.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "employe", Collection.class, Employe.class, employe);
        visitor.visit(this, "storeBill", java.util.Collection.class, Bill.class, storeBill);
        visitor.visit(this, "department", Collection.class, Department.class, department);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<Bill> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(Bill.class);
            List<Bill> findAllByProperties = dao.findAllByProperties("company", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }
        if (getDepartment() != null) {
              tmp.addAll(getDepartment());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * addEmploye :
     * @param employe 
     */

    public void addEmploye(Employe employe) {    
        fireOnPreWrite("employe", null, employe);
        if (this.employe == null) {
            this.employe = new ArrayList<Employe>();
        }
        this.employe.add(employe);
        fireOnPostWrite("employe", this.employe.size(), null, employe);
}

    /**
     * addAllEmploye :
     * @param values 
     */

    public void addAllEmploye(Collection<Employe> values) {
        if (values == null) {
            return;
        }
        for (Employe item : values) {
            addEmploye(item);
        }
}

    /**
     * getEmployeByTopiaId :
     * @param topiaId 
     * @return Employe 
     */

    public Employe getEmployeByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(employe, topiaId);
 }

    /**
     * setEmploye :
     * @param values 
     */

    public void setEmploye(Collection<Employe> values) {
        Collection<Employe> _oldValue = employe;
        fireOnPreWrite("employe", _oldValue, values);
        employe = values;
        fireOnPostWrite("employe", _oldValue, values);
}

    /**
     * removeEmploye :
     * @param value 
     */

    public void removeEmploye(Employe value) {
        fireOnPreWrite("employe", value, null);
        if ((this.employe == null) || (!this.employe.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("employe", this.employe.size()+1, value, null);
}

    /**
     * clearEmploye :
     */

    public void clearEmploye() {
        if (this.employe == null) {
            return;
        }
        Collection<Employe> _oldValue = new ArrayList<Employe>(this.employe);
        fireOnPreWrite("employe", _oldValue, this.employe);
        this.employe.clear();
        fireOnPostWrite("employe", _oldValue, this.employe);
}

    /**
     * getEmploye :
     * @return Collection<Employe> 
     */

    public Collection<Employe> getEmploye() {
        return employe;
}

    /**
     * sizeEmploye :
     * @return int 
     */

    public int sizeEmploye() {
        if (employe == null) {
            return 0;
        }
        return employe.size();
}

    /**
     * isEmployeEmpty :
     * @return boolean 
     */

    public boolean isEmployeEmpty() {
        int size = sizeEmploye();
        return size == 0;
}

    /**
     * addStoreBill :
     * @param value 
     */

    public void addStoreBill(Bill value) {
        fireOnPreWrite("storeBill", null, value);
        if (this.storeBill == null) {
            this.storeBill = new ArrayList<org.nuiton.topiatest.Bill>();
        }
        this.storeBill.add(value);
        fireOnPostWrite("storeBill", this.storeBill.size(), null, value);
}

    /**
     * getStoreBillByTopiaId :
     * @param topiaId 
     * @return Bill 
     */

    public Bill getStoreBillByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(storeBill, topiaId);
}

    /**
     * addAllStoreBill :
     * @param values 
     */

    public void addAllStoreBill(Collection<Bill> values) {
        if (values == null) {
            return;
        }
        for (org.nuiton.topiatest.Bill item : values) {
            addStoreBill(item);
        }
}

    /**
     * setStoreBill :
     * @param values 
     */

    public void setStoreBill(Collection<Bill> values) {
//        clearStoreBill();
//        addAllStoreBill(values);
// FIXME
        Collection<org.nuiton.topiatest.Bill> _oldValue = storeBill;
        fireOnPreWrite("storeBill", _oldValue, values);
        storeBill = values;
        fireOnPostWrite("storeBill", _oldValue, values);
}

    /**
     * removeStoreBill :
     * @param value 
     */

    public void removeStoreBill(Bill value) {
        fireOnPreWrite("storeBill", value, null);
        if ((this.storeBill == null) || (!this.storeBill.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("storeBill", this.storeBill.size()+1, value, null);
}

    /**
     * clearStoreBill :
     */

    public void clearStoreBill() {
        if (this.storeBill == null) {
            return;
        }
        Collection<org.nuiton.topiatest.Bill> _oldValue = new ArrayList<org.nuiton.topiatest.Bill>(this.storeBill);
        fireOnPreWrite("storeBill", _oldValue, null);
        this.storeBill.clear();
        fireOnPostWrite("storeBill", _oldValue, null);
}

    /**
     * getStoreBill :
     * @return Collection<Bill> 
     */

    public Collection<Bill> getStoreBill() {
        return storeBill;
}

    /**
     * getStoreBill :
     * @param value 
     * @return Bill 
     */

    public Bill getStoreBill(Store value) {
        if (value == null || storeBill == null) {
            return null;
        }
        for (org.nuiton.topiatest.Bill item : storeBill) {
            if (value.equals(item.getStore())) {
                return item;
            }
        }
        return null;
}

    /**
     * sizeStoreBill :
     * @return int 
     */

    public int sizeStoreBill() {
        if (storeBill == null) {
            return 0;
        }
        return storeBill.size();
}

    /**
     * isStoreBillEmpty :
     * @return boolean 
     */

    public boolean isStoreBillEmpty() {
        int size = sizeStoreBill();
        return size == 0;
}

    /**
     * addDepartment :
     * @param department 
     */

    public void addDepartment(Department department) {    
        fireOnPreWrite("department", null, department);
        if (this.department == null) {
            this.department = new ArrayList<Department>();
        }
        department.setCompany(this);
        this.department.add(department);
        fireOnPostWrite("department", this.department.size(), null, department);
}

    /**
     * addAllDepartment :
     * @param values 
     */

    public void addAllDepartment(Collection<Department> values) {
        if (values == null) {
            return;
        }
        for (Department item : values) {
            addDepartment(item);
        }
}

    /**
     * getDepartmentByTopiaId :
     * @param topiaId 
     * @return Department 
     */

    public Department getDepartmentByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(department, topiaId);
 }

    /**
     * setDepartment :
     * @param values 
     */

    public void setDepartment(Collection<Department> values) {
        Collection<Department> _oldValue = department;
        fireOnPreWrite("department", _oldValue, values);
        department = values;
        fireOnPostWrite("department", _oldValue, values);
}

    /**
     * removeDepartment :
     * @param value 
     */

    public void removeDepartment(Department value) {
        fireOnPreWrite("department", value, null);
        if ((this.department == null) || (!this.department.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setCompany(null);
        fireOnPostWrite("department", this.department.size()+1, value, null);
}

    /**
     * clearDepartment :
     */

    public void clearDepartment() {
        if (this.department == null) {
            return;
        }
        for (Department item : this.department) {
            item.setCompany(null);
        }
        Collection<Department> _oldValue = new ArrayList<Department>(this.department);
        fireOnPreWrite("department", _oldValue, this.department);
        this.department.clear();
        fireOnPostWrite("department", _oldValue, this.department);
}

    /**
     * getDepartment :
     * @return Collection<Department> 
     */

    public Collection<Department> getDepartment() {
        return department;
}

    /**
     * sizeDepartment :
     * @return int 
     */

    public int sizeDepartment() {
        if (department == null) {
            return 0;
        }
        return department.size();
}

    /**
     * isDepartmentEmpty :
     * @return boolean 
     */

    public boolean isDepartmentEmpty() {
        int size = sizeDepartment();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("employe", this.employe).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.company");
    org.nuiton.i18n.I18n.n_("topia.test.common.name");
    org.nuiton.i18n.I18n.n_("topia.test.common.employe");
    org.nuiton.i18n.I18n.n_("topia.test.common.store");
    org.nuiton.i18n.I18n.n_("topia.test.common.department");
    }

} //CompanyAbstract
