/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.jdbc.Work;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.event.TopiaContextListener;
import org.nuiton.topia.event.TopiaEntitiesVetoable;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.event.TopiaEntityVetoable;
import org.nuiton.topia.event.TopiaTransactionListener;
import org.nuiton.topia.event.TopiaTransactionVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaFiresSupport;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.framework.TopiaService;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;

public class TopiaContextImpl
implements TopiaContextImplementor {
    private static final Log log = LogFactory.getLog(TopiaContextImpl.class);
    @Deprecated
    public static final String TOPIA_PERSISTENCE_DIRECTORIES = "topia.persistence.directories";
    @Deprecated
    public static final String TOPIA_PERSISTENCE_CLASSES = "topia.persistence.classes";
    @Deprecated
    public static final String TOPIA_PERSISTENCE_PROPERTIES_FILE = "topia.persistence.properties.file";
    protected TopiaContextImplementor parentContext;
    protected ServiceRegistry serviceRegistry;
    protected Metadata metadata;
    protected SessionFactory hibernateFactory;
    protected Session hibernate;
    protected boolean closed;
    protected boolean useFlushMode = true;
    protected Properties config;
    protected Map<Class<? extends TopiaEntity>, TopiaDAO<? extends TopiaEntity>> daoCache = new HashMap<Class<? extends TopiaEntity>, TopiaDAO<? extends TopiaEntity>>();
    protected final Set<TopiaContextImplementor> childContext = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    protected Map<String, TopiaService> services;
    protected TopiaFiresSupport firesSupport = new TopiaFiresSupport();
    protected List<Class<?>> persistenceClasses = new ArrayList();

    protected TopiaContextImpl() {
    }

    public TopiaContextImpl(Properties config) throws TopiaNotFoundException {
        this.config = config;
        this.services = this.loadServices(config);
        this.preInitServices(this.services);
        this.getMetadata();
        this.postInitServices(this.services);
    }

    protected String getProperExceptionMessage(Throwable eee) {
        return eee.getClass().getSimpleName() + " : " + eee.getMessage();
    }

    protected Map<String, TopiaService> loadServices(Properties config) {
        HashMap<String, TopiaService> result = new HashMap<String, TopiaService>();
        Enumeration<?> e = config.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.matches("^topia\\.service\\.\\w+$")) continue;
            String classService = config.getProperty(key);
            try {
                Class<?> forName = Class.forName(classService);
                Object newInstance = forName.getConstructor(new Class[0]).newInstance(new Object[0]);
                TopiaService service = (TopiaService)newInstance;
                if (key.equals("topia.service." + service.getServiceName())) {
                    result.put(service.getServiceName(), service);
                    log.info((Object)I18n.t((String)"topia.persistence.service.loaded", (Object[])new Object[]{key, classService}));
                    continue;
                }
                log.warn((Object)I18n.t((String)"topia.persistence.warn.service.not.loaded", (Object[])new Object[]{key, service.getServiceName()}));
            }
            catch (Throwable eee) {
                String message = I18n.t((String)"topia.persistence.error.service.unknown", (Object[])new Object[]{key, classService});
                if (log.isDebugEnabled()) {
                    log.debug((Object)message, eee);
                    continue;
                }
                if (!log.isErrorEnabled()) continue;
                log.error((Object)message);
            }
        }
        return result;
    }

    protected void preInitServices(Map<String, TopiaService> services) {
        for (TopiaService service : services.values()) {
            if (service.preInit(this)) continue;
            log.warn((Object)I18n.t((String)"topia.persistence.warn.service.not.preInit", (Object[])new Object[]{service.getServiceName()}));
        }
    }

    protected void postInitServices(Map<String, TopiaService> services) {
        for (TopiaService service : services.values()) {
            if (service.postInit(this)) continue;
            log.warn((Object)I18n.t((String)"topia.persistence.warn.service.not.postInit", (Object[])new Object[]{service.getServiceName()}));
        }
    }

    protected TopiaService getService(String name) {
        TopiaService result = this.getServices().get(name);
        return result;
    }

    protected boolean serviceEnabled(String name) {
        boolean result = this.getServices().containsKey(name);
        return result;
    }

    protected <E extends TopiaService> String getServiceName(Class<E> interfaceService) throws IllegalAccessException, NoSuchFieldException {
        Field f = interfaceService.getField("SERVICE_NAME");
        String name = (String)f.get(null);
        return name;
    }

    @Override
    public Map<String, TopiaService> getServices() {
        TopiaContextImplementor parent = this.getParentContext();
        Map<String, TopiaService> result = parent != null ? parent.getServices() : this.services;
        return result;
    }

    @Override
    public <E extends TopiaService> E getService(Class<E> interfaceService) throws TopiaNotFoundException {
        TopiaService result;
        try {
            String name = this.getServiceName(interfaceService);
            result = this.getService(name);
        }
        catch (Exception eee) {
            throw new TopiaNotFoundException(I18n.t((String)"topia.persistence.error.service.not.retreaved", (Object[])new Object[]{interfaceService, this.getProperExceptionMessage(eee)}), eee);
        }
        if (result == null) {
            throw new TopiaNotFoundException(I18n.t((String)"topia.persistence.error.service.not.found", (Object[])new Object[]{interfaceService}));
        }
        return (E)result;
    }

    @Override
    public <E extends TopiaService> boolean serviceEnabled(Class<E> interfaceService) {
        boolean result;
        block3: {
            result = false;
            try {
                String name = this.getServiceName(interfaceService);
                result = this.serviceEnabled(name);
            }
            catch (Exception eee) {
                String message = I18n.t((String)"topia.persistence.warn.service.not.found", (Object[])new Object[]{interfaceService, this.getProperExceptionMessage(eee)});
                if (log.isDebugEnabled()) {
                    log.debug((Object)message, (Throwable)eee);
                }
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)message);
            }
        }
        return result;
    }

    @Override
    public Collection<TopiaService> getAllServices() {
        Collection<TopiaService> result = this.getServices().values();
        return result;
    }

    protected TopiaContextImpl(TopiaContextImplementor parentContext) {
        this.parentContext = parentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TopiaContextImplementor> getChildContext() {
        HashSet<TopiaContextImplementor> values;
        Set<TopiaContextImplementor> set = this.childContext;
        synchronized (set) {
            values = new HashSet<TopiaContextImplementor>(this.childContext);
        }
        return values;
    }

    protected void addChildContext(TopiaContextImplementor child) {
        this.childContext.add(child);
    }

    @Override
    public void removeChildContext(TopiaContextImplementor child) {
        if (!this.closed) {
            this.childContext.remove(child);
        }
    }

    @Override
    public TopiaContextImplementor getParentContext() {
        return this.parentContext;
    }

    @Override
    public TopiaContextImplementor getRootContext() {
        TopiaContextImplementor result = this;
        if (this.getParentContext() != null) {
            result = this.getParentContext().getRootContext();
        }
        return result;
    }

    @Override
    public Properties getConfig() {
        if (this.config == null && this.getParentContext() != null) {
            this.config = this.getParentContext().getConfig();
        }
        return this.config;
    }

    @Override
    public void setUseFlushMode(boolean useFlushMode) {
        this.useFlushMode = useFlushMode;
    }

    @Override
    public void createSchema() throws TopiaException {
        try {
            EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.DATABASE);
            if (log.isDebugEnabled()) {
                targetTypes = EnumSet.of(TargetType.DATABASE, TargetType.STDOUT);
            }
            this.getFiresSupport().firePreCreateSchema(this);
            new SchemaExport().createOnly(targetTypes, this.getMetadata());
            this.getFiresSupport().firePostCreateSchema(this);
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.create.schema", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public void updateSchema() throws TopiaException {
        try {
            EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.DATABASE);
            if (log.isDebugEnabled()) {
                targetTypes = EnumSet.of(TargetType.DATABASE, TargetType.STDOUT);
            }
            this.getFiresSupport().firePreUpdateSchema(this);
            new SchemaUpdate().execute(targetTypes, this.getMetadata());
            this.getFiresSupport().firePostUpdateSchema(this);
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.update.schema", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public void showCreateSchema() throws TopiaException {
        try {
            new SchemaExport().createOnly(EnumSet.of(TargetType.STDOUT), this.getMetadata());
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.create.schema", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public Session getHibernate() throws TopiaException {
        if (this.hibernate == null) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.no.hibernate.session", (Object[])new Object[0]));
        }
        return this.hibernate;
    }

    @Override
    public SessionFactory getHibernateFactory() throws TopiaNotFoundException {
        if (this.hibernateFactory == null) {
            if (this.getParentContext() != null) {
                this.hibernateFactory = this.getParentContext().getHibernateFactory();
            } else {
                this.hibernateFactory = this.getMetadata().getSessionFactoryBuilder().build();
                EventListenerRegistry eventListenerRegistry = TopiaUtil.getHibernateService(this.hibernateFactory, EventListenerRegistry.class);
                TopiaFiresSupport.TopiaHibernateEvent listener = new TopiaFiresSupport.TopiaHibernateEvent(this);
                eventListenerRegistry.appendListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.PRE_LOAD, (Object[])new PreLoadEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.PRE_UPDATE, (Object[])new PreUpdateEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.PRE_DELETE, (Object[])new PreDeleteEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.POST_LOAD, (Object[])new PostLoadEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{listener});
                eventListenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{listener});
            }
        }
        return this.hibernateFactory;
    }

    @Override
    public Metadata getMetadata() {
        if (this.metadata == null) {
            if (this.getParentContext() != null) {
                this.metadata = this.getParentContext().getMetadata();
            } else {
                String[] dirs;
                MetadataSources sources = new MetadataSources(this.getServiceRegistry());
                for (String dir : dirs = this.getConfig().getProperty(TOPIA_PERSISTENCE_DIRECTORIES, "").split(",")) {
                    if (!StringUtils.isNotEmpty((CharSequence)(dir = dir.trim()))) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Load persistence from dir : " + dir));
                    }
                    sources.addDirectory(new File(dir));
                }
                HashSet<String> hibernatePersistanceClassNames = new HashSet<String>();
                for (TopiaService service : this.getServices().values()) {
                    Class<?>[] classes = service.getPersistenceClasses();
                    if (classes == null) continue;
                    Class<?>[] classArray = classes;
                    int n = classArray.length;
                    for (int i = 0; i < n; ++i) {
                        Class<?> clazz = classArray[i];
                        hibernatePersistanceClassNames.add(clazz.getName());
                    }
                }
                String listPersistenceClasses = this.getConfig().getProperty(TOPIA_PERSISTENCE_CLASSES, "");
                String[] classes = listPersistenceClasses.split(",");
                for (String string : classes) {
                    String string2 = string.trim();
                    if (!StringUtils.isNotEmpty((CharSequence)string2)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Load persistent class : " + string2));
                    }
                    hibernatePersistanceClassNames.add(string2);
                }
                for (String string : hibernatePersistanceClassNames) {
                    String hbmXmlFile = string.replace('.', '/') + ".hbm.xml";
                    sources.addResource(hbmXmlFile);
                }
                MetadataBuilder metadataBuilder = sources.getMetadataBuilder();
                this.metadata = metadataBuilder.build();
            }
        }
        return this.metadata;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        if (this.serviceRegistry == null) {
            if (this.getParentContext() != null) {
                this.serviceRegistry = this.getParentContext().getServiceRegistry();
            } else {
                StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
                Properties prop = new Properties();
                prop.putAll((Map<?, ?>)this.getConfig());
                Properties propertiesFromClasspath = TopiaUtil.getProperties(this.getConfig().getProperty(TOPIA_PERSISTENCE_PROPERTIES_FILE));
                if (!propertiesFromClasspath.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Load properties from file : " + propertiesFromClasspath));
                    }
                    prop.putAll((Map<?, ?>)propertiesFromClasspath);
                }
                builder.applySettings((Map)prop);
                this.serviceRegistry = builder.build();
            }
        }
        return this.serviceRegistry;
    }

    @Override
    public <E extends TopiaEntity> TopiaDAO<E> getDAO(Class<E> entityClass) throws TopiaException {
        if (entityClass == null) {
            throw new IllegalArgumentException(I18n.t((String)"topia.persistence.error.null.param", (Object[])new Object[]{"entityClass", "getDAO"}));
        }
        if (this.equals(this.getRootContext())) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.rootContext.access", (Object[])new Object[0]));
        }
        if (this.getHibernateFactory().getClassMetadata(entityClass) == null && this.getHibernateFactory().getClassMetadata(entityClass.getName() + "Impl") == null && this.getHibernateFactory().getClassMetadata(entityClass.getName() + "Abstract") == null) {
            log.info((Object)I18n.t((String)"topia.persistence.supported.classes.for.context", (Object[])new Object[]{this.getHibernateFactory().getAllClassMetadata().keySet()}));
            throw new TopiaException(I18n.t((String)"topia.persistence.error.unsupported.class", (Object[])new Object[]{entityClass.getName()}));
        }
        TopiaDAOImpl<E> result = this.daoCache.get(entityClass);
        if (result == null) {
            String daoClassname = entityClass.getName() + "DAO";
            try {
                TopiaDAOImpl<E> spe;
                Class<?> daoClass = Class.forName(daoClassname);
                result = spe = (TopiaDAOImpl<E>)daoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception eee) {
                log.warn((Object)("specialized DAO " + daoClassname + " not found, use default TopiaDAOHibernate"));
                result = new TopiaDAOImpl<E>();
            }
            result.init(this, entityClass);
            this.daoCache.put(entityClass, result);
        }
        return result;
    }

    @Override
    public <E extends TopiaEntity, D extends TopiaDAO<E>> D getDAO(Class<E> entityClass, Class<D> daoClass) throws TopiaException {
        return (D)this.getDAO(entityClass);
    }

    @Override
    public TopiaContext beginTransaction() throws TopiaException {
        this.checkClosed(I18n.t((String)"topia.persistence.error.context.is.closed", (Object[])new Object[0]));
        TopiaContextImpl result = new TopiaContextImpl(this);
        SessionFactory factory = this.getHibernateFactory();
        result.hibernate = factory.openSession();
        result.hibernate.setFlushMode(FlushMode.MANUAL);
        result.useFlushMode = this.useFlushMode;
        try {
            result.hibernate.beginTransaction();
        }
        catch (Exception eee) {
            block4: {
                try {
                    result.hibernate.close();
                }
                catch (HibernateException e1) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Could not close hibernate session", (Throwable)e1);
                }
            }
            throw new TopiaException(I18n.t((String)"topia.persistence.error.open.transaction.failed", (Object[])new Object[]{eee.getMessage()}), eee);
        }
        this.addChildContext(result);
        this.getFiresSupport().fireOnBeginTransaction(result);
        return result;
    }

    @Override
    public void commitTransaction() throws TopiaException {
        if (this.equals(this.getRootContext())) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.unsupported.operation.on.root.context", (Object[])new Object[]{"commit"}));
        }
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"commit"}));
        try {
            Transaction tx = this.hibernate.getTransaction();
            this.hibernate.flush();
            tx.commit();
            this.getFiresSupport().fireOnPostCommit(this);
            TopiaContextImplementor parent = this.getParentContext();
            if (parent != null) {
                parent.getFiresSupport().fireOnPostCommit(this);
            }
            this.hibernate.beginTransaction();
        }
        catch (Exception eee) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.on.commit", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public void rollbackTransaction() throws TopiaException {
        if (this.equals(this.getRootContext())) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.unsupported.operation.on.root.context", (Object[])new Object[]{"rollback"}));
        }
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"rollback"}));
        try {
            Transaction tx = this.hibernate.getTransaction();
            this.hibernate.clear();
            tx.rollback();
            this.hibernate.close();
            this.hibernate = this.getHibernateFactory().openSession();
            this.hibernate.setFlushMode(FlushMode.MANUAL);
            this.hibernate.beginTransaction();
            this.getFiresSupport().fireOnPostRollback(this);
            TopiaContextImplementor parent = this.getParentContext();
            if (parent != null) {
                parent.getFiresSupport().fireOnPostRollback(this);
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.on.rollback", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public void closeContext() throws TopiaException {
        this.checkClosed(I18n.t((String)"topia.persistence.error.context.already.closed", (Object[])new Object[0]));
        for (TopiaContextImplementor child : this.getChildContext()) {
            if (child.isClosed()) continue;
            child.closeContext();
        }
        if (!this.equals(this.getRootContext())) {
            this.closed = true;
            this.hibernate.close();
            this.getParentContext().removeChildContext(this);
        } else {
            ServiceRegistry serviceRegistry = this.getServiceRegistry();
            ConnectionProvider service = (ConnectionProvider)serviceRegistry.getService(ConnectionProvider.class);
            if (service != null && service instanceof Stoppable) {
                Stoppable stoppable = (Stoppable)service;
                stoppable.stop();
            }
            if (this.hibernateFactory != null) {
                ConnectionProvider service2 = TopiaUtil.getHibernateService(this.hibernateFactory, ConnectionProvider.class);
                if (service2 != null && service2 instanceof Stoppable) {
                    Stoppable stoppable = (Stoppable)service2;
                    stoppable.stop();
                }
                this.hibernateFactory.close();
                this.closed = true;
                TopiaContextFactory.removeContext(this);
                log.debug((Object)"TopiaContext removed");
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed && log.isErrorEnabled()) {
            log.error((Object)("TopiaContext " + this + " was not closed!"));
        }
        super.finalize();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void executeSQL(String sqlScript) throws TopiaException {
        SQLWork sqlWork = new SQLWork(sqlScript);
        try {
            this.getHibernate().doWork((Work)sqlWork);
        }
        catch (HibernateException e) {
            throw new TopiaException("Could not execute sql code", e);
        }
    }

    protected void checkClosed(String message) throws TopiaException {
        if (this.closed) {
            throw new TopiaException(message);
        }
    }

    @Override
    public TopiaEntity findByTopiaId(String id) throws TopiaException {
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"findById"}));
        Class entityClass = TopiaId.getClassName(id);
        TopiaDAO dao = this.getDAO(entityClass);
        Object result = dao.findByTopiaId(id);
        return result;
    }

    @Override
    public List<?> findByQuery(TopiaQuery query) throws TopiaException {
        return query.execute(this);
    }

    @Override
    public TopiaQuery createQuery(Class<?> entityClass, String alias) {
        return new TopiaQuery(entityClass, alias);
    }

    @Override
    public List<?> findAll(String hql, Object ... args) throws TopiaException {
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"findAll"}));
        try {
            Query query = this.getHibernate().createQuery(hql);
            for (int j = 0; j < args.length; j += 2) {
                String name = (String)args[j];
                Object value = args[j + 1];
                if (value.getClass().isArray()) {
                    query.setParameterList(name, (Object[])value);
                    continue;
                }
                if (value instanceof Collection) {
                    query.setParameterList(name, (Collection)value);
                    continue;
                }
                query.setParameter(name, value);
            }
            if (this.useFlushMode) {
                query.setFlushMode(FlushMode.AUTO);
            }
            List result = query.list();
            result = this.firesSupport.fireEntitiesLoad(this, result);
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.on.query", (Object[])new Object[]{hql, eee.getMessage()}), eee);
        }
    }

    @Override
    public List<?> find(String hql, int startIndex, int endIndex, Object ... args) throws TopiaException {
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"find"}));
        try {
            Query query = this.getHibernate().createQuery(hql);
            for (int j = 0; j < args.length; j += 2) {
                String name = (String)args[j];
                Object value = args[j + 1];
                if (value.getClass().isArray()) {
                    query.setParameterList(name, (Object[])value);
                    continue;
                }
                if (value instanceof Collection) {
                    query.setParameterList(name, (Collection)value);
                    continue;
                }
                query.setParameter(name, value);
            }
            query.setFirstResult(startIndex);
            query.setMaxResults(endIndex - startIndex + 1);
            if (this.useFlushMode) {
                query.setFlushMode(FlushMode.AUTO);
            }
            List result = query.list();
            result = this.firesSupport.fireEntitiesLoad(this, result);
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.on.query", (Object[])new Object[]{hql, eee.getMessage()}), eee);
        }
    }

    @Override
    public Object findUnique(String hql, Object ... paramNamesAndValues) throws TopiaException {
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"findUnique"}));
        List<?> results = this.find(hql, 0, 1, paramNamesAndValues);
        if (results.size() > 1) {
            String message = String.format("Query '%s' returns more than 1 unique result", hql);
            throw new TopiaException(message);
        }
        Object result = null;
        if (!results.isEmpty()) {
            result = results.get(0);
        }
        return result;
    }

    @Override
    public int execute(String hql, Object ... args) throws TopiaException {
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"find"}));
        try {
            Query query = this.getHibernate().createQuery(hql);
            for (int j = 0; j < args.length; j += 2) {
                query.setParameter((String)args[j], args[j + 1]);
            }
            int result = query.executeUpdate();
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.on.query", (Object[])new Object[]{hql, eee.getMessage()}), eee);
        }
    }

    @Override
    public void add(TopiaEntity e) throws TopiaException {
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"add"}));
        String id = e.getTopiaId();
        Class entityClass = TopiaId.getClassName(id);
        TopiaDAO<TopiaEntity> dao = this.getDAO(entityClass);
        dao.update(e);
    }

    @Override
    public void replicate(TopiaContext dstCtxt, Object ... entityAndCondition) throws TopiaException, IllegalArgumentException {
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicate"}));
        TopiaContextImpl dstContextImpl = (TopiaContextImpl)dstCtxt;
        dstContextImpl.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicate"}));
        if (this.getRootContext().equals(dstContextImpl.getRootContext())) {
            throw new IllegalArgumentException(I18n.t((String)"topia.persistence.error.replicate.on.same.context", (Object[])new Object[0]));
        }
        String[] queries = this.buildQueries(entityAndCondition);
        try {
            for (String query : queries) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("acquire entities " + query));
                }
                List<?> entities = this.findAll(query, new Object[0]);
                this.replicate0(dstContextImpl, entities.toArray());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("replication of entities " + query + " was sucessfully done."));
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.on.replicate", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public <T extends TopiaEntity> void replicateEntity(TopiaContext dstCtxt, T entity) throws TopiaException, IllegalArgumentException {
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicateEntity"}));
        TopiaContextImpl dstContextImpl = (TopiaContextImpl)dstCtxt;
        dstContextImpl.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicateEntity"}));
        if (this.getRootContext().equals(dstContextImpl.getRootContext())) {
            throw new IllegalArgumentException(I18n.t((String)"topia.persistence.error.replicate.on.same.context", (Object[])new Object[0]));
        }
        this.replicate0(dstContextImpl, entity);
    }

    @Override
    public <T extends TopiaEntity> void replicateEntities(TopiaContext dstCtxt, List<T> entities) throws TopiaException, IllegalArgumentException {
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicateEntities"}));
        TopiaContextImpl dstContextImpl = (TopiaContextImpl)dstCtxt;
        dstContextImpl.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicateEntities"}));
        if (this.getRootContext().equals(dstContextImpl.getRootContext())) {
            throw new IllegalArgumentException(I18n.t((String)"topia.persistence.error.replicate.on.same.context", (Object[])new Object[0]));
        }
        this.replicate0(dstContextImpl, entities.toArray());
    }

    @Override
    public TopiaFiresSupport getFiresSupport() {
        return this.firesSupport;
    }

    @Override
    public void backup(File file, boolean compress) throws TopiaException {
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"backup"}));
        try {
            String options = "";
            if (compress) {
                options = options + " COMPRESSION GZIP";
            }
            SQLQuery query = this.getHibernate().createSQLQuery("SCRIPT TO '" + file.getAbsolutePath() + "'" + options);
            query.list();
        }
        catch (Exception eee) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.on.backup", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(File file) throws TopiaException {
        this.getFiresSupport().firePreRestoreSchema(this);
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"restore"}));
        Object sql = null;
        String options = "";
        try {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                ((InputStream)in).mark(2);
                int b = ((InputStream)in).read();
                int magic = ((InputStream)in).read() << 8 | b;
                ((InputStream)in).reset();
                if (magic == 35615) {
                    options = options + " COMPRESSION GZIP";
                }
            }
            SQLQuery query = this.getHibernate().createSQLQuery("RUNSCRIPT FROM '" + file.getAbsolutePath() + "'" + options);
            query.executeUpdate();
            this.getFiresSupport().firePostRestoreSchema(this);
        }
        catch (Exception eee) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.on.restore", (Object[])new Object[]{sql, eee.getMessage()}), eee);
        }
    }

    @Override
    public void clear(boolean dropDatabase) throws TopiaException {
        try {
            TopiaContextImpl root = (TopiaContextImpl)this.getRootContext();
            TopiaContextImpl tx = (TopiaContextImpl)root.beginTransaction();
            String sql = "DROP ALL OBJECTS";
            if (dropDatabase) {
                sql = sql + " DELETE FILES";
            }
            SQLQuery query = tx.getHibernate().createSQLQuery(sql);
            query.executeUpdate();
            tx.closeContext();
            root.closeContext();
            root.hibernateFactory.close();
            root.closed = true;
        }
        catch (Throwable eee) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.on.clear", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    @Override
    public void clearCache() throws TopiaException {
        this.getHibernate().clear();
    }

    @Override
    public List<Class<?>> getPersistenceClasses() {
        return this.persistenceClasses;
    }

    @Override
    public boolean isSchemaExist(Class<?> clazz) throws TopiaException {
        this.checkClosed(I18n.t((String)"topia.persistence.error.unsupported.operation.on.closed.context", (Object[])new Object[]{"replicateEntity"}));
        boolean result = TopiaUtil.isSchemaExist(this, clazz.getName());
        return result;
    }

    @Override
    public void addTopiaEntityListener(TopiaEntityListener listener) {
        this.getFiresSupport().addTopiaEntityListener(listener);
    }

    @Override
    public void addTopiaEntityListener(Class<? extends TopiaEntity> entityClass, TopiaEntityListener listener) {
        this.getFiresSupport().addTopiaEntityListener(entityClass, listener);
    }

    @Override
    public void addTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.getFiresSupport().addTopiaEntityVetoable(TopiaEntity.class, vetoable);
    }

    @Override
    public void addTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass, TopiaEntityVetoable vetoable) {
        this.getFiresSupport().addTopiaEntityVetoable(entityClass, vetoable);
    }

    @Override
    public void addTopiaTransactionListener(TopiaTransactionListener listener) {
        this.getFiresSupport().addTopiaTransactionListener(listener);
    }

    @Override
    public void addTopiaTransactionVetoable(TopiaTransactionVetoable vetoable) {
        this.getFiresSupport().addTopiaTransactionVetoable(vetoable);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getFiresSupport().addPropertyChangeListener(listener);
    }

    @Override
    public void addTopiaContextListener(TopiaContextListener listener) {
        this.getFiresSupport().addTopiaContextListener(listener);
    }

    @Override
    public void removeTopiaEntityListener(TopiaEntityListener listener) {
        this.getFiresSupport().removeTopiaEntityListener(TopiaEntity.class, listener);
    }

    @Override
    public void removeTopiaEntityListener(Class<? extends TopiaEntity> entityClass, TopiaEntityListener listener) {
        this.getFiresSupport().removeTopiaEntityListener(entityClass, listener);
    }

    @Override
    public void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.getFiresSupport().removeTopiaEntityVetoable(TopiaEntity.class, vetoable);
    }

    @Override
    public void removeTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass, TopiaEntityVetoable vetoable) {
        this.getFiresSupport().removeTopiaEntityVetoable(entityClass, vetoable);
    }

    @Override
    public void removeTopiaTransactionListener(TopiaTransactionListener listener) {
        this.getFiresSupport().removeTopiaTransactionListener(listener);
    }

    @Override
    public void removeTopiaTransactionVetoable(TopiaTransactionVetoable vetoable) {
        this.getFiresSupport().removeTopiaTransactionVetoable(vetoable);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getFiresSupport().removePropertyChangeListener(listener);
    }

    @Override
    public void removeTopiaContextListener(TopiaContextListener listener) {
        this.getFiresSupport().removeTopiaContextListener(listener);
    }

    @Override
    public void addTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable) {
        this.getFiresSupport().addTopiaEntitiesVetoable(vetoable);
    }

    @Override
    public void removeTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable) {
        this.getFiresSupport().removeTopiaEntitiesVetoable(vetoable);
    }

    protected String[] buildQueries(Object ... entityAndCondition) throws TopiaException, IllegalArgumentException {
        int i;
        if (entityAndCondition.length == 0) {
            Map classMetadata = this.getHibernateFactory().getAllClassMetadata();
            entityAndCondition = new Object[classMetadata.size() * 2];
            i = 0;
            for (Object className : classMetadata.keySet()) {
                try {
                    entityAndCondition[i++] = Class.forName((String)className);
                }
                catch (ClassNotFoundException e) {
                    throw new TopiaException("class cast exception for entity " + className);
                }
                entityAndCondition[i++] = null;
            }
        }
        if (entityAndCondition.length % 2 != 0) {
            throw new IllegalArgumentException("entityAndCondition must be a couple of (Class, String)");
        }
        String[] queries = new String[entityAndCondition.length / 2];
        i = 0;
        while (i < entityAndCondition.length) {
            try {
                Class entityClass = (Class)entityAndCondition[i++];
                String condition = (String)entityAndCondition[i++];
                String query = "from " + entityClass.getName();
                if (condition != null && !condition.isEmpty()) {
                    query = query + " where " + condition;
                }
                queries[(i - 1) / 2] = query;
            }
            catch (ClassCastException e) {
                if (i % 2 == 0) {
                    throw new IllegalArgumentException("Others arguement must be String not " + entityAndCondition[i - 1], e);
                }
                throw new IllegalArgumentException("Others arguement must be Class not " + entityAndCondition[i - 1], e);
            }
        }
        return queries;
    }

    protected void replicate0(TopiaContextImpl dstContextImpl, Object ... entities) throws TopiaException {
        try {
            for (Object entity : entities) {
                this.getHibernate().evict(entity);
                dstContextImpl.getHibernate().replicate(entity, ReplicationMode.EXCEPTION);
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(I18n.t((String)"topia.persistence.error.on.replicate", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    public static class SQLWork
    implements Work {
        private final String script;

        public SQLWork(String script) {
            this.script = script;
        }

        public void execute(Connection connection) throws SQLException {
            try (PreparedStatement sta = connection.prepareStatement(this.script);){
                sta.execute();
            }
        }
    }
}

