package org.nuiton.topia.it.legacy.test.entities;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.event.ListenableTopiaEntity;

public interface Person extends TopiaEntity, ListenableTopiaEntity {

    String PROPERTY_NAME = "name";

    String PROPERTY_FIRSTNAME = "firstname";

    String PROPERTY_PET = "pet";

    void setName(String name);

    String getName();

    void setFirstname(String firstname);

    String getFirstname();

    void addPet(Pet pet);

    void addAllPet(Iterable<Pet> pet);

    void setPet(Collection<Pet> pet);

    void removePet(Pet pet);

    void clearPet();

    Collection<Pet> getPet();

    Pet getPetByTopiaId(String topiaId);

    Collection<String> getPetTopiaIds();

    int sizePet();

    boolean isPetEmpty();

    boolean isPetNotEmpty();

    boolean containsPet(Pet pet);

} //Person
