/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.nuiton.license.plugin.AbstractLicenseMojo;
import org.nuiton.license.plugin.model.License;
import org.nuiton.license.plugin.model.LicenseStore;
import org.nuiton.license.plugin.model.descriptor.LicenseProjectDescriptor;
import org.nuiton.license.plugin.model.descriptor.io.xpp3.LicenseProjectDescriptorXpp3Reader;
import org.nuiton.plugin.PluginWithEncoding;

public abstract class AbstractLicenseWithDescriptorMojo
extends AbstractLicenseMojo
implements PluginWithEncoding {
    private String encoding;
    @Deprecated
    private File descriptor;
    private String licenseResolver;
    private boolean keepBackup;
    private String licenseName;
    private LicenseStore licenseStore;
    @Deprecated
    private LicenseProjectDescriptor licenseProjectDescriptor;

    public abstract boolean isSkip();

    public abstract void setSkip(boolean var1);

    protected boolean checkSkip() {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skip flag is on, will skip goal.");
            return false;
        }
        return super.checkSkip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws Exception {
        if (this.isSkip()) {
            return;
        }
        LicenseStore licenseStore = this.createLicenseStore(this.getLicenseResolver());
        this.setLicenseStore(licenseStore);
        File descriptorFile = new File(this.getDescriptor().getAbsolutePath());
        if (!descriptorFile.exists()) {
            MavenProject mavenProject = this.getProject().getParent();
            if (mavenProject != null) {
                File basedir = this.getProject().getBasedir();
                String path = descriptorFile.getAbsolutePath().substring(basedir.getAbsolutePath().length() + 1);
                this.setDescriptor(new File(mavenProject.getBasedir() + File.separator + path));
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("try in parent module " + this.getDescriptor()));
                }
            }
            descriptorFile = new File(this.getDescriptor().getAbsolutePath());
        }
        if (!descriptorFile.exists()) {
            this.checkLicense(this.licenseName);
            return;
        }
        this.getLog().warn((CharSequence)"\n");
        this.getLog().warn((CharSequence)"-----------------------------------------------------------------------------------");
        this.getLog().warn((CharSequence)"The usage of License descriptor file is deprecated and will be removed in version 3");
        this.getLog().warn((CharSequence)"-----------------------------------------------------------------------------------");
        this.getLog().warn((CharSequence)"\n");
        this.getLog().info((CharSequence)("Loading descriptor " + descriptorFile));
        LicenseProjectDescriptor licenseProject = null;
        FileReader reader = new FileReader(descriptorFile);
        try {
            licenseProject = new LicenseProjectDescriptorXpp3Reader().read(reader);
            this.setLicenseProjectDescriptor(licenseProject);
        }
        finally {
            reader.close();
        }
        this.validateLicenseProjectDescriptor(licenseProject);
    }

    @Deprecated
    protected void validateLicenseProjectDescriptor(LicenseProjectDescriptor licenseProjectDescriptor) throws MojoFailureException {
        String mainLicense = licenseProjectDescriptor.getMainLicense();
        this.checkLicense(mainLicense);
        this.setLicenseName(mainLicense);
    }

    public License getMainLicense() throws IllegalArgumentException, IllegalStateException, MojoFailureException {
        this.checkLicense(this.licenseName);
        License mainLicense = this.getLicense(this.licenseName);
        return mainLicense;
    }

    public License getLicense(String licenseName) throws IllegalArgumentException, IllegalStateException {
        if (StringUtils.isEmpty((String)licenseName)) {
            throw new IllegalArgumentException("licenseName can not be null, nor empty");
        }
        LicenseStore licenseStore = this.getLicenseStore();
        if (licenseStore == null) {
            throw new IllegalStateException("No license store initialized!");
        }
        License mainLicense = licenseStore.getLicense(licenseName);
        return mainLicense;
    }

    protected void checkLicense(String licenseName) throws IllegalArgumentException, IllegalStateException, MojoFailureException {
        if (StringUtils.isEmpty((String)licenseName)) {
            throw new IllegalArgumentException("licenseName can not be null, nor empty");
        }
        LicenseStore licenseStore = this.getLicenseStore();
        if (licenseStore == null) {
            throw new IllegalStateException("No license store initialized!");
        }
        License mainLicense = licenseStore.getLicense(licenseName);
        if (mainLicense == null) {
            throw new MojoFailureException("License named '" + mainLicense + "' is unknown, use one of " + Arrays.toString(licenseStore.getLicenseNames()));
        }
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Deprecated
    public File getDescriptor() {
        return this.descriptor;
    }

    public boolean isKeepBackup() {
        return this.keepBackup;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public String getLicenseResolver() {
        return this.licenseResolver;
    }

    public LicenseStore getLicenseStore() {
        return this.licenseStore;
    }

    @Deprecated
    public LicenseProjectDescriptor getLicenseProjectDescriptor() {
        return this.licenseProjectDescriptor;
    }

    public void setKeepBackup(boolean keepBackup) {
        this.keepBackup = keepBackup;
    }

    @Deprecated
    public void setDescriptor(File descriptor) {
        this.descriptor = descriptor;
    }

    public void setLicenseResolver(String licenseResolver) {
        this.licenseResolver = licenseResolver;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public void setLicenseStore(LicenseStore licenseStore) {
        this.licenseStore = licenseStore;
    }

    @Deprecated
    public void setLicenseProjectDescriptor(LicenseProjectDescriptor licenseProjectDescriptor) {
        this.licenseProjectDescriptor = licenseProjectDescriptor;
    }
}

