/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.util.Arrays;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixException;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.Vector;
import org.nuiton.math.matrix.VectorIterator;
import org.nuiton.math.matrix.VectorIteratorImpl;

public class DoubleBigVector
implements Vector {
    protected double[] data = null;

    public DoubleBigVector() {
    }

    public DoubleBigVector(long capacity) {
        this.init(capacity);
    }

    @Override
    public void init(long capacity) {
        if (capacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Dense vector max capacity is '%s' asked '%s'", Integer.MAX_VALUE, capacity));
        }
        if (this.data == null) {
            try {
                this.data = new double[(int)capacity];
            }
            catch (OutOfMemoryError eee) {
                throw new MatrixException("Can't create vector with capacity = " + capacity, eee);
            }
        }
    }

    @Override
    public String getInfo() {
        return "Double vector dense: " + this.size();
    }

    @Override
    public long getNumberOfAssignedValue() {
        return this.size();
    }

    @Override
    public long size() {
        return this.data.length;
    }

    @Override
    @Deprecated
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        return MatrixHelper.maxOccurrence(this.data);
    }

    @Override
    public double getValue(long pos) {
        return this.data[(int)pos];
    }

    @Override
    public void setValue(long pos, double value) {
        this.data[(int)pos] = value;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof DoubleBigVector) {
            DoubleBigVector other = (DoubleBigVector)o;
            result = Arrays.equals(this.data, other.data);
        } else if (o instanceof Vector) {
            Vector other = (Vector)o;
            result = this.size() == other.size();
            int i = 0;
            while ((long)i < this.size() && result) {
                result = this.getValue(i) == other.getValue(i);
                ++i;
            }
        }
        return result;
    }

    public int hashCode() {
        return Long.hashCode(this.size());
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return v instanceof DoubleBigVector;
    }

    @Override
    public boolean isImplementedMap() {
        return true;
    }

    @Override
    public void paste(Vector src) {
        DoubleBigVector fbv = (DoubleBigVector)src;
        System.arraycopy(fbv.data, 0, this.data, 0, (int)this.size());
    }

    @Override
    public void map(MapFunction f) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = f.apply(this.data[i]);
        }
    }

    @Override
    public VectorIterator iterator() {
        return new VectorIteratorImpl(this);
    }

    @Override
    public VectorIterator iteratorNotZero() {
        return new VectorIteratorImpl(this, 0.0);
    }
}

