/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixException;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.Vector;
import org.nuiton.math.matrix.VectorForEachFunction;
import org.nuiton.math.matrix.VectorIterator;
import org.nuiton.math.matrix.VectorIteratorImpl;

public class DoubleBigMappedVector
implements Vector {
    private static Log log = LogFactory.getLog(DoubleBigMappedVector.class);
    public static final int DOUBLE_SIZE = 8;
    protected File file;
    protected long capacity;
    protected DoubleBuffer data = null;
    protected boolean readonly = false;

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.file != null) {
            this.file.delete();
        }
    }

    public DoubleBigMappedVector() {
    }

    public DoubleBigMappedVector(long capacity) throws IOException {
        this.init(capacity);
    }

    @Override
    public String getInfo() {
        return "Double dense mapped: " + this.data.capacity();
    }

    @Override
    public long getNumberOfAssignedValue() {
        return this.data.capacity();
    }

    @Override
    public void init(long capacity) {
        if (capacity * 8L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Mapped max capacity is '%s' asked '%s'", 0xFFFFFFF, capacity));
        }
        try {
            if (this.data == null) {
                this.capacity = capacity;
                this.file = File.createTempFile("matrix", ".mapped");
                this.file.deleteOnExit();
                RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
                this.data = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, capacity * 8L).asDoubleBuffer();
            }
        }
        catch (IOException eee) {
            throw new MatrixException("Can't init vector", eee);
        }
    }

    public DoubleBigMappedVector(RandomAccessFile raf, long offset, long capacity) throws IOException {
        if (capacity * 8L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Mapped max capacity is '%s' asked '%s'", 0xFFFFFFF, capacity));
        }
        this.capacity = capacity;
        try {
            this.data = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, offset, capacity * 8L).asDoubleBuffer();
        }
        catch (Exception eee) {
            log.error((Object)"Can't use mapped file, only read available");
            this.readonly = true;
            byte[] tmp = new byte[(int)capacity * 8];
            long currentOffset = raf.getFilePointer();
            raf.seek(offset);
            raf.readFully(tmp);
            raf.seek(currentOffset);
            ByteBuffer buf = ByteBuffer.wrap(tmp);
            this.data = buf.asDoubleBuffer();
        }
    }

    public DoubleBigMappedVector(MappedByteBuffer bytes, long capacity) {
        this(bytes.asDoubleBuffer(), capacity);
    }

    public DoubleBigMappedVector(DoubleBuffer data, long capacity) {
        this.capacity = capacity;
        this.data = data;
    }

    @Override
    public long size() {
        return this.capacity;
    }

    @Override
    @Deprecated
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        this.data.position(0);
        double[] tmp = new double[(int)this.capacity];
        this.data.get(tmp);
        return MatrixHelper.maxOccurrence(tmp);
    }

    @Override
    public double getValue(long pos) {
        return this.data.get((int)pos);
    }

    @Override
    public void setValue(long pos, double value) {
        if (this.readonly) {
            throw new MatrixException("This object is Read only, perhaps because your system (Windows?) doesn't support large mapped file");
        }
        this.data.put((int)pos, value);
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = this == o;
        if (!result) {
            if (o instanceof DoubleBigMappedVector) {
                DoubleBigMappedVector other = (DoubleBigMappedVector)o;
                other.data.position(0);
                this.data.position(0);
                result = this.data.equals(other.data);
            } else if (o instanceof Vector) {
                Vector other = (Vector)o;
                result = true;
                int i = 0;
                while ((long)i < this.size() && result) {
                    result = this.getValue(i) == other.getValue(i);
                    ++i;
                }
            }
        }
        return result;
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return v instanceof DoubleBigMappedVector;
    }

    @Override
    public boolean isImplementedMap() {
        return true;
    }

    @Override
    public void paste(Vector src) {
        if (this.readonly) {
            throw new MatrixException("This object is Read only, perhaps because your system (Windows?) doesn't support large mapped file");
        }
        DoubleBigMappedVector dbmSrc = (DoubleBigMappedVector)src;
        dbmSrc.data.position(0);
        this.data.position(0);
        this.data.put(dbmSrc.data);
    }

    @Override
    public void add(Vector v) {
        if (this.readonly) {
            throw new MatrixException("This object is Read only, perhaps because your system (Windows?) doesn't support large mapped file");
        }
        Vector.super.add(v);
    }

    @Override
    public void minus(Vector v) {
        if (this.readonly) {
            throw new MatrixException("This object is Read only, perhaps because your system (Windows?) doesn't support large mapped file");
        }
        Vector.super.minus(v);
    }

    @Override
    public void map(MapFunction f) {
        if (this.readonly) {
            throw new MatrixException("This object is Read only, perhaps because your system (Windows?) doesn't support large mapped file");
        }
        int i = 0;
        while ((long)i < this.capacity) {
            double v = this.data.get(i);
            v = f.apply(v);
            this.data.put(i, v);
            ++i;
        }
    }

    @Override
    public VectorIterator iterator() {
        return new VectorIteratorImpl(this);
    }

    @Override
    public VectorIterator iteratorNotZero() {
        return new VectorIteratorImpl(this, 0.0);
    }

    @Override
    public void forEach(VectorForEachFunction f) {
        if (this.readonly) {
            throw new MatrixException("This object is Read only, perhaps because your system (Windows?) doesn't support large mapped file");
        }
        Vector.super.forEach(f);
    }

    @Override
    public void forEachNotZero(VectorForEachFunction f) {
        if (this.readonly) {
            throw new MatrixException("This object is Read only, perhaps because your system (Windows?) doesn't support large mapped file");
        }
        Vector.super.forEachNotZero(f);
    }
}

