/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: TimeEntryXpp3Reader.java 186 2011-05-20 12:32:08Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.2/jredmine-client/src/main/java/org/nuiton/jredmine/model/io/xpp3/TimeEntryXpp3Reader.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine.model.io.xpp3;

import org.nuiton.io.xpp3.AbstractXpp3Reader;
import static org.nuiton.io.xpp3.Xpp3Helper.addTagTextContentMappers;
import org.nuiton.jredmine.model.TimeEntry;

import java.beans.IntrospectionException;

/**
 * Created: 31 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 186 $
 *          <p/>
 *          Mise a jour: $Date: 2011-05-20 14:32:08 +0200 (Fri, 20 May 2011) $ par :
 *          $Author: tchemit $
 */
public class TimeEntryXpp3Reader extends AbstractXpp3Reader<TimeEntry> {

    public TimeEntryXpp3Reader() {
        super(TimeEntry.class, "time-entries", "time-entry");
    }

    @Override
    protected void initMappers() throws IntrospectionException {

        addTagTextContentMappers(TimeEntry.class, RedmineDataConverter.Integer, true, allMappers,
                "id",
                "activity-id",
                "issue-id",
                "project-id",
                "user-id",
                "tyear",
                "tmonth",
                "tweek"
        );

        addTagTextContentMappers(TimeEntry.class, RedmineDataConverter.Float, true, allMappers,
                "hours"
        );

        addTagTextContentMappers(TimeEntry.class, RedmineDataConverter.Datetime, true, allMappers,
                "created-on",
                "updated-on");

        addTagTextContentMappers(TimeEntry.class, RedmineDataConverter.Date, true, allMappers,
                "spent-on");

        addTagTextContentMappers(TimeEntry.class, RedmineDataConverter.Text, true, allMappers,
                "comments");
    }
}
