/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.tool;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.service.DefaultRedmineService;
import org.nuiton.jredmine.service.RedmineConfigurationUtil;
import org.nuiton.jredmine.service.RedmineServiceConfiguration;
import org.nuiton.jredmine.service.RedmineServiceException;

public class FetchProjectsVersionsTool {
    private static final Log log = LogFactory.getLog(FetchProjectsVersionsTool.class);

    public void run(File configFile) throws RedmineServiceException, IOException {
        Project[] projects;
        RedmineServiceConfiguration configuration = RedmineConfigurationUtil.newAnonymousConfiguration(configFile);
        DefaultRedmineService service = new DefaultRedmineService();
        service.init(configuration);
        SimpleDateFormat df = new SimpleDateFormat("yyy-MM-dd");
        File tempDirectory = new File(FileUtils.getTempDirectory(), "project-versions_" + System.nanoTime());
        if (log.isInfoEnabled()) {
            log.info((Object)("Generate in " + tempDirectory));
        }
        for (Project project : projects = service.getProjects()) {
            if (!project.isOpen() || !project.isIsPublic()) continue;
            String projectName = project.getIdentifier();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load versions of " + projectName));
            }
            Version[] versions = service.getVersions(projectName);
            this.printProjectVersions(df, tempDirectory, projectName, versions);
        }
    }

    protected void printProjectVersions(DateFormat df, File tempDirectory, String projectName, Version ... versions) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Version version : versions) {
            if (!version.isClosed()) continue;
            sb.append(version.getName()).append(":").append(df.format(version.getEffectiveDate())).append("\n");
        }
        File versionFile = new File(tempDirectory, projectName + ".versions");
        if (log.isInfoEnabled()) {
            log.info((Object)("Write " + versionFile));
        }
        FileUtils.write((File)versionFile, (CharSequence)sb.toString());
    }
}

