/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.editor.gis;

import java.util.regex.Matcher;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.converter.NuitonConverter;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.swing.editor.gis.DmdCoordinate;

public class DmdCoordinateConverter
implements NuitonConverter<DmdCoordinate> {
    protected boolean useSign;
    protected boolean forLongitude;

    public void setUseSign(boolean useSign) {
        this.useSign = useSign;
    }

    public void setForLongitude(boolean forLongitude) {
        this.forLongitude = forLongitude;
    }

    public <T> T convert(Class<T> aClass, Object value) {
        if (!this.isEnabled(aClass)) {
            throw new ConversionException(I18n.t((String)"jaxx.error.no.convertor.coordinateDmd", (Object[])new Object[]{value}));
        }
        Object result = null;
        if (value == null) {
            if (aClass.equals(String.class)) {
                result = String.format("%s%s\u00b0%s'%s", this.useSign ? "-" : "", StringUtils.leftPad((String)"", (int)(this.forLongitude ? 3 : 2), (char)' '), StringUtils.leftPad((String)"", (int)2, (char)' '), StringUtils.leftPad((String)"", (int)2, (char)' '));
            }
        } else if (aClass.equals(value.getClass())) {
            result = value;
        } else if (value instanceof String) {
            Matcher matcher = DmdCoordinate.COORDINATE_PATTERN.matcher((String)value);
            if (matcher.matches()) {
                String degresStr = matcher.group(1).replaceAll("\\s", "");
                String minutesStr = matcher.group(2).replaceAll("\\s", "");
                String decimalesStr = matcher.group(3).replaceAll("\\s", "");
                Integer degre = degresStr.isEmpty() || "-".equals(degresStr) ? null : Integer.valueOf(Math.abs(Integer.valueOf(degresStr)));
                Integer minutes = minutesStr.isEmpty() ? null : Integer.valueOf(minutesStr);
                Integer decimal = decimalesStr.isEmpty() ? null : Integer.valueOf(decimalesStr);
                boolean signed = degresStr.contains("-");
                result = DmdCoordinate.valueOf(signed, degre, minutes, decimal);
            }
        } else if (value instanceof DmdCoordinate) {
            DmdCoordinate coordinate = (DmdCoordinate)((Object)value);
            boolean sign = coordinate.isSign();
            String signStr = sign ? "-" : "";
            Integer degree = coordinate.getDegree();
            String degreeStr = degree == null ? "" : degree.toString();
            Integer minute = coordinate.getMinute();
            String minuteStr = minute == null ? "" : minute.toString();
            Integer decimal = coordinate.getDecimal();
            String decimalStr = decimal == null ? "" : decimal.toString();
            result = String.format("%s%s\u00b0%s'%s", signStr, StringUtils.leftPad((String)degreeStr, (int)(this.forLongitude ? 3 : 2), (char)' '), StringUtils.leftPad((String)minuteStr, (int)2, (char)' '), StringUtils.leftPad((String)decimalStr, (int)2, (char)' '));
        }
        return aClass.cast(result);
    }

    protected boolean isEnabled(Class<?> aClass) {
        return String.class.isAssignableFrom(aClass) || DmdCoordinate.class.isAssignableFrom(aClass);
    }

    public Class<DmdCoordinate> getType() {
        return DmdCoordinate.class;
    }
}

