/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.editor.bean;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.nuiton.decorator.DecoratorUtil;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.decorator.MultiJXPathDecorator;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.nuiton.jaxx.runtime.swing.editor.bean.BeanUIUtil;
import org.nuiton.jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.nuiton.util.beans.BeanUtil;

public class BeanComboBoxHandler<O>
implements PropertyChangeListener {
    public static final Log log = LogFactory.getLog(BeanComboBoxHandler.class);
    protected final BeanComboBox<O> ui;
    protected Method mutator;
    protected Document originalDocument;
    protected ObjectToStringConverter convertor;
    protected MultiJXPathDecorator<O> decorator;
    protected boolean init;
    protected final FocusListener EDITOR_TEXT_COMP0NENT_FOCUSLISTENER = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("close popup from " + e));
            }
            BeanComboBoxHandler.this.ui.getPopup().setVisible(false);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    };
    private final BeanUIUtil.PopupHandler popupHandler = new BeanUIUtil.PopupHandler(){

        @Override
        public JPopupMenu getPopup() {
            return BeanComboBoxHandler.this.ui.getPopup();
        }

        @Override
        public JComponent getInvoker() {
            return BeanComboBoxHandler.this.ui.getChangeDecorator();
        }
    };

    public BeanComboBoxHandler(BeanComboBox<O> ui) {
        this.ui = ui;
    }

    public void init(JXPathDecorator<O> decorator, List<O> data) {
        if (this.init) {
            throw new IllegalStateException("can not init the handler twice");
        }
        this.init = true;
        if (decorator == null) {
            throw new NullPointerException("decorator can not be null (for type " + this.ui.getBeanType() + ")");
        }
        JAXXButtonGroup indexes = this.ui.getIndexes();
        this.decorator = BeanUIUtil.createDecorator(decorator);
        final JComboBox combobox = this.ui.getCombobox();
        combobox.setRenderer(new DecoratorListCellRenderer(this.decorator));
        combobox.addPopupMenuListener(new PopupMenuListener(){
            private O selectedItem;
            boolean canceled = false;

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                this.selectedItem = combobox.getSelectedItem();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Object newSelectedItem = combobox.getSelectedItem();
                if (this.canceled) {
                    BeanComboBoxHandler.this.ui.setSelectedItem(null);
                } else if (newSelectedItem == null ^ this.selectedItem == null || newSelectedItem != null && !this.selectedItem.equals(newSelectedItem)) {
                    BeanComboBoxHandler.this.ui.setSelectedItem(newSelectedItem);
                }
                this.selectedItem = null;
                this.canceled = false;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.canceled = true;
            }
        });
        this.convertor = BeanUIUtil.newDecoratedObjectToStringConverter(this.decorator);
        JTextComponent editorComponent = (JTextComponent)combobox.getEditor().getEditorComponent();
        this.originalDocument = editorComponent.getDocument();
        this.popupHandler.preparePopup(this.ui.getSelectedToolTipText(), this.ui.getNotSelectedToolTipText(), this.ui.getI18nPrefix(), this.ui.getPopupTitleText(), (ButtonGroup)indexes, this.ui.getPopupSeparator(), this.ui.getPopupLabel(), this.ui.getSortUp(), this.ui.getSortDown(), this.decorator);
        this.ui.autoComplete = true;
        this.ui.addPropertyChangeListener(this);
        this.ui.setData(data);
        indexes.setSelectedButton((Object)this.ui.getIndex());
    }

    public void togglePopup() {
        this.popupHandler.togglePopup();
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.ui.getData());
    }

    public void addItems(Iterable<O> items) {
        List<O> data = this.ui.getData();
        boolean wasEmpty = CollectionUtils.isEmpty(data);
        for (O item : items) {
            data.add(item);
        }
        this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
        this.fireEmpty(wasEmpty);
    }

    public void removeItems(Iterable<O> items) {
        List<O> data = this.ui.getData();
        boolean needUpdate = false;
        for (O item : items) {
            boolean remove = data.remove(item);
            if (!remove) continue;
            Object selectedItem = this.ui.getSelectedItem();
            if (item == selectedItem) {
                this.ui.setSelectedItem(null);
            }
            needUpdate = true;
        }
        if (needUpdate) {
            this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
            this.fireEmpty(false);
        }
    }

    public void addItem(O item) {
        this.addItems(Collections.singleton(item));
    }

    public void removeItem(O item) {
        this.removeItems(Collections.singleton(item));
    }

    public void sortData() {
        this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
    }

    public void focusCombo() {
        if (this.ui.isAutoFocus().booleanValue()) {
            this.ui.combobox.requestFocusInWindow();
        }
    }

    protected void setAutoComplete(Boolean oldValue, Boolean newValue) {
        if ((oldValue = Boolean.valueOf(oldValue != null && oldValue != false)).equals(newValue = Boolean.valueOf(newValue != null && newValue != false))) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("autocomplete state : <" + oldValue + " to " + newValue + ">"));
        }
        if (!newValue.booleanValue()) {
            JTextComponent editorComponent = (JTextComponent)this.ui.getCombobox().getEditor().getEditorComponent();
            editorComponent.removeFocusListener(this.EDITOR_TEXT_COMP0NENT_FOCUSLISTENER);
            BeanUIUtil.undecorate(this.ui.getCombobox(), this.originalDocument);
        } else {
            BeanUIUtil.decorate(this.ui.getCombobox(), this.convertor);
            JTextComponent editorComponent = (JTextComponent)this.ui.getCombobox().getEditor().getEditorComponent();
            editorComponent.addFocusListener(this.EDITOR_TEXT_COMP0NENT_FOCUSLISTENER);
        }
    }

    protected void setIndex(Integer oldValue, Integer newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("check state : <" + oldValue + " to " + newValue + ">"));
        }
        this.updateUI(newValue, this.ui.isReverseSort());
    }

    protected void setSortOrder(Boolean oldValue, Boolean newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("check state : <" + oldValue + " to " + newValue + ">"));
        }
        this.updateUI(this.ui.getIndex(), newValue);
    }

    protected void updateUI(int index, boolean reversesort) {
        this.decorator.setContextIndex(index);
        Object previousSelectedItem = this.ui.getSelectedItem();
        Boolean wasAutoComplete = this.ui.isAutoComplete();
        if (wasAutoComplete.booleanValue()) {
            this.ui.setAutoComplete(false);
        }
        if (previousSelectedItem != null) {
            this.ui.getCombobox().setSelectedItem(null);
            this.ui.selectedItem = null;
        }
        List<O> data = this.ui.getData();
        if (this.ui.isSortable().booleanValue()) {
            try {
                DecoratorUtil.sort(this.decorator, data, (int)index, (boolean)reversesort);
            }
            catch (Exception eee) {
                log.warn((Object)eee.getMessage(), (Throwable)eee);
            }
        }
        SwingUtil.fillComboBox((JComboBox)this.ui.getCombobox(), data, null);
        if (wasAutoComplete.booleanValue()) {
            this.ui.setAutoComplete(true);
        }
        if (previousSelectedItem != null) {
            this.ui.setSelectedItem(previousSelectedItem);
        }
        this.ui.getCombobox().requestFocus();
    }

    protected void setSelectedItem(O oldValue, O newValue) {
        if (this.ui.getBean() == null) {
            return;
        }
        if (newValue == null) {
            if (this.ui.getCombobox().getSelectedItem() == null) {
                return;
            }
            this.ui.getCombobox().setSelectedItem(null);
            if (this.ui.isAutoComplete().booleanValue()) {
                this.ui.setAutoComplete(false);
                this.ui.setAutoComplete(true);
            }
            if (oldValue == null) {
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.ui.getProperty() + " on " + this.getBeanType() + " :: " + oldValue + " to " + newValue));
        }
        BeanUIUtil.invokeMethod(this.getMutator(), this.ui.getBean(), newValue);
    }

    public Document getOriginalDocument() {
        return this.originalDocument;
    }

    public MultiJXPathDecorator<O> getDecorator() {
        return this.decorator;
    }

    public Class<O> getBeanType() {
        Class<O> result = this.ui.getBeanType();
        if (result == null) {
            result = this.decorator == null ? null : this.decorator.getType();
        }
        return result;
    }

    @Deprecated
    public Class<?> getTargetClass() {
        Method m = this.getMutator();
        return m == null ? null : m.getParameterTypes()[0];
    }

    protected Method getMutator() {
        if (this.mutator == null && this.ui.getBean() != null && this.ui.getProperty() != null) {
            this.mutator = BeanUtil.getMutator((Object)this.ui.getBean(), (String)this.ui.getProperty());
        }
        return this.mutator;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("selectedItem".equals(propertyName)) {
            this.setSelectedItem(evt.getOldValue(), evt.getNewValue());
            return;
        }
        if ("autoComplete".equals(propertyName)) {
            this.setAutoComplete((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            return;
        }
        if ("index".equals(propertyName)) {
            this.setIndex((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
            return;
        }
        if ("reverseSort".equals(propertyName)) {
            this.setSortOrder((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            return;
        }
        if ("data".equals(propertyName)) {
            this.setIndex(-1, this.ui.getIndex());
            List list = (List)evt.getOldValue();
            this.fireEmpty(CollectionUtils.isEmpty((Collection)list));
        }
    }

    protected void fireEmpty(boolean wasEmpty) {
        this.ui.firePropertyChange("empty", wasEmpty, this.isEmpty());
    }
}

