package org.nuiton.jaxx.widgets.number;

/*
 * #%L
 * JAXX :: Widgets Number
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.css.DataBinding;
import jaxx.runtime.css.Pseudoclasses;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class NumberEditor extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AUTO_POPUP = "autoPopup";
    public static final String PROPERTY_POPUP_VISIBLE = "popupVisible";
    public static final String PROPERTY_SHOW_POPUP_BUTTON = "showPopupButton";
    public static final String PROPERTY_SHOW_RESET = "showReset";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLEAR_ALL_BUTTON_ENABLED = "clearAllButton.enabled";
    public static final String BINDING_DOT_BUTTON_ENABLED = "dotButton.enabled";
    public static final String BINDING_LEFT_TOOLBAR_ENABLED = "leftToolbar.enabled";
    public static final String BINDING_LEFT_TOOLBAR_VISIBLE = "leftToolbar.visible";
    public static final String BINDING_RESET_BUTTON_ENABLED = "resetButton.enabled";
    public static final String BINDING_RIGHT_TOOLBAR_ENABLED = "rightToolbar.enabled";
    public static final String BINDING_RIGHT_TOOLBAR_VISIBLE = "rightToolbar.visible";
    public static final String BINDING_SHOW_POP_UP_BUTTON_ENABLED = "showPopUpButton.enabled";
    public static final String BINDING_TEXT_FIELD_ENABLED = "textField.enabled";
    public static final String BINDING_TEXT_FIELD_TEXT = "textField.text";
    public static final String BINDING_TOGGLE_SIGN_BUTTON_ENABLED = "toggleSignButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAL1XS08cRxDuXWAxTz8I2JZB2sSW5ShmWB42ICzH5iVjgY0Mfshc0rvTLO3MTrd7emAJcpSfkJ+Q3HOJlFtOUQ4555BLlL8QRTnkGqW6Z2dmZ5jZHbSKLbws3dVffV1d/VX1d3+iHkegD9/get0Qri1pjRiPH7569bT8hlTkKnEqgnLJBPL+5fIov4cGzGDckej63qZaPtVYPrXCapzZxG5avbSJ+h15bBHngBAp0UR0RcVxpnaC6aU6d4WPGpBKQv3m77/yX5tffZtHqM6B3QRspdhuVbiT7k2Up6ZEl8DTIZ6ysF0FGoLaVeA7pMZWLOw4T3CNvEVfot5NVOBYAJhEH2XfssbQ6+tconM3Hm9jm1gliT5homrYLpXMNjTpI2pWiXRgrFYmwniif62ZYCA41xAFiXpqzCSWRKUzrN5SS0KIPuxKts24C3wuqm0aauvGMmMWwXZod945YEfabtmV4EcNX2yCUdPPiENkbGKQqzUvqEPLFonN9XDP75jyWzecI4i28Vg72SK2Gxr2a0MdKzihqLUaVGZXAushb9fzHlGJRiILQvrXgIFJq1TGFi6EJsVWdovt7IYrEEPx0LISDPVUDHAuo+M7Ge3uZiP41CblbASnMzqeyWg3286u70bjvEqhTXDOvR5IKX35BcmqVYvs0Kp92tM5xonASrZ8ZyaTGcyGD7FFTSxJ3DYgNmCRfbkLN6iMhUQfRNJPDS9joSz7YAvExnAvzGClUFcoBrwV3jJJ6nKdEsuMX5pdfyIFeFDQ6oHPSY09TTH07/lz7l+fqzH+KqIhw5ccdPZaRGdBwY1QwUOJze2hHuHCsERX9k6L/jOY8uT+SkzuFaCe/Xds5Lcf//hh3df4IvgeTTRtKlGgvVyoQ5RUuT7vCbwrqTW1hfnSHmgXsaC+6fo1nkBspzEN5MCfJ5JqufEIOwcA0dP7+08/j332axfKr6N+i2FzHSv7DYjvARzoAbPMOv/0gWY0eHQOPi/A/y44z32wlir+kLn72IKzRwXG8Vu3aWCozIRJxDamtiSmP16HOI0nxCkgW+775Z+Rne8f+LHKAferqeZhvHpeowK1LWoTXREbxS6xAg5wh7gmC4taUplDqtD5ad+Q9LL+3D8VklyYj7DvE+qseX/c+vhd3VVLbL0R9Q1wOY+lbxpst4o0q7hONNKDeiwWV21qy0mHfgHf89NzUH32mSBVwVwbrLrLlksSyACVhlTxiAq9D06910ulxcVSqR2tqJS9D2ZdgphtgxVWmjRKeYAt48rnPuzQyQqzmDBePtrYXXsHd8a7IhJNnizrb94FPDYqgoBQr9W4PPYmbs3dLjZ+knIq0mrwDNl66DU2ICuQrTt+D5SYr9G6kAG8W6k9CP2J7vIMaOiUyr/AkIApDsL60A4+38x9tMG9qb0DB8C3huu05tZ29OmOndjkqLgKymE7FCxm5m7PpAQxUm3aUTlbvvXDyYL3jYoqTZe8DoDoxnZS105gLcHvLuW7OnoTzSaGt9jQloakPPGUmmrw/8j9coR7BVsV11J3M76B8aQNqCKdxj9ewbOkQiC6frJRZwXbzx3dOulcaCRjhLURtldJRE51X2diMhpjsspkM5HhCBEj8TYE/dyZHF9udrzS6OCbXY9GXPs9fhKD2APgTDSWkmkUb94sBrdcacIKvELlNnOoSgyYv18staQK3X46VZjMRjUXy+aIo0m/Q050FG2fO8rO10Sw9KRIqIfBy6OUeZuJ0NMtoKc7g55pAT3TGfRsC+jZzqDnWkDPdQZ9pwX0nc6g77aAvtsZ9HwL6PnOoBdaQC90Br3YAnoxM/SA7gmPiGoCVMes3j+tmkCQ6hpzHcIOVQ+XoXnu3Ef7nvOUj4LNRA0n6Hyql2z9NjgqWPiYueo07oEy4mKZ2ia8tu+f8pVTn/1tjwCGc+p1nmPJCONZWttAdS/d896DRSyloGVXkhRiDwH2Px1hHUVFFgAA";
    private static final Log log = LogFactory.getLog(NumberEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean autoPopup;
    protected JButton clearAllButton;
    protected JButton clearOnebutton;
    protected JButton dotButton;
    protected final NumberEditorHandler handler = createHandler();
    protected JToolBar leftToolbar;
    protected NumberEditorModel model;
    protected JButton number0;
    protected JButton number1Button;
    protected JButton number2Button;
    protected JButton number3Button;
    protected JButton number4Button;
    protected JButton number5Button;
    protected JButton number6Button;
    protected JButton number7Button;
    protected JButton number8Button;
    protected JButton number9Button;
    protected JPopupMenu popup;
    protected JPanel popupPanel;
    protected Boolean popupVisible;
    protected JButton resetButton;
    protected JToolBar rightToolbar;
    protected JToggleButton showPopUpButton;
    protected Boolean showPopupButton;
    protected Boolean showReset;
    protected JTextField textField;
    protected JButton toggleSignButton;
    protected JButton validateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private NumberEditor $JPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    // Config delegate methods
    public void setProperty(String property) { model.getConfig().setProperty(property); }
    public void setUseSign(boolean useSign) { model.getConfig().setUseSign(useSign); }
    public void setNumberType(Class<?> numberType) { model.getConfig().setNumberType(numberType); }
    public void setSelectAllTextOnError(boolean selectAllTextOnError) { model.getConfig().setSelectAllTextOnError(selectAllTextOnError); }
    
    // Model delegate methods
    public void setBean(Serializable bean) { model.setBean(bean); }
    public void setNumberValue(Number numberValue) { model.setNumberValue(numberValue); }
    public void setNumberPattern(String numberPattern) { model.setNumberPattern(numberPattern); }
    
    public void init() { handler.init(); }
    
    void showPopup() {
       if ( popupVisible || autoPopup ) {
           if (!popupVisible) {
               setPopupVisible(true);
           } else if (!getPopup().isVisible()) {
               handler.setPopupVisible(true);
           }
       }
    }
    
    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        textField.setToolTipText(toolTipText);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NumberEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NumberEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NumberEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public NumberEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NumberEditor() {
        $initialize();
    }

    public NumberEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__clearAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.reset();
    }

    public void doActionPerformed__on__clearOnebutton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeChar();
    }

    public void doActionPerformed__on__dotButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('.');
    }

    public void doActionPerformed__on__number0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('0');
    }

    public void doActionPerformed__on__number1Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('1');
    }

    public void doActionPerformed__on__number2Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('2');
    }

    public void doActionPerformed__on__number3Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('3');
    }

    public void doActionPerformed__on__number4Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('4');
    }

    public void doActionPerformed__on__number5Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('5');
    }

    public void doActionPerformed__on__number6Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('6');
    }

    public void doActionPerformed__on__number7Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('7');
    }

    public void doActionPerformed__on__number8Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('8');
    }

    public void doActionPerformed__on__number9Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('9');
    }

    public void doActionPerformed__on__resetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.reset();
    }

    public void doActionPerformed__on__showPopUpButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setPopupVisible(!popup.isVisible());
    }

    public void doActionPerformed__on__toggleSignButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.toggleSign();
    }

    public void doActionPerformed__on__validateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.validate();
    }

    public void doFocusGained__on__$JPanel0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        textField.requestFocus();
    }

    public void doFocusGained__on__textField(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopup();
    }

    public void doFocusLost__on__$JPanel0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPopupVisible(false);popup.setVisible(false);
    }

    public void doKeyReleased__on__textField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setTextValue(textField.getText());
    }

    public void doMouseEntered__on__clearAllButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, clearAllButton, "font-weight", "bold", Pseudoclasses.wrap((clearAllButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (clearAllButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                clearAllButton.setFont(clearAllButton.getFont().deriveFont(clearAllButton.getFont().getStyle() | Font.BOLD));
            } else {
                clearAllButton.setFont(clearAllButton.getFont().deriveFont(clearAllButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__clearOnebutton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, clearOnebutton, "font-weight", "bold", Pseudoclasses.wrap((clearOnebutton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (clearOnebutton.getFont() != null) {
            if (((String) value).equals("bold")) {
                clearOnebutton.setFont(clearOnebutton.getFont().deriveFont(clearOnebutton.getFont().getStyle() | Font.BOLD));
            } else {
                clearOnebutton.setFont(clearOnebutton.getFont().deriveFont(clearOnebutton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__dotButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, dotButton, "font-weight", "normal", Pseudoclasses.wrap((dotButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (dotButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                dotButton.setFont(dotButton.getFont().deriveFont(dotButton.getFont().getStyle() | Font.BOLD));
            } else {
                dotButton.setFont(dotButton.getFont().deriveFont(dotButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number0, "font-weight", "bold", Pseudoclasses.wrap((number0.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number0.getFont() != null) {
            if (((String) value).equals("bold")) {
                number0.setFont(number0.getFont().deriveFont(number0.getFont().getStyle() | Font.BOLD));
            } else {
                number0.setFont(number0.getFont().deriveFont(number0.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number1Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number1Button, "font-weight", "bold", Pseudoclasses.wrap((number1Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number1Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number1Button.setFont(number1Button.getFont().deriveFont(number1Button.getFont().getStyle() | Font.BOLD));
            } else {
                number1Button.setFont(number1Button.getFont().deriveFont(number1Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number2Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number2Button, "font-weight", "bold", Pseudoclasses.wrap((number2Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number2Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number2Button.setFont(number2Button.getFont().deriveFont(number2Button.getFont().getStyle() | Font.BOLD));
            } else {
                number2Button.setFont(number2Button.getFont().deriveFont(number2Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number3Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number3Button, "font-weight", "bold", Pseudoclasses.wrap((number3Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number3Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number3Button.setFont(number3Button.getFont().deriveFont(number3Button.getFont().getStyle() | Font.BOLD));
            } else {
                number3Button.setFont(number3Button.getFont().deriveFont(number3Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number4Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number4Button, "font-weight", "bold", Pseudoclasses.wrap((number4Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number4Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number4Button.setFont(number4Button.getFont().deriveFont(number4Button.getFont().getStyle() | Font.BOLD));
            } else {
                number4Button.setFont(number4Button.getFont().deriveFont(number4Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number5Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number5Button, "font-weight", "bold", Pseudoclasses.wrap((number5Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number5Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number5Button.setFont(number5Button.getFont().deriveFont(number5Button.getFont().getStyle() | Font.BOLD));
            } else {
                number5Button.setFont(number5Button.getFont().deriveFont(number5Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number6Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number6Button, "font-weight", "bold", Pseudoclasses.wrap((number6Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number6Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number6Button.setFont(number6Button.getFont().deriveFont(number6Button.getFont().getStyle() | Font.BOLD));
            } else {
                number6Button.setFont(number6Button.getFont().deriveFont(number6Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number7Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number7Button, "font-weight", "bold", Pseudoclasses.wrap((number7Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number7Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number7Button.setFont(number7Button.getFont().deriveFont(number7Button.getFont().getStyle() | Font.BOLD));
            } else {
                number7Button.setFont(number7Button.getFont().deriveFont(number7Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number8Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number8Button, "font-weight", "bold", Pseudoclasses.wrap((number8Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number8Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number8Button.setFont(number8Button.getFont().deriveFont(number8Button.getFont().getStyle() | Font.BOLD));
            } else {
                number8Button.setFont(number8Button.getFont().deriveFont(number8Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number9Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number9Button, "font-weight", "bold", Pseudoclasses.wrap((number9Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number9Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number9Button.setFont(number9Button.getFont().deriveFont(number9Button.getFont().getStyle() | Font.BOLD));
            } else {
                number9Button.setFont(number9Button.getFont().deriveFont(number9Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__toggleSignButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, toggleSignButton, "font-weight", "normal", Pseudoclasses.wrap((toggleSignButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (toggleSignButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                toggleSignButton.setFont(toggleSignButton.getFont().deriveFont(toggleSignButton.getFont().getStyle() | Font.BOLD));
            } else {
                toggleSignButton.setFont(toggleSignButton.getFont().deriveFont(toggleSignButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JPanel0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPopupVisible(false);popup.setVisible(false);
    }

    public void doMouseExited__on__clearAllButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, clearAllButton, "font-weight", "bold", Pseudoclasses.wrap((clearAllButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (clearAllButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                clearAllButton.setFont(clearAllButton.getFont().deriveFont(clearAllButton.getFont().getStyle() | Font.BOLD));
            } else {
                clearAllButton.setFont(clearAllButton.getFont().deriveFont(clearAllButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__clearOnebutton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, clearOnebutton, "font-weight", "bold", Pseudoclasses.wrap((clearOnebutton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (clearOnebutton.getFont() != null) {
            if (((String) value).equals("bold")) {
                clearOnebutton.setFont(clearOnebutton.getFont().deriveFont(clearOnebutton.getFont().getStyle() | Font.BOLD));
            } else {
                clearOnebutton.setFont(clearOnebutton.getFont().deriveFont(clearOnebutton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__dotButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, dotButton, "font-weight", "normal", Pseudoclasses.wrap((dotButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (dotButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                dotButton.setFont(dotButton.getFont().deriveFont(dotButton.getFont().getStyle() | Font.BOLD));
            } else {
                dotButton.setFont(dotButton.getFont().deriveFont(dotButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number0, "font-weight", "bold", Pseudoclasses.wrap((number0.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number0.getFont() != null) {
            if (((String) value).equals("bold")) {
                number0.setFont(number0.getFont().deriveFont(number0.getFont().getStyle() | Font.BOLD));
            } else {
                number0.setFont(number0.getFont().deriveFont(number0.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number1Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number1Button, "font-weight", "bold", Pseudoclasses.wrap((number1Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number1Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number1Button.setFont(number1Button.getFont().deriveFont(number1Button.getFont().getStyle() | Font.BOLD));
            } else {
                number1Button.setFont(number1Button.getFont().deriveFont(number1Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number2Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number2Button, "font-weight", "bold", Pseudoclasses.wrap((number2Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number2Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number2Button.setFont(number2Button.getFont().deriveFont(number2Button.getFont().getStyle() | Font.BOLD));
            } else {
                number2Button.setFont(number2Button.getFont().deriveFont(number2Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number3Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number3Button, "font-weight", "bold", Pseudoclasses.wrap((number3Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number3Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number3Button.setFont(number3Button.getFont().deriveFont(number3Button.getFont().getStyle() | Font.BOLD));
            } else {
                number3Button.setFont(number3Button.getFont().deriveFont(number3Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number4Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number4Button, "font-weight", "bold", Pseudoclasses.wrap((number4Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number4Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number4Button.setFont(number4Button.getFont().deriveFont(number4Button.getFont().getStyle() | Font.BOLD));
            } else {
                number4Button.setFont(number4Button.getFont().deriveFont(number4Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number5Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number5Button, "font-weight", "bold", Pseudoclasses.wrap((number5Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number5Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number5Button.setFont(number5Button.getFont().deriveFont(number5Button.getFont().getStyle() | Font.BOLD));
            } else {
                number5Button.setFont(number5Button.getFont().deriveFont(number5Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number6Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number6Button, "font-weight", "bold", Pseudoclasses.wrap((number6Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number6Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number6Button.setFont(number6Button.getFont().deriveFont(number6Button.getFont().getStyle() | Font.BOLD));
            } else {
                number6Button.setFont(number6Button.getFont().deriveFont(number6Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number7Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number7Button, "font-weight", "bold", Pseudoclasses.wrap((number7Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number7Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number7Button.setFont(number7Button.getFont().deriveFont(number7Button.getFont().getStyle() | Font.BOLD));
            } else {
                number7Button.setFont(number7Button.getFont().deriveFont(number7Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number8Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number8Button, "font-weight", "bold", Pseudoclasses.wrap((number8Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number8Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number8Button.setFont(number8Button.getFont().deriveFont(number8Button.getFont().getStyle() | Font.BOLD));
            } else {
                number8Button.setFont(number8Button.getFont().deriveFont(number8Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number9Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number9Button, "font-weight", "bold", Pseudoclasses.wrap((number9Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number9Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number9Button.setFont(number9Button.getFont().deriveFont(number9Button.getFont().getStyle() | Font.BOLD));
            } else {
                number9Button.setFont(number9Button.getFont().deriveFont(number9Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__toggleSignButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, toggleSignButton, "font-weight", "normal", Pseudoclasses.wrap((toggleSignButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (toggleSignButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                toggleSignButton.setFont(toggleSignButton.getFont().deriveFont(toggleSignButton.getFont().getStyle() | Font.BOLD));
            } else {
                toggleSignButton.setFont(toggleSignButton.getFont().deriveFont(toggleSignButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopUpButton.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopUpButton.setSelected(false);
    }

    public void doPopupMenuWillBecomeVisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopUpButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAutoPopup() {
        return autoPopup;
    }

    public JButton getClearAllButton() {
        return clearAllButton;
    }

    public JButton getClearOnebutton() {
        return clearOnebutton;
    }

    public JButton getDotButton() {
        return dotButton;
    }

    public NumberEditorHandler getHandler() {
        return handler;
    }

    public JToolBar getLeftToolbar() {
        return leftToolbar;
    }

    public NumberEditorModel getModel() {
        return model;
    }

    public JButton getNumber0() {
        return number0;
    }

    public JButton getNumber1Button() {
        return number1Button;
    }

    public JButton getNumber2Button() {
        return number2Button;
    }

    public JButton getNumber3Button() {
        return number3Button;
    }

    public JButton getNumber4Button() {
        return number4Button;
    }

    public JButton getNumber5Button() {
        return number5Button;
    }

    public JButton getNumber6Button() {
        return number6Button;
    }

    public JButton getNumber7Button() {
        return number7Button;
    }

    public JButton getNumber8Button() {
        return number8Button;
    }

    public JButton getNumber9Button() {
        return number9Button;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public JPanel getPopupPanel() {
        return popupPanel;
    }

    public Boolean getPopupVisible() {
        return popupVisible;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public JToolBar getRightToolbar() {
        return rightToolbar;
    }

    public JToggleButton getShowPopUpButton() {
        return showPopUpButton;
    }

    public Boolean getShowPopupButton() {
        return showPopupButton;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public JTextField getTextField() {
        return textField;
    }

    public JButton getToggleSignButton() {
        return toggleSignButton;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public Boolean isAutoPopup() {
        return autoPopup !=null && autoPopup;
    }

    public Boolean isPopupVisible() {
        return popupVisible !=null && popupVisible;
    }

    public Boolean isShowPopupButton() {
        return showPopupButton !=null && showPopupButton;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAutoPopup(Boolean autoPopup) {
        Boolean oldValue = this.autoPopup;
        this.autoPopup = autoPopup;
        firePropertyChange(PROPERTY_AUTO_POPUP, oldValue, autoPopup);
    }

    public void setPopupVisible(Boolean popupVisible) {
        Boolean oldValue = this.popupVisible;
        this.popupVisible = popupVisible;
        firePropertyChange(PROPERTY_POPUP_VISIBLE, oldValue, popupVisible);
    }

    public void setShowPopupButton(Boolean showPopupButton) {
        Boolean oldValue = this.showPopupButton;
        this.showPopupButton = showPopupButton;
        firePropertyChange(PROPERTY_SHOW_POPUP_BUTTON, oldValue, showPopupButton);
    }

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToLeftToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        leftToolbar.add(resetButton);
    }

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add(popupPanel);
    }

    protected void addChildrenToPopupPanel() {
        if (!allComponentsCreated) {
            return;
        }
        popupPanel.add(number7Button);
        popupPanel.add(number8Button);
        popupPanel.add(number9Button);
        popupPanel.add(clearAllButton);
        popupPanel.add(number4Button);
        popupPanel.add(number5Button);
        popupPanel.add(number6Button);
        popupPanel.add(clearOnebutton);
        popupPanel.add(number1Button);
        popupPanel.add(number2Button);
        popupPanel.add(number3Button);
        popupPanel.add($JButton0);
        popupPanel.add(number0);
        popupPanel.add(toggleSignButton);
        popupPanel.add(dotButton);
        popupPanel.add(validateButton);
    }

    protected void addChildrenToRightToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        rightToolbar.add(showPopUpButton);
    }

    protected void createAutoPopup() {
        $objectMap.put("autoPopup", autoPopup = false);
    }

    protected void createClearAllButton() {
        $objectMap.put("clearAllButton", clearAllButton = new JButton());
        
        clearAllButton.setName("clearAllButton");
        clearAllButton.setFocusable(false);
        clearAllButton.setText(t("numbereditor.clearAll"));
        clearAllButton.setFocusPainted(false);
        if (clearAllButton.getFont() != null) {
            clearAllButton.setFont(clearAllButton.getFont().deriveFont((float) 14));
        }
        clearAllButton.setForeground(new Color(255, 0, 0));
        clearAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clearAllButton"));
        clearAllButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__clearAllButton"));
        clearAllButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__clearAllButton"));
    }

    protected void createClearOnebutton() {
        $objectMap.put("clearOnebutton", clearOnebutton = new JButton());
        
        clearOnebutton.setName("clearOnebutton");
        clearOnebutton.setFocusable(false);
        clearOnebutton.setFocusPainted(false);
        if (clearOnebutton.getFont() != null) {
            clearOnebutton.setFont(clearOnebutton.getFont().deriveFont((float) 14));
        }
        clearOnebutton.setForeground(new Color(255, 0, 0));
        clearOnebutton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clearOnebutton"));
        clearOnebutton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__clearOnebutton"));
        clearOnebutton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__clearOnebutton"));
    }

    protected void createDotButton() {
        $objectMap.put("dotButton", dotButton = new JButton());
        
        dotButton.setName("dotButton");
        dotButton.setFocusable(false);
        dotButton.setText(t("numbereditor.."));
        dotButton.setFocusPainted(false);
        if (dotButton.getFont() != null) {
            dotButton.setFont(dotButton.getFont().deriveFont((float) 14));
        }
        dotButton.setForeground(new Color(0, 153, 0));
        dotButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dotButton"));
        dotButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__dotButton"));
        dotButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__dotButton"));
    }

    protected NumberEditorHandler createHandler() {
        return new NumberEditorHandler();
    }

    protected void createLeftToolbar() {
        $objectMap.put("leftToolbar", leftToolbar = new JToolBar());
        
        leftToolbar.setName("leftToolbar");
        leftToolbar.setFloatable(false);
        leftToolbar.setOpaque(false);
        leftToolbar.setBorderPainted(false);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(NumberEditorModel.class));
    }

    protected void createNumber0() {
        $objectMap.put("number0", number0 = new JButton());
        
        number0.setName("number0");
        number0.setFocusable(false);
        number0.setFocusPainted(false);
        if (number0.getFont() != null) {
            number0.setFont(number0.getFont().deriveFont((float) 14));
        }
        number0.setForeground(new Color(0, 0, 255));
        number0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number0"));
        number0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number0"));
        number0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number0"));
    }

    protected void createNumber1Button() {
        $objectMap.put("number1Button", number1Button = new JButton());
        
        number1Button.setName("number1Button");
        number1Button.setFocusable(false);
        number1Button.setText(t("numbereditor.1"));
        number1Button.setFocusPainted(false);
        if (number1Button.getFont() != null) {
            number1Button.setFont(number1Button.getFont().deriveFont((float) 14));
        }
        number1Button.setForeground(new Color(0, 0, 255));
        number1Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number1Button"));
        number1Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number1Button"));
        number1Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number1Button"));
    }

    protected void createNumber2Button() {
        $objectMap.put("number2Button", number2Button = new JButton());
        
        number2Button.setName("number2Button");
        number2Button.setFocusable(false);
        number2Button.setText(t("numbereditor.2"));
        number2Button.setFocusPainted(false);
        if (number2Button.getFont() != null) {
            number2Button.setFont(number2Button.getFont().deriveFont((float) 14));
        }
        number2Button.setForeground(new Color(0, 0, 255));
        number2Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number2Button"));
        number2Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number2Button"));
        number2Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number2Button"));
    }

    protected void createNumber3Button() {
        $objectMap.put("number3Button", number3Button = new JButton());
        
        number3Button.setName("number3Button");
        number3Button.setFocusable(false);
        number3Button.setText(t("numbereditor.3"));
        number3Button.setFocusPainted(false);
        if (number3Button.getFont() != null) {
            number3Button.setFont(number3Button.getFont().deriveFont((float) 14));
        }
        number3Button.setForeground(new Color(0, 0, 255));
        number3Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number3Button"));
        number3Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number3Button"));
        number3Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number3Button"));
    }

    protected void createNumber4Button() {
        $objectMap.put("number4Button", number4Button = new JButton());
        
        number4Button.setName("number4Button");
        number4Button.setFocusable(false);
        number4Button.setText(t("numbereditor.4"));
        number4Button.setFocusPainted(false);
        if (number4Button.getFont() != null) {
            number4Button.setFont(number4Button.getFont().deriveFont((float) 14));
        }
        number4Button.setForeground(new Color(0, 0, 255));
        number4Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number4Button"));
        number4Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number4Button"));
        number4Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number4Button"));
    }

    protected void createNumber5Button() {
        $objectMap.put("number5Button", number5Button = new JButton());
        
        number5Button.setName("number5Button");
        number5Button.setFocusable(false);
        number5Button.setText(t("numbereditor.5"));
        number5Button.setFocusPainted(false);
        if (number5Button.getFont() != null) {
            number5Button.setFont(number5Button.getFont().deriveFont((float) 14));
        }
        number5Button.setForeground(new Color(0, 0, 255));
        number5Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number5Button"));
        number5Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number5Button"));
        number5Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number5Button"));
    }

    protected void createNumber6Button() {
        $objectMap.put("number6Button", number6Button = new JButton());
        
        number6Button.setName("number6Button");
        number6Button.setFocusable(false);
        number6Button.setText(t("numbereditor.6"));
        number6Button.setFocusPainted(false);
        if (number6Button.getFont() != null) {
            number6Button.setFont(number6Button.getFont().deriveFont((float) 14));
        }
        number6Button.setForeground(new Color(0, 0, 255));
        number6Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number6Button"));
        number6Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number6Button"));
        number6Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number6Button"));
    }

    protected void createNumber7Button() {
        $objectMap.put("number7Button", number7Button = new JButton());
        
        number7Button.setName("number7Button");
        number7Button.setFocusable(false);
        number7Button.setText(t("numbereditor.7"));
        number7Button.setFocusPainted(false);
        if (number7Button.getFont() != null) {
            number7Button.setFont(number7Button.getFont().deriveFont((float) 14));
        }
        number7Button.setForeground(new Color(0, 0, 255));
        number7Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number7Button"));
        number7Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number7Button"));
        number7Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number7Button"));
    }

    protected void createNumber8Button() {
        $objectMap.put("number8Button", number8Button = new JButton());
        
        number8Button.setName("number8Button");
        number8Button.setFocusable(false);
        number8Button.setText(t("numbereditor.8"));
        number8Button.setFocusPainted(false);
        if (number8Button.getFont() != null) {
            number8Button.setFont(number8Button.getFont().deriveFont((float) 14));
        }
        number8Button.setForeground(new Color(0, 0, 255));
        number8Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number8Button"));
        number8Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number8Button"));
        number8Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number8Button"));
    }

    protected void createNumber9Button() {
        $objectMap.put("number9Button", number9Button = new JButton());
        
        number9Button.setName("number9Button");
        number9Button.setFocusable(false);
        number9Button.setText(t("numbereditor.9"));
        number9Button.setFocusPainted(false);
        if (number9Button.getFont() != null) {
            number9Button.setFont(number9Button.getFont().deriveFont((float) 14));
        }
        number9Button.setForeground(new Color(0, 0, 255));
        number9Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number9Button"));
        number9Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number9Button"));
        number9Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number9Button"));
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeVisible", this, "doPopupMenuWillBecomeVisible__on__popup"));
    }

    protected void createPopupPanel() {
        $objectMap.put("popupPanel", popupPanel = new JPanel());
        
        popupPanel.setName("popupPanel");
        popupPanel.setLayout(new GridLayout(4,4));
    }

    protected void createPopupVisible() {
        $objectMap.put("popupVisible", popupVisible = false);
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setFocusable(false);
        resetButton.setFocusPainted(false);
        resetButton.setToolTipText(t("numbereditor.action.reset.tip"));
        resetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
    }

    protected void createRightToolbar() {
        $objectMap.put("rightToolbar", rightToolbar = new JToolBar());
        
        rightToolbar.setName("rightToolbar");
        rightToolbar.setFloatable(false);
        rightToolbar.setOpaque(false);
        rightToolbar.setBorderPainted(false);
    }

    protected void createShowPopUpButton() {
        $objectMap.put("showPopUpButton", showPopUpButton = new JToggleButton());
        
        showPopUpButton.setName("showPopUpButton");
        showPopUpButton.setFocusable(false);
        showPopUpButton.setFocusPainted(false);
        showPopUpButton.setToolTipText(t("numbereditor.action.show.tip"));
        showPopUpButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__showPopUpButton"));
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = false);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createTextField() {
        $objectMap.put("textField", textField = new JTextField());
        
        textField.setName("textField");
        textField.setColumns(15);
        textField.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__textField"));
        textField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textField"));
    }

    protected void createToggleSignButton() {
        $objectMap.put("toggleSignButton", toggleSignButton = new JButton());
        
        toggleSignButton.setName("toggleSignButton");
        toggleSignButton.setFocusable(false);
        toggleSignButton.setText(t("numbereditor.toggleSign"));
        toggleSignButton.setFocusPainted(false);
        if (toggleSignButton.getFont() != null) {
            toggleSignButton.setFont(toggleSignButton.getFont().deriveFont((float) 14));
        }
        toggleSignButton.setForeground(new Color(0, 153, 0));
        toggleSignButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__toggleSignButton"));
        toggleSignButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__toggleSignButton"));
        toggleSignButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__toggleSignButton"));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(leftToolbar, BorderLayout.WEST);
        add(textField, BorderLayout.CENTER);
        add(rightToolbar, BorderLayout.EAST);
        addChildrenToPopup();
        addChildrenToPopupPanel();
        addChildrenToLeftToolbar();
        addChildrenToRightToolbar();
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        popupPanel.setBackground(Color.WHITE);
        popupPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        validateButton.setIcon(SwingUtil.createActionIcon("numbereditor-validate"));
        resetButton.setIcon(SwingUtil.createActionIcon("numbereditor-reset"));
        rightToolbar.setMaximumSize(new Dimension(24,24));
        showPopUpButton.setIcon(SwingUtil.createActionIcon("numbereditor-calculator"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createAutoPopup();
        createShowPopupButton();
        createShowReset();
        createPopupVisible();
        createPopup();
        createPopupPanel();
        createNumber7Button();
        createNumber8Button();
        createNumber9Button();
        createClearAllButton();
        createNumber4Button();
        createNumber5Button();
        createNumber6Button();
        createClearOnebutton();
        createNumber1Button();
        createNumber2Button();
        createNumber3Button();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setEnabled(false);
        createNumber0();
        createToggleSignButton();
        createDotButton();
        createValidateButton();
        createLeftToolbar();
        createResetButton();
        createTextField();
        createRightToolbar();
        createShowPopUpButton();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        $JPanel0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$JPanel0"));
        $JPanel0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__$JPanel0"));
        $JPanel0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JPanel0"));
        
        // registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLEAR_ALL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canClearAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    clearAllButton.setEnabled(model.isCanClearAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canClearAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOGGLE_SIGN_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canUseSign", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    toggleSignButton.setEnabled(model.isCanUseSign());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canUseSign", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOT_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canUseDot", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dotButton.setEnabled(model.isCanUseDot());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canUseDot", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LEFT_TOOLBAR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                leftToolbar.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LEFT_TOOLBAR_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                leftToolbar.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                resetButton.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEXT_FIELD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                textField.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("textValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(textField, model.getTextValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("textValue", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RIGHT_TOOLBAR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                rightToolbar.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RIGHT_TOOLBAR_VISIBLE, true ,"showPopupButton") {
        
            @Override
            public void processDataBinding() {
                rightToolbar.setVisible(isShowPopupButton());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SHOW_POP_UP_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                showPopUpButton.setEnabled(isEnabled());
            }
        });
    }

}