package jaxx.runtime.validator.swing;
/*
 * #%L
 * JAXX :: Validator
 * $Id: SwingListValidatorMessageTableRenderer.java 2783 2014-02-04 07:27:32Z tchemit $
 * $HeadURL: https://nuiton.org/svn/jaxx/tags/jaxx-2.8.6/jaxx-validator/src/main/java/jaxx/runtime/validator/swing/SwingListValidatorMessageTableRenderer.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.validator.NuitonValidatorScope;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import java.awt.Component;

import static org.nuiton.i18n.I18n.t;

/**
 * TODO
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5.3
 */
public class SwingListValidatorMessageTableRenderer extends DefaultTableCellRenderer {

    private static final long serialVersionUID = 1L;

    @Override
    public Component getTableCellRendererComponent(JTable table,
                                                   Object value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int row,
                                                   int column) {
        JLabel rendererComponent = (JLabel)
                super.getTableCellRendererComponent(
                        table,
                        value,
                        isSelected,
                        hasFocus,
                        row,
                        column
                );

        ImageIcon icon = null;
        String text = null;
        String toolTipText = null;

        column = table.convertColumnIndexToModel(column);
        if (table.getRowSorter() != null) {
            row = table.getRowSorter().convertRowIndexToModel(row);
        }

        switch (column) {
            case 0:
                // scope
                NuitonValidatorScope scope = (NuitonValidatorScope) value;
                icon = SwingValidatorUtil.getIcon(scope);
                String label = t(scope.getLabel());
                toolTipText = t("validator.scope.tip", label);
                break;

            case 1:
                // row bean
                text = getBeanValue(table, row);
                toolTipText = t("validator.bean.tip", text);
                break;

            case 2:
                // field name
                text = getFieldName(table, (String) value, row);
                toolTipText = t("validator.field.tip", text);
                break;

            case 3:
                // message
                text = getMessage(table, (String) value, row);
                toolTipText = t("validator.message.tip", text);
                break;
        }

        rendererComponent.setText(text);
        rendererComponent.setToolTipText(toolTipText);
        rendererComponent.setIcon(icon);
        return rendererComponent;
    }

    public ImageIcon getIcon(NuitonValidatorScope scope) {
        ImageIcon icon = SwingValidatorUtil.getIcon(scope);
        return icon;
    }

    public String getMessage(JTable table, String value, int row) {
        SwingListValidatorMessageTableModel tableModel =
                (SwingListValidatorMessageTableModel) table.getModel();
        SwingListValidatorMessage model = tableModel.getRow(row);
        String text = SwingValidatorUtil.getMessage(model);
        return text;
    }

    public String getFieldName(JTable table, String value, int row) {
        SwingListValidatorMessageTableModel tableModel =
                (SwingListValidatorMessageTableModel) table.getModel();
        SwingListValidatorMessage model = tableModel.getRow(row);
        String fieldName = SwingValidatorUtil.getFieldName(model, value);
        return fieldName;
    }

    public String getBeanValue(JTable table, int row) {
        SwingListValidatorMessageTableModel tableModel =
                (SwingListValidatorMessageTableModel) table.getModel();
        SwingListValidatorMessage model = tableModel.getRow(row);
        String text = decorateBean(model.getBean());
        return text;
    }

    protected String decorateBean(Object bean) {
        return bean.toString();
    }
}
