/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id: DemoUIHandler.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.4.1/jaxx-tutorial-validation/src/main/java/jaxx/demo/validation/ui/DemoUIHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
/**
 * *##% 
 * JAXX Demo
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.demo.validation.ui;

import jaxx.demo.validation.DemoConfig;
import jaxx.demo.validation.RunDemo;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

import javax.swing.SwingUtilities;
import java.awt.Desktop;
import java.net.URL;
import java.util.Locale;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * Le handler de l'ui principale.
 *
 * @author tchemit <chemit@codelutin.com>
 * @see DemoUI
 */
public class DemoUIHandler { //implements JAXXHelp {

    /** Logger */
    static private Log log = LogFactory.getLog(DemoUIHandler.class);

    static final JAXXContextEntryDef<DemoUI> MAIN_UI_ENTRY_DEF = JAXXUtil.newContextEntryDef("mainui", DemoUI.class);

    /**
     * Methode pour initialiser l'ui principale sans l'afficher.
     *
     * @param rootContext le context applicatif
     * @param config      la configuration a utiliser
     * @return l'ui instancie et initialisee mais non visible encore
     */
    public DemoUI initUI(DefaultApplicationContext rootContext, DemoConfig config) {

        if (log.isDebugEnabled()) {
            log.debug("fullscreen ? " + config.isFullScreen());
        }

//        DecoratorProvider decoratorProvider = rootContext.getContextValue(DecoratorProvider.class);

        if (!config.getLocale().equals(I18n.getDefaultLocale())) {
            if (log.isInfoEnabled()) {
                log.info("re-init I18n with locale " + config.getLocale());
            }
            // change i18n language
            I18n.setDefaultLocale(config.getLocale());
            // reload decorators
//            decoratorProvider.reload();
        }

        // create restrict context for ui 
        JAXXInitialContext context = new JAXXInitialContext();

        // share handler
        context.add(this);

        // share config
        context.add(rootContext.getContextValue(DemoConfig.class));

        // share a unique DecoratorProvider
//        context.add(decoratorProvider);

        // share a unique DecoratorProviderListCellRenderer
//        context.add(new DecoratorProviderListCellRenderer(decoratorProvider));

        // instanciate ui
        DemoUI ui = new DemoUI(context);

        // keep it in root context
        MAIN_UI_ENTRY_DEF.setContextValue(rootContext, ui);

        // synch to error dialog
        ErrorDialogUI.init(ui);

        // set fullscreen propery on main ui
        ui.getGraphicsConfiguration().getDevice().setFullScreenWindow(config.isFullScreen() ? ui : null);

        return ui;
    }

    public void initUI(final DemoUI ui) {
//
//        // Creation of selection listener to open ui when tree selection change
//        TreeSelectionListener listener = new TreeSelectionListener() {
//            @Override
//            public void valueChanged(TreeSelectionEvent event) {
//                TreePath path = event.getPath();
//                DemoNode node = (DemoNode) path.getLastPathComponent();
//
//                if (log.isDebugEnabled()) {
//                    log.debug("Select node " + node);
//                }
//
//                if (node == null || node.isStringNode()) {
//
//                    // noeud de présentation, rien a faire
//                    return;
//                }
//                showUI(ui, node.getInternalClass());
//            }
//        };
//
//        JTree tree = ui.getNavigation();
//
//        ui.getTreeHelper().setUI(tree, true, listener);
//
//        // auto-expand node when selected
//        SwingUtil.addExpandOnClickListener(tree);

    }

//    protected void showUI(DemoUI ui, Class<?> type) {
//
//        JPanel content = ui.getContent();
//
//        String constraints = type.getName();
//
//        log.info("Show for " + constraints);
//
//        // Verify if instance is existing
//        DemoTab demoContent = getContentIfExist(ui, constraints);
//
//        if (demoContent == null) {
//
//            log.info("Will instanciate a new " + constraints);
//            try {
//                // Get constructor
//                Constructor<?> constructor =
//                        type.getConstructor(JAXXContext.class);
//
//                JAXXInitialContext tx =
//                        new JAXXInitialContext().add(ui.getDelegateContext());
//
//                DemoPanel panel = (DemoPanel) constructor.newInstance(tx);
//
//                log.info("Demo panel to use : " + panel);
//
//                demoContent = new DemoTab(tx.add("content", panel));
//
//            } catch (Exception eee) {
//                log.error(eee, eee);
//                ErrorDialogUI.showError(eee);
//            }
//
//            // Add to content panel
//            content.add(demoContent, constraints);
//        }
//
//        // show ui
//        ui.getContentLayout().show(content, constraints);
//    }

// Get content if exist in content, else return null

//    protected <E extends Component> E getContentIfExist(DemoUI ui, String constraints) {
//        if (log.isDebugEnabled()) {
//            log.debug("Get content if exist " + constraints);
//        }
//        if (!ui.getContentLayout().contains(constraints)) {
//            return null;
//        }
//        return (E) ui.getContentLayout().getComponent(ui.getContent(), constraints);
//    }

    public void displayUI(final DemoUI ui) {

        // show ui after all (in another invocation, tu avoid layout adjustement
        // to be seen).

        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {

                // show ui
                ui.setVisible(true);
            }
        });
    }

    /**
     * Permet de recharger l'ui principale et de changer de le mode d'affichage.
     *
     * @param rootContext le contexte applicatif
     * @param config      la configuration a utiliser
     */
    public void reloadUI(DefaultApplicationContext rootContext,
                         DemoConfig config) {

        // scan main ui
        DemoUI ui = getUI(rootContext);

        if (ui != null) {

            ui.getConfig().removeJaxxPropertyChangeListener();


            ErrorDialogUI.init(null);

            ui.dispose();

            ui.setVisible(false);

            MAIN_UI_ENTRY_DEF.removeContextValue(rootContext);
        }

        ui = initUI(rootContext, config);

        displayUI(ui);
    }

    /**
     * Méthode pour changer de mode d'affichage.
     * <p/>
     * Si <code>fullscreen</code> est à <code>true</code> alors on passe en
     * mode console (c'est à dire en mode plein écran exclusif), sinon on
     * passe en mode fenetré normal.
     *
     * @param context    l'ui principale de l'application
     * @param fullscreen le nouvel état requis.
     */
    public void changeScreen(JAXXContext context, boolean fullscreen) {

        DemoUI ui = getUI(context);

        // sauvegarde de l'état dans la configuration
        DemoConfig config = ui.getConfig();
        config.setFullscreen(fullscreen);

        // rechargement de l'ui
        reloadUI(RunDemo.get(), config);
    }

    public void changeLanguage(JAXXContext context, Locale newLocale) {

        DemoUI ui = getUI(context);

        DemoConfig config = ui.getConfig();

        // sauvegarde de la nouvelle locale
        config.setLocale(newLocale);

        // rechargement de l'ui
        reloadUI(RunDemo.get(), config);
    }

    /**
     * Ferme l'application.
     *
     * @param context l'ui principale de l'application
     */
    public void close(JAXXContext context) {
        log.info("JAXX Demo quitting...");
        try {

            DemoUI ui = getUI(context);
            ui.dispose();
        } finally {
            System.exit(0);
        }
    }

    final Runnable reloadUICallback = new Runnable() {

        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info("will reload ui");
            }
            DefaultApplicationContext context = RunDemo.get();
            DemoUI ui = getUI(context);
            DemoConfig config = ui.getConfig();
            reloadUI(context, config);
        }
    };

    final Runnable reloadApplicationCallback = new Runnable() {

        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info("will reload appplication");
            }
            close(RunDemo.get());
        }
    };

    public void showConfig(JAXXContext context) {
        DemoUI ui = getUI(context);
        DemoConfig config = ui.getConfig();

        ConfigUIHelper helper = new ConfigUIHelper(config);

        helper.registerCallBack("ui",
                                n_("demo.action.reload.ui"),
                                SwingUtil.createActionIcon("reload-ui"),
                                reloadUICallback);

        helper.registerCallBack("application",
                                n_("demo.action.reload.application"),
                                SwingUtil.createActionIcon("reload-application"),
                                reloadApplicationCallback);

        // categorie repertoires

        helper.addCategory(n_("jaxxdemo.config.category.directories"),
                           n_("jaxxdemo.config.category.directories.description"));

        helper.addOption(DemoConfig.Option.CONFIG_FILE);

        // others
        helper.addCategory(n_("jaxxdemo.config.category.other"),
                           n_("jaxxdemo.config.category.other.description"));

        helper.addOption(DemoConfig.Option.FULL_SCREEN);
        helper.setOptionPropertyName(DemoConfig.PROPERTY_FULLSCREEN);
        helper.setOptionCallBack("ui");

        helper.addOption(DemoConfig.Option.FONT_SIZE);
        helper.setOptionPropertyName(DemoConfig.PROPERTY_FONT_SIZE);
        helper.setOptionCallBack("application");

        helper.addOption(DemoConfig.Option.LOCALE);
        helper.setOptionPropertyName(DemoConfig.PROPERTY_LOCALE);
        helper.setOptionCallBack("ui");

        helper.buildUI(context, "jaxxdemo.config.category.other");

        helper.displayUI(ui, false);
    }

    public void showHelp(JAXXContext context, String helpId) {
        log.info(context + " :: " + helpId);
//        DemoUI mainUI = getUI(context);
//        ObserveHelpBroker helpBroker = context.getContextValue(ObserveHelpBroker.class);
//
//        if (helpId == null) {
//            helpId = helpBroker.getDefaultID();
//        }
//        log.debug("show help " + helpId);
//        mainUI.getHelp().setCurrentID(helpId);
    }

    public void gotoSite(JAXXContext context) {

        DemoUI ui = getUI(context);
        DemoConfig config = ui.getConfig();

        URL siteURL = config.getOptionAsURL("application.site.url");

        log.info(_("jaxxdemo.message.goto.site", siteURL));

        if (log.isDebugEnabled()) {
            log.debug("goto " + siteURL);
        }
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            } catch (Exception ex) {
                log.error(ex.getMessage(), ex);
                ErrorDialogUI.showError(ex);
            }
        }
    }

    public void showAbout(DemoUI ui) {

        DemoConfig config = ui.getConfig();

        String iconPath = config.getOption("application.icon.path");
        String licensePath = config.getOption("application.license.path");
        String thirdPartyPath = config.getOption("application.third-party.path");

        AboutPanel about = new AboutPanel();
        about.setTitle(_("jaxxdemo.title.about"));
        about.setAboutText(_("jaxxdemo.about.message"));
        about.setBottomText(ui.getConfig().getCopyrightText());
        about.setIconPath(iconPath);
        about.setLicenseFile(licensePath);
        about.setThirdpartyFile(thirdPartyPath);
        about.buildTopPanel();
        about.init();
        about.showInDialog(ui, true);
    }

    DemoUI getUI(JAXXContext context) {
        if (context instanceof DemoUI) {
            return (DemoUI) context;
        }
        DemoUI ui = MAIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }
}
