package org.nuiton.jaxx.swing.extra;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/**
 * Created on 4/5/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.0
 */
public class Swings {

    /** Logger. */
    private static final Log log = LogFactory.getLog(Swings.class);

    /**
     * recherche les composants portant le meme nom que les champs de la classe
     * clazz. Cette methode est statique pour pouvoir eventuellement l'utiliser
     * dans un autre context (je pense par exemple a la generation jaxx).
     * <p/>
     * <p/>
     * Si la recherche echoue pour quelque raison que se soit, aucune exception
     * n'est leve, et la map retournee est tout simplement vide ou incomplete
     *
     * @param clazz     la classe ou recherche les champs
     * @param container le container ou rechercher les composants d'edition
     * @return le dictionnaire des composants recherches.
     */
    public static Map<String, JComponent> lookingForEditor(
            Class<?> clazz,
            Container container) {
        Map<String, JComponent> result = new HashMap<String, JComponent>();
        try {
            // looking for all component with name set
            Map<String, JComponent> allNamedComponent =
                    new HashMap<String, JComponent>();
            List<Container> todo = new LinkedList<Container>();
            todo.add(container);
            while (todo.size() > 0) {
                for (ListIterator<Container> i = todo.listIterator();
                     i.hasNext(); ) {
                    Container parent = i.next();
                    i.remove();
                    for (Component c : parent.getComponents()) {
                        if (c instanceof Container) {
                            i.add((Container) c);
                            String name = c.getName();
                            if (c instanceof JComponent &&
                                name != null && !"".equals(name)) {
                                allNamedComponent.put(name, (JComponent) c);
                            }
                        }
                    }
                }
            }

            // looking for all properties on class
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] props = info.getPropertyDescriptors();

            // find if one properties have same name that component
            for (PropertyDescriptor prop : props) {
                String name = prop.getName();
                if (allNamedComponent.containsKey(name)) {
                    result.put(name, allNamedComponent.get(name));
                }
            }

        } catch (IntrospectionException eee) {
            log.warn("Can't introspect bean", eee);
        }

        if (log.isDebugEnabled()) {
            log.debug("Result: " + result);
        }

        return result;
    }

    /**
     * Gets the higest visible component in a ancestor hierarchy at
     * specific x,y coordinates
     *
     * @param parent
     * @param x
     * @param y
     * @return the deppest component
     */
    public static Component getDeepestObjectAt(Component parent, int x, int y) {

        if (parent instanceof Container) {
            Container cont = (Container) parent;
            // use a copy of 1.3 Container.findComponentAt
            Component child = findComponentAt(cont,
                                              cont.getWidth(),
                                              cont.getHeight(), x, y);
            if (child != null && child != cont) {
                //log.info("child find : " + child.getName());
                if (child instanceof JRootPane) {
                    JLayeredPane lp = ((JRootPane) child).getLayeredPane();
                    Rectangle b = lp.getBounds();
                    child = getDeepestObjectAt(lp, x - b.x, y - b.y);
                }
                if (child != null) {
                    return child;
                }
            }
        }
        // if the parent is not a Container then it might be a MenuItem.
        // But even if it isn't a MenuItem just return the parent because
        // that's a close as we can come.
        return parent;
    }

    public static Component findComponentAt(Container cont,
                                            int width,
                                            int height,
                                            int x,
                                            int y) {
        //log.info("container : " + cont.getName());
        synchronized (cont.getTreeLock()) {

            if (!(x >= 0 && x < width && y >= 0 && y < height &&
                  cont.isVisible() && cont.isEnabled())) {
                return null;
            }

            Component[] component = cont.getComponents();
            int ncomponents = cont.getComponentCount();

            // Two passes: see comment in sun.awt.SunGraphicsCallback
            for (int i = 0; i < ncomponents; i++) {
                Component comp = component[i];
                Rectangle rect;

                if (comp != null && !comp.isLightweight()) {
                    rect = comp.getBounds();
                    if (comp instanceof JLayer<?>) {
                        JLayer<?> layer = (JLayer<?>) comp;
                        comp = layer.getView();
                    }
                    if (comp instanceof Container) {
                        comp = findComponentAt(
                                (Container) comp,
                                rect.width,
                                rect.height,
                                x - rect.x,
                                y - rect.y
                        );
                    } else {
                        comp = comp.getComponentAt(x - rect.x, y - rect.y);
                    }
                    if (comp != null && comp.isVisible() && comp.isEnabled()) {
                        return comp;
                    }
                }
            }

            for (int i = 0; i < ncomponents; i++) {
                Component comp = component[i];
                Rectangle rect;

                if (comp != null && comp.isLightweight()) {
                    rect = comp.getBounds();
                    if (comp instanceof JLayer<?>) {
                        JLayer<?> layer = (JLayer<?>) comp;
                        comp = layer.getView();
                    }
                    if (comp instanceof Container) {
                        comp = findComponentAt(
                                (Container) comp,
                                rect.width,
                                rect.height,
                                x - rect.x,
                                y - rect.y
                        );
                    } else {
                        comp = comp.getComponentAt(x - rect.x, y - rect.y);
                    }
                    if (comp != null && comp.isVisible() && comp.isEnabled()) {
                        return comp;
                    }
                }
            }
            return cont;
        }
    }

    /**
     * Centrer un component graphique au center d'un autre component.
     * <p/>
     * <b>Note:</b> si le parent est null, alors on ne fait rien.
     *
     * @param parent    le component parent
     * @param component le component à centrer
     */
    public static void center(Component parent, Component component) {
        if (parent != null) {

            Rectangle r = parent.getBounds();
            int x = r.x + (r.width - component.getSize().width) / 2;
            int y = r.y + (r.height - component.getSize().height) / 2;
            component.setLocation(x, y);

        }
    }

    public static Dimension newMinDimension() {
        return new Dimension(0, 0);
    }

    public static Dimension newMaxXDimension() {
        return new Dimension(Short.MAX_VALUE, 0);
    }

    public static Dimension newMaxYDimension() {
        return new Dimension(0, Short.MAX_VALUE);
    }

    public static Dimension newMaxXYDimension() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

}
