/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.runtime;

/** The <code>JAXXObject</code> interface is implemented by all classes produced by the JAXX compiler. */
public interface JAXXObject extends JAXXContext {
    /**
     * Retrieves an object defined in an XML tag by its ID.
     *
     * @param id the id of the component to retrieve
     * @return the object
     */
    public Object getObjectById(String id);

    /**
     * Pretrieves the dictonary of knwon objects indexed by their ids.
     *
     * @return the dictonary of objects.
     */
    public java.util.Map<String, Object> get$objectMap();

    public void applyDataBinding(String id);


    public void removeDataBinding(String id);

    public jaxx.runtime.JAXXContext getDelegateContext();

    /**
     * Processes a data binding by name.  Data binding names are comprised of an object ID and a property name:
     * for example, the data binding in the tag <code>&lt;JLabel id='label' text='{foo.getText()}'/&gt;</code> is
     * named <code>"label.text"</code>.  Processing a data binding causes it to reevaluate its expression, in this
     * case <code>foo.getText()</code>.
     *
     * @param dest the name of the data binding to run
     */
    public void processDataBinding(String dest);


    /**
     * All <code>JAXXObject</code> implements are capable of broadcasting <code>PropertyChangeEvent</code>, and
     * furthermore (for technical reasons) must allow code in outside packages, specifically the JAXX runtime,
     * to trigger these events.
     *
     * @param name     the name of the property which changed
     * @param oldValue the old value of the property
     * @param newValue the new value of the property
     */
    public void firePropertyChange(String name, Object oldValue, Object newValue);
}