/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringTokenizer;
import jaxx.runtime.JXPathDecorator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiJXPathDecorator<O>
extends JXPathDecorator<O> {
    private static final Log log = LogFactory.getLog(MultiJXPathDecorator.class);
    private static final long serialVersionUID = 1L;
    protected JXPathDecorator.Context<O>[] contexts;
    protected String separator;
    protected String separatorReplacement;

    public static <O> MultiJXPathDecorator<O> newDecorator(Class<O> internalClass, String expression, String separator) throws IllegalArgumentException, NullPointerException {
        return MultiJXPathDecorator.newDecorator(internalClass, expression, separator, separator);
    }

    public static <O> MultiJXPathDecorator<O> newDecorator(Class<O> internalClass, String expression, String separator, String separatorReplacement) throws IllegalArgumentException, NullPointerException {
        JXPathDecorator.Context<O>[] contexts = MultiJXPathDecorator.createInitialContexts(expression, separator, separatorReplacement);
        return new MultiJXPathDecorator<O>(internalClass, expression, separator, separatorReplacement, contexts);
    }

    public MultiJXPathDecorator(Class<O> internalClass, String expression, String separator, String separatorReplacement, JXPathDecorator.Context<O>[] contexts) throws IllegalArgumentException, NullPointerException {
        super(internalClass, expression, false);
        this.separator = separator;
        this.separatorReplacement = separatorReplacement;
        this.contexts = contexts;
        this.setContextIndex(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)(expression + " --> " + this.context));
        }
    }

    public void setContextIndex(int index) {
        MultiJXPathDecorator.ensureContextIndex(this, index);
        this.setContext(this.contexts[index]);
    }

    public int getNbContext() {
        return this.contexts.length;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getSeparatorReplacement() {
        return this.separatorReplacement;
    }

    @Override
    protected Comparator<O> getComparator(int pos) {
        MultiJXPathDecorator.ensureContextIndex(this, pos);
        JXPathDecorator.Context<O> context1 = this.contexts[pos];
        return context1.getComparator(0);
    }

    public static <O> JXPathDecorator.Context<O>[] createInitialContexts(String expression, String separator, String separatorReplacement) {
        int sep = expression.indexOf(separator);
        if (sep == -1) {
            JXPathDecorator.Context<O>[] result = MultiJXPathDecorator.newInstance(1);
            result[0] = MultiJXPathDecorator.createInitialContext(expression);
            return result;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(expression, separator);
        while (stk.hasMoreTokens()) {
            tokens.add(stk.nextToken());
        }
        int nbTokens = tokens.size();
        JXPathDecorator.Context<O>[] contexts = MultiJXPathDecorator.newInstance(nbTokens);
        for (int i = 0; i < nbTokens; ++i) {
            StringBuilder buffer = new StringBuilder(expression.length());
            for (int j = 0; j < nbTokens; ++j) {
                int index = (i + j) % nbTokens;
                String str = (String)tokens.get(index);
                buffer.append(separatorReplacement).append(str);
            }
            contexts[i] = MultiJXPathDecorator.createInitialContext(buffer.substring(separatorReplacement.length()));
        }
        return contexts;
    }

    protected static void ensureContextIndex(MultiJXPathDecorator<?> decorator, int pos) {
        if (pos < -1 || pos > decorator.contexts.length) {
            throw new ArrayIndexOutOfBoundsException("context index " + pos + " is out of bound, can be inside [" + 0 + "," + decorator.contexts.length + "]");
        }
    }

    protected static <O> JXPathDecorator.Context<O>[] newInstance(int size) {
        return new JXPathDecorator.Context[size];
    }
}

