/*
 * Decompiled with CFR 0.152.
 */
package colorzoo.swing.gradient;

import colorzoo.swing.ColorUtil;
import colorzoo.swing.JMultiThumbSlider;
import colorzoo.swing.gradient.GradientPicker;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.imageio.ImageIO;

public class GradientThumbRenderer
implements JMultiThumbSlider.ThumbRenderer {
    private final GradientPicker gradientPicker;
    private JMultiThumbSlider slider;
    private Image thumb_black;
    private Image thumb_gray;

    public GradientThumbRenderer(GradientPicker gradientPicker, JMultiThumbSlider jMultiThumbSlider) {
        this.gradientPicker = gradientPicker;
        this.slider = jMultiThumbSlider;
        try {
            this.thumb_black = ImageIO.read(this.getClass().getResourceAsStream("/icons/thumb_black.png"));
            this.thumb_gray = ImageIO.read(this.getClass().getResourceAsStream("/icons/thumb_gray.png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void paintThumb(Graphics2D graphics2D, JMultiThumbSlider.ThumbComp thumbComp, int n, boolean bl) {
        int n2 = thumbComp.getWidth();
        Color color = this.gradientPicker.slider.getModel().getThumbAt(n).getObject();
        color = ColorUtil.removeAlpha(color);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n2 - 1, n2 - 1);
        if (bl) {
            graphics2D.drawImage(this.thumb_black, 0, 0, null);
        } else {
            graphics2D.drawImage(this.thumb_gray, 0, 0, null);
        }
    }
}

