/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id: NumberEditorDemoModel.java 2752 2013-11-24 08:44:06Z tchemit $
 * $HeadURL: https://nuiton.org/svn/jaxx/tags/jaxx-2.8/jaxx-demo/src/main/java/jaxx/demo/component/jaxx/editor/NumberEditorDemoModel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.demo.component.jaxx.editor;

import org.jdesktop.beans.AbstractSerializableBean;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.5
 */
public class NumberEditorDemoModel extends AbstractSerializableBean {

    public static final String INTEGER_PROPERTY = "integerProperty";

    public static final String FLOAT_PROPERTY = "floatProperty";

    private static final long serialVersionUID = 1L;

    protected int integerProperty;

    protected float floatProperty;

    public float getFloatProperty() {
        return floatProperty;
    }

    public int getIntegerProperty() {
        return integerProperty;
    }

    public void setFloatProperty(float floatProperty) {
        float old = this.floatProperty;
        this.floatProperty = floatProperty;
        firePropertyChange(FLOAT_PROPERTY, old, floatProperty);
    }

    public void setIntegerProperty(int integerProperty) {
        int old = this.integerProperty;
        this.integerProperty = integerProperty;
        firePropertyChange(INTEGER_PROPERTY, old, integerProperty);
    }
}
