package jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class BeanFilterableComboBoxDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMBO_BOX_FILTERABLE = "comboBox.filterable";
    public static final String BINDING_COMBO_BOX_INVALID_COMBO_EDITOR_TEXT_COLOR = "comboBox.invalidComboEditorTextColor";
    public static final String BINDING_COMBO_BOX_SHOW_DECORATOR = "comboBox.showDecorator";
    public static final String BINDING_COMBO_BOX_SHOW_RESET = "comboBox.showReset";
    public static final String BINDING_SELECTED_RESULT_TEXT = "selectedResult.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28bRRR+MXV+OGmTNrQqamhNyMGRYN0iIVCDaLHTiEQureIcKnyA8e4knrLeWWbf1husIv4E/gS4c0Hixglx4MyBC+JfQIgDV8Sb8XrttdfNiuSwsd689+33vn3vm+/+hGKg4LWnLIosFXooutw6+ODJk0ftp9zGXR7YSvgoFQz+5gpQaMGyk8QDhNdbDV1ejcurddn1pce9seqdBpQCPHV50OEcEV5NV9hBUG0mxzuRH6ohakIqC/Wbv/8qfO189W0BIPKJXYlaKZ9VNerkQgMKwkG4Qm96xqou806IhhLeCfG9qGN1lwXBR6zLP4cvYaEB8z5TBIawmb9lg2HqIx9heWuXd+Vj5nH3NsJdQ9ahiGUPISwT444gEKvGmbcnXOSKtQlKdtuyJiMN4fsGdB5hYetIHxLc9VTvQY86scyZzlxKCq7Y0jsWJ6FiKKRnuFBQ9xvFRQcmqNNXkqq144RHLUSUHsLVVE29w+3PiJ3OX03KVoOO7B3ygOOgSodfTqes65RdbksiJNXMtC1bulKJL/i+94y5wjFqPDA6HfFoNvyiHcuG8HaGQLHSbVJ6htxpHZYVD0IXE4Uup48vBdylzeHOoUmbFLbB2oOymz4N640UH1oDa7QGozmda0FRhRSmL9ya3pxDOhrszPWJndGA5vTfa+u//fjHD3vDRVmhd1/NTB3bcxpgX0mfKxT61auDLQlRuNWHzN9pwdKgVWMCGxnEmvExkaP3Xdblli63PmRBhyCKC7//9PO1T399CQp7UHIlc/aYzt+HJeyQyh3pOpF/775htNJbpOea5oYw35bKIWJw0Pd4r3wk0OVOzcQqn1Q2NROzVPqjjsbWzEFbRvG+je3A5vb284gE3MgQMOmivfTLP+vN7+8PRZyjpl6ZmT4SsvgxzAvPFR43fhNbSaa/LPsBDx05sowsE4HMDfZjQ6iY5xtTqhVoEYajiXABVcj1P1ocBCuPYKNwFOpX3DYS6F9vQYY7nIfPm3n4JL6SRWfSdc7D5k5eNomFZTHKMrnzsKrlG/IXOWYWzVwmexbvIsINkVlf1+gIj/p5XmOJoBl3X9ku3ysbA2E9tAyKdfhgt3y37IWu+xzhYkpeuqD7GXqnAKmoNJIN4VZ/coSn0sWdd73Hih8LukrWEv1J8S4lI/nhcOgQbvYnJjANliV9ck+dJe+4Adb/twEOrrGB802TGb/lcvCJh/Kdfod5jsuVdcKxmboIK8Puxo/2kXcrMxhMXKR5RHHZqSSx4dJ7DkNWbgvPoUv3/Sn0Of0snYmow+byP81GWMvBaVF/gaNTn78AZ+PcTG4Rwn9sMWuoywsAAA==";
    private static final Log log = LogFactory.getLog(BeanFilterableComboBoxDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox colorizeInvalidComboEditorTextButton;
    protected BeanFilterableComboBox<People> comboBox;
    protected JPanel configurationPanel;
    protected JCheckBox filterableButton;
    protected final BeanFilterableComboBoxDemoHandler handler = new BeanFilterableComboBoxDemoHandler();
    protected JPanel resultPanel;
    protected JLabel selectedResult;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanFilterableComboBoxDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanFilterableComboBoxDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BeanFilterableComboBoxDemo() {
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getColorizeInvalidComboEditorTextButton() {
        return colorizeInvalidComboEditorTextButton;
    }

    public BeanFilterableComboBox<People> getComboBox() {
        return comboBox;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public BeanFilterableComboBoxDemoHandler getHandler() {
        return handler;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JLabel getSelectedResult() {
        return selectedResult;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(filterableButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(colorizeInvalidComboEditorTextButton);
    }

    protected void addChildrenToResultPanel() {
        if (!allComponentsCreated) {
            return;
        }
        resultPanel.add(selectedResult, BorderLayout.CENTER);
    }

    protected void createColorizeInvalidComboEditorTextButton() {
        $objectMap.put("colorizeInvalidComboEditorTextButton", colorizeInvalidComboEditorTextButton = new JCheckBox());
        
        colorizeInvalidComboEditorTextButton.setName("colorizeInvalidComboEditorTextButton");
        colorizeInvalidComboEditorTextButton.setText(_("jaxxdemo.beanfilterablecomboboxdemo.colorizeInvalidComboEditorText"));
        colorizeInvalidComboEditorTextButton.setSelected(true);
    }

    protected void createComboBox() {
        $objectMap.put("comboBox", comboBox = new BeanFilterableComboBox<People>());
        
        comboBox.setName("comboBox");
        comboBox.setI18nPrefix("jaxxdemo.common.");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
        filterableButton.setText(_("jaxxdemo.beanfilterablecomboboxdemo.filterable"));
        filterableButton.setSelected(true);
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new BorderLayout());
    }

    protected void createSelectedResult() {
        $objectMap.put("selectedResult", selectedResult = new JLabel());
        
        selectedResult.setName("selectedResult");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
        showDecoratorButton.setText(_("jaxxdemo.beanfilterablecomboboxdemo.showDecorator"));
        showDecoratorButton.setSelected(true);
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setText(_("jaxxdemo.beanfilterablecomboboxdemo.showReset"));
        showResetButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(comboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfigurationPanel();
        addChildrenToResultPanel();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        comboBox.setBeanType(People.class);
        configurationPanel.setBorder(new TitledBorder(_("jaxxdemo.beanfilterablecomboboxdemo.configuration")));
        resultPanel.setBorder(new TitledBorder(_("jaxxdemo.beanfilterablecomboboxdemo.result")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createShowResetButton();
        createShowDecoratorButton();
        createColorizeInvalidComboEditorTextButton();
        createComboBox();
        createResultPanel();
        createSelectedResult();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_INVALID_COMBO_EDITOR_TEXT_COLOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (colorizeInvalidComboEditorTextButton != null) {
                    $bindingSources.put("colorizeInvalidComboEditorTextButton.getModel()", colorizeInvalidComboEditorTextButton.getModel());
                    colorizeInvalidComboEditorTextButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    colorizeInvalidComboEditorTextButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_INVALID_COMBO_EDITOR_TEXT_COLOR));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (colorizeInvalidComboEditorTextButton != null) {
                    comboBox.setInvalidComboEditorTextColor(colorizeInvalidComboEditorTextButton.isSelected() ? java.awt.Color.RED : null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (colorizeInvalidComboEditorTextButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("colorizeInvalidComboEditorTextButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    colorizeInvalidComboEditorTextButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_INVALID_COMBO_EDITOR_TEXT_COLOR));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_SHOW_DECORATOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (showDecoratorButton != null) {
                    $bindingSources.put("showDecoratorButton.getModel()", showDecoratorButton.getModel());
                    showDecoratorButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    showDecoratorButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_DECORATOR));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showDecoratorButton != null) {
                    comboBox.setShowDecorator(showDecoratorButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showDecoratorButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showDecoratorButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    showDecoratorButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_DECORATOR));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_FILTERABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (filterableButton != null) {
                    $bindingSources.put("filterableButton.getModel()", filterableButton.getModel());
                    filterableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    filterableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_FILTERABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (filterableButton != null) {
                    comboBox.setFilterable(filterableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (filterableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("filterableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    filterableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_FILTERABLE));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    comboBox.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_RESET));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_RESULT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (comboBox != null) {
                    comboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (comboBox != null) {
                    selectedResult.setText(_(handler.getSelectedResult(comboBox.getSelectedItem())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (comboBox != null) {
                    comboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
    }

}