/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id: TimeEditorDemoModel.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.7/jaxx-demo/src/main/java/jaxx/demo/component/jaxx/editor/TimeEditorDemoModel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.jaxx.editor;

import jaxx.runtime.swing.editor.TimeEditor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;

/**
 * Model of a bean using the {@link TimeEditor}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.2
 */
public class TimeEditorDemoModel {

    public static final String TIME_PROPERTY = "time";

    protected final PropertyChangeSupport p;

    protected Date time;

    public TimeEditorDemoModel() {
        p = new PropertyChangeSupport(this);
    }

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        Date old = this.time;
        this.time = time;
        p.firePropertyChange(TIME_PROPERTY, old, time);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName,
                                          PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName,
                                             PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

}
