package jaxx.demo.feature.validation.list;
/*
 * #%L
 * JAXX :: Demo
 * $Id: PeopleTableModel.java 2455 2012-07-30 18:47:43Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.30/jaxx-demo/src/main/java/jaxx/demo/feature/validation/list/PeopleTableModel.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import jaxx.demo.entities.Identity;
import jaxx.demo.entities.People;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.tuple.Pair;

import javax.swing.table.AbstractTableModel;
import java.util.Arrays;
import java.util.List;

/**
 * Table model of {@link Identity}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5.3
 */
public class PeopleTableModel extends AbstractTableModel {

    private static final long serialVersionUID = 1L;

    public static final List<String> columnNames =
            Arrays.asList(People.PROPERTY_ID,
                          People.PROPERTY_FIRST_NAME,
                          People.PROPERTY_LAST_NAME,
                          People.PROPERTY_AGE);

    public static final Class<?>[] columnClasses =
            {String.class, String.class, Integer.class};

    private final List<People> data = Lists.newArrayList();

    @Override
    public int getRowCount() {
        return data.size();
    }

    @Override
    public String getColumnName(int column) {
        SwingUtil.ensureColumnIndex(this, column);
        return columnNames.get(column);
    }

    @Override
    public int getColumnCount() {
        return columnNames.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {

        SwingUtil.ensureColumnIndex(this, columnIndex);
        SwingUtil.ensureRowIndex(this, rowIndex);

        People row = data.get(rowIndex);
        if (columnIndex == 0) {
            return row.getId();
        }
        if (columnIndex == 1) {
            return row.getFirstName();
        }
        if (columnIndex == 2) {
            return row.getLastName();
        }
        if (columnIndex == 3) {
            return row.getAge();
        }

        // should never come here
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SwingUtil.ensureColumnIndex(this, columnIndex);
        SwingUtil.ensureRowIndex(this, rowIndex);

        People row = data.get(rowIndex);

        if (columnIndex == 0) {
            row.setId(String.valueOf(aValue));
        } else if (columnIndex == 1) {
            row.setFirstName(String.valueOf(aValue));
        } else if (columnIndex == 2) {
            row.setLastName(String.valueOf(aValue));
        } else if (columnIndex == 3) {
            row.setAge(Integer.valueOf(aValue.toString()));
        }
    }


    public int getBeanIndex(People bean) {
        int row = data.indexOf(bean);
        return row;
    }

    public People getBean(int row) {
        SwingUtil.ensureRowIndex(this, row);
        People bean = data.get(row);
        return bean;
    }

    public Pair<Integer, Integer> getCell(People bean, String fieldName) {

        int row = getBeanIndex(bean);
        int col = columnNames.indexOf(fieldName);

        Pair<Integer, Integer> cell = Pair.of(row, col);
        return cell;
    }

    public void removeBean(int selectedRow) {
        SwingUtil.ensureRowIndex(this, selectedRow);
        data.remove(selectedRow);
        fireTableRowsDeleted(selectedRow, selectedRow);
    }

    public void addBean(People bean) {
        data.add(bean);
        int newrowIndex = data.size() - 1;
        fireTableRowsInserted(newrowIndex, newrowIndex);
    }
}
