/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id: AbstractDemoBean.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.15/jaxx-demo/src/main/java/jaxx/demo/entities/AbstractDemoBean.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.entities;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

import static org.nuiton.i18n.I18n.n_;

/**
 * Abstract demo bean.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.2
 */
public abstract class AbstractDemoBean implements Serializable {

    static {
        n_("jaxxdemo.common.id");
        n_("jaxxdemo.common.image");
    }

    public static final String PROPERTY_ID = "id";

    public static final String PROPERTY_IMAGE = "image";

    private static final long serialVersionUID = 1L;

    protected String id;

    protected String image;

    protected final PropertyChangeSupport p;

    public AbstractDemoBean() {
        p = new PropertyChangeSupport(this);
    }

    protected AbstractDemoBean(String id, String image) {
        this();
        this.id = id;
        this.image = image;
    }

    public String getId() {
        return id;
    }

    public String getImage() {
        return image;
    }

    public void setId(String id) {
        String old = this.id;
        this.id = id;
        firePropertyChange(PROPERTY_ID, old, id);
    }


    public void setImage(String image) {
        Object oldValue = this.image;
        this.image = image;
        firePropertyChange(PROPERTY_IMAGE, oldValue, image);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        p.firePropertyChange(propertyName, oldValue, newValue);
    }
}
