package jaxx.demo.component.jaxx;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.StatusMessagePanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class StatusMessagePanelDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdG9uJ7QQSW0RBGMkkDuUd1I5CIJEFlgMINxFuWPtW9kXnu2V3jlwaxE/gJ0BPg0RHhSioKWgQfwEhClrE7J4/YnwocbFnzbx5+2bm7dsfkFUSrh+xKLJk6KM75FbzzuHhw+4R7+E+Vz3pCgwkxL9UGtIdKDqTuELY7LR0uT0qt/eCoQh87p+qrregoPDE42rAOSJcm63oKWW3J+l6JEI5Zp2ISmJ9/etn+pXz8k0aIBKkTrdSPatq2kmmBWnXQSjRTc+Z7TG/TzKk6/dJ77KO7XlMqQdsyJ/BC1hoQU4wSWQIG+dv2XCY+kggFGv7fBg8Yj73biLYRqxDEas3prBMrI0MQ3XAlWJ9buC6TgjDlENYrDXHJCWtNLLUMQm34qgG5SfYfK15N0QMfAKXZ8BxWMOW5tG3dGB1NpmiFrZmJhwzzcsdSZBwdQZOq7amq57uItWBrAwpjLDemXfHY0rFvlj/xxea0GT/rJW/fvj+vjE2Q4buvpwIPeVlWpKQgeASXX31pdgJIbqefcBEvQN5xT16CMbolQRh7VGaxNF9q7rc0uXWPaYGRJFd+Pbx09rTLxcg3YCCFzCnwTT+PuRxIGkKgedE4vauUbR0vEjnitaGkPPYSUCLgIvbDkNW7bq+Q6PeiWgIlYQhTJR0859/l9vvdseDSJGwK/+FT4eRfQI51/dcn5t3MbJ84jsoCsVDJ5haO8nsKf0tiJFnK+aszneqwxv62IxC/akZyfrfDZNbPpMBIYM8okmVtmP9VYb0jLsh8p1kzpVzqbL0YSczlInhLwRZvfI9BQAA";
    private static final Log log = LogFactory.getLog(StatusMessagePanelDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected StatusMessagePanel p;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private StatusMessagePanelDemo $DemoPanel0 = this;
    private JButton $JButton0;
    private JButton $JButton1;
    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public StatusMessagePanelDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StatusMessagePanelDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public StatusMessagePanelDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public StatusMessagePanelDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StatusMessagePanelDemo() {
        $initialize();
    }

    public StatusMessagePanelDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public StatusMessagePanelDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public StatusMessagePanelDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        p.setStatus(((JButton)event.getSource()).getText() + " ? shame on you!");
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        p.setStatus(((JButton)event.getSource()).getText() + " ? shame on ...");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public StatusMessagePanel getP() {
        return p;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createP() {
        $objectMap.put("p", p = new StatusMessagePanel());
        
        p.setName("p");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($JPanel0, BorderLayout.CENTER);
        add(p, BorderLayout.SOUTH);
        // inline complete setup of $JPanel0
        $JPanel0.add($JButton0);
        $JPanel0.add($JButton1);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0,1));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("Fool me once"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("Fool me twice"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createP();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}