package jaxx.demo.feature.nav;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.DemoDataProvider;
import jaxx.demo.feature.nav.tree.NavDemoTreeHelper;
import jaxx.demo.feature.nav.treetable.NavDemoTreeTableHelper;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import static org.nuiton.i18n.I18n.t;

public class NavDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz08TQRQeqi0WFBUUwZ+oGBOjW/XgQVBRkGBTlVhi0F6c7g50cLozzsyWxYPxT/BP0LsXE2+ejAfPHrwY/wVjPHg1vtnd7nZ1kSa1h5bMe98333vz3hdef0N5JdHxNez7lvRcTZvEKl9fXr5bXyO2niPKllRoLlH46cuhXA0NOvG50uhkrWLgpQhemuVNwV3idqCnKmhA6Q1GVIMQrdGRNMJWqlSNw1O+8GSbNRaVxfryx/fcC+f5qxxCvgB1Q1DKxFaopJLtFZSjjkbDcFMLlxh2V0GGpO4q6N1lzmYZVuoObpIn6Bnqr6CCwBLINDrRfckBR4D3hUaDk3OkyRexS9h56EMg1oETa4Vg7Uliubhl3cEtkyVEgCtotMvmrgb6Ct7gHlx/NFWkWgfJ1iyWThi/mAB3OljjRclb1CESniq5D9iopkRZ5qa5jqwEPKAlIQuECQM9my3VpLT1LsXpCcduk7CE6ywmurQ5kTZ5nWwdwISyqASj2rRQo1HzSn7UgXK1HTCZxaR7k2UgqhPHhKDrB1KgJGTSxzpRVVtyxjJRScikH4pRQ1ALXcWactcUoNHe9GVwZjKPZl9zwRxOpBlH0oxBSzQ6xuWqtQZ7+FhzEbL7Vnk5zjDgyZijP5ofmPWUnGAO02UXJwF/y13hUPLBjDGLouJvQCDegoBEh1JAWG8rWe9k//pqKC89ONZorPa3I9yDUOgFY394gSEMor9GRz6/+/p2vm0Aw3D3/szUDv+CxRSSm1mk5urd4fZ7mrLSbSymajBghIH5BeZ2OENYNQqDOLgveGDLwK0FrBpAke//8v7D6KNP21BuHg0wjp15bPJvoaJuSOgCZ44vrs0Einau74DvPUabRgUWLfjQtFnciTp1HWj6VR+acDijCbGSevHjz5Hqm5l2I/pA2Pim6Ukz8g9RgbqMuiTwwsjmMr1vUCjiOTyxsyyD6zO/AyKajkvB9+WsSofBLpe4Zzdu+gK7TjjUw9OhlgmswYbrniZQuaG4GpRk/poJbhjv4oZCnUuwMxO/ks1yrAuW8QaX9ClsD2bhmt7AcpEzam/0SHygZQbQ/t+0xRXQek7Rp8Gz3cwmOtEFUb7JndAbNlHTDcmg5Fzfp4pGjtSDnj2wNuvqHvAtwLyAafTEZ47L/yjuVFcMd3tmWOqJQaN9Nmde052FR4cp2rrTp7tS9aBnBrtnhkZPDOCg8T8et7cY5O70TP+D4Qww/Abjox0MSgsAAA==";
    private static final Log log = LogFactory.getLog(NavDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel content;
    protected CardLayout2 contentLayout;
    protected DemoDataProvider dataProvider;
    protected final NavDemoHandler handler = createHandler();
    protected JTree navigationTree;
    protected JXTreeTable navigationTreeTable;
    protected JSplitPane splitPane;
    protected NavDemoTreeHelper treeHelper;
    protected NavDemoTreeTableHelper treeTableHelper;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NavDemo $DemoPanel0 = this;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JTabbedPane $JTabbedPane0;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return addDefaultSources(
                "tree/NavDemoTreeNode.java",
                "tree/NavDemoTreeHelper.java",
                "tree/NavDemoTreeCellRenderer.java",
                "tree/ActorsTreeNodeLoador.java",
                "tree/MoviesTreeNodeLoador.java",
                "treetable/NavDemoTreeTableNode.java",
                "treetable/NavDemoTreeTableHelper.java",
                "treetable/ActorsTreeTableNodeLoador.java",
                "treetable/MoviesTreeTableNodeLoador.java"
         );
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NavDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NavDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public NavDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NavDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NavDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public NavDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NavDemo() {
        $initialize();
    }

    public NavDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getContent() {
        return content;
    }

    public CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public DemoDataProvider getDataProvider() {
        return dataProvider;
    }

    public NavDemoHandler getHandler() {
        return handler;
    }

    public JTree getNavigationTree() {
        return navigationTree;
    }

    public JXTreeTable getNavigationTreeTable() {
        return navigationTreeTable;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public NavDemoTreeHelper getTreeHelper() {
        return treeHelper;
    }

    public NavDemoTreeTableHelper getTreeTableHelper() {
        return treeTableHelper;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JTabbedPane get$JTabbedPane0() {
        return $JTabbedPane0;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($JTabbedPane0, JSplitPane.LEFT);
        splitPane.add(content, JSplitPane.RIGHT);
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new CardLayout2());
    }

    protected void createDataProvider() {
        $objectMap.put("dataProvider", dataProvider = new DemoDataProvider());
    }

    protected NavDemoHandler createHandler() {
        return new NavDemoHandler();
    }

    protected void createNavigationTree() {
        $objectMap.put("navigationTree", navigationTree = new JTree());
        
        navigationTree.setName("navigationTree");
        if (navigationTree.getFont() != null) {
            navigationTree.setFont(navigationTree.getFont().deriveFont((float) 11));
        }
        navigationTree.setRootVisible(false);
        navigationTree.setShowsRootHandles(false);
    }

    protected void createNavigationTreeTable() {
        $objectMap.put("navigationTreeTable", navigationTreeTable = new JXTreeTable());
        
        navigationTreeTable.setName("navigationTreeTable");
        navigationTreeTable.setColumnControlVisible(true);
        if (navigationTreeTable.getFont() != null) {
            navigationTreeTable.setFont(navigationTreeTable.getFont().deriveFont((float) 11));
        }
        navigationTreeTable.setRootVisible(false);
        navigationTreeTable.setShowsRootHandles(false);
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setOneTouchExpandable(true);
    }

    protected void createTreeHelper() {
        $objectMap.put("treeHelper", treeHelper = new NavDemoTreeHelper(getDataProvider()));
    }

    protected void createTreeTableHelper() {
        $objectMap.put("treeTableHelper", treeTableHelper = new NavDemoTreeTableHelper(getDataProvider()));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add(splitPane, BorderLayout.CENTER);
        addChildrenToSplitPane();
        // inline complete setup of $JTabbedPane0
        $JTabbedPane0.add($JScrollPane0);
        $JTabbedPane0.add($JScrollPane1);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 0));
        $JTabbedPane0.setTitleAt(0, t("jaxxdemo.tree.tabtitle"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 1));
        $JTabbedPane0.setTitleAt(1, t("jaxxdemo.treeTable.tabtitle"));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(navigationTree);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(navigationTreeTable);
        
        // apply 10 property setters
        $JScrollPane0.setBorder(null);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        navigationTree.setModel(treeHelper.createModel());
        $JScrollPane1.setBorder(null);
        $JScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        navigationTreeTable.setTreeTableModel(treeTableHelper.createModel());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createContentLayout();
        createDataProvider();
        createTreeHelper();
        createTreeTableHelper();
        createSplitPane();
        // inline creation of $JTabbedPane0
        $objectMap.put("$JTabbedPane0", $JTabbedPane0 = new JTabbedPane());
        
        $JTabbedPane0.setName("$JTabbedPane0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNavigationTree();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createNavigationTreeTable();
        createContent();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("jaxxdemo.tree.tabtitle"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(t("jaxxdemo.treeTable.tabtitle"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
        handler.afterInit(this);
    }

}
