package jaxx.demo.feature.nav.content;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import jaxx.demo.entities.Movie;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class MovieContentUI extends AbstractContentUI<Movie> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ICON = "$JLabel0.icon";
    private static final String BINDING_$JTEXT_PANE0_TEXT = "$JTextPane0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VTU8TQRieVlooBcFWCgRMEBsTDW7lXKIgQqQpSixGYi/O7g7tkNndcXa2LByMP8GfoHcvJt48GQ+ePXgx/gVjPHg1vrP9WKpraax76Dbzvs8zz/vxtK++ooQr0MUD7Pua8GxJLaKV1vb27ukHxJC3iWsIyqUjUPOJxVG8itJm59yV6FK1rOCFFryw7ljcsYl9Al0so1FXHjHi1gmREl3oRhiuW6h0wkWfe6LN2hEVxfri+7f4c/PZyzhCPgd1w1DKwmmosJKhMopTU6IM3NTABYbtGsgQ1K6B3nF1ts6w697FFnmCnqLhMkpyLIBMosX+Sw44ArzPJcrm13RXCmzIdceWgHiwdV2ipUC0SSxH2ydYeoJoNm5oRjNF23YalHTyOQ/okhINmVhiiWZCNCRQSYnbhISZKZczKnewTSTKqcp8zT2EQrVSpR1QmakOYDxfqhjCYUyFQOF0N6gTUukTHVQ6X9olvmxhprow7YBKzUTfs6wOz3dTjuRLZawTBnyZLr7gVCXNcBj7XNfYYaG0cKHCiceqKCE8OIamVf/cwfsQam7fzG/bpwiD6M9c9tPbL2822ys3CXdPRaaecAysAhcOJ0KNRqKJ5r55krLCNubFKoyHMLBbYKf5CGGVVhjEwX3nFFxTcO0OdutAkRj+/O597vHHMyi+iUaZg81NrPK3UErWBXTBYabPb64GisYOR5RwpQ16Cmu763hGfcPn2DaxzqBfmRVqM2qTBSzBDronyQ0fmjIf0ZSOMj314Ue28nq13ZgYCJ39a3rYnMQjlGzeFrixZbRI96W5SzzTCQ0VZbGYek/y1uovBp+XoypPO4KCXbCkYCx0dkV5aUGntgnbBeUq3NWgDvVtqW/aMWg3PSYPCa3Vpcq68u9cSd0RJhEqvhzNku2DZbYOlR5DkZg1rXYLix2HUeNoQOLphtpo4//SquNiD4ZcH8JGiEmlWuUe/e+HJ7UPXbumxjkg0ZCEH7+BijqtLbN9MawOxACesahNLc+qtFoykJiNAcVkw71eY7RmW+DmHnOa62dOFP5ye8hSHL8AbO12pTMJAAA=";
    private static final Log log = LogFactory.getLog(MovieContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Movie data;
    protected JSplitPane splitPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MovieContentUI $AbstractContentUI0 = this;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JTextPane $JTextPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MovieContentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MovieContentUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MovieContentUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MovieContentUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MovieContentUI() {
        $initialize();
    }

    public MovieContentUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public MovieContentUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MovieContentUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Movie getData() {
        return data;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(Movie data) {
        Movie oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JTextPane get$JTextPane0() {
        return $JTextPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($JScrollPane0, JSplitPane.LEFT);
        splitPane.add($JScrollPane1, JSplitPane.RIGHT);
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.5);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $AbstractContentUI0
        add(splitPane, BorderLayout.CENTER);
        addChildrenToSplitPane();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JTextPane0);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add($JLabel0);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        $JScrollPane0.setBorder(null);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        $JTextPane0.setBorder(new TitledBorder(t("jaxxdemo.navigation.movie.title")));
        $JScrollPane1.setBorder(new TitledBorder("Picture"));
        $JScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        $JScrollPane1.setMinimumSize(SwingUtil.newMinDimension());
        $JScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$AbstractContentUI0", $AbstractContentUI0);
        createData();
        createSplitPane();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JTextPane0
        $objectMap.put("$JTextPane0", $JTextPane0 = new JTextPane());
        
        $JTextPane0.setName("$JTextPane0");
        $JTextPane0.setEditable(false);
        if ($JTextPane0.getFont() != null) {
            $JTextPane0.setFont($JTextPane0.getFont().deriveFont((float) 11));
        }
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setHorizontalAlignment(0);
        // inline creation of $AbstractContentUI0
        setName("$AbstractContentUI0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTEXT_PANE0_TEXT, true ,"data") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText($JTextPane0, getHandler().getContent(getData()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ICON, true ,"data") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setIcon(getHandler().getImage(getData()));
            }
        });
    }

}
