package jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.HidorButton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class HidorButtonDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2TO28TQRDH1yZ24iTOyyQECMiAJR7FmSAalCjkJctEDiCCUIQb1r6VfdH6dtldJxcKxEfgI0BPg0RHhSioKWgQXwEhClrE7Prsc8JxsWJcnO92Zn7zn9mZN99RQgp0YQd7niWarnIaxNpY2d6+V9khVbVOZFU4XDGBWr9YHMXLaMTunEuFLpVLOjzvh+fXWIMzl7hd0QslNCzVPiWyTohS6NzBiKqU+a2OecHjTdGmdkSFUV/9/BF/ab94HUfI46BuEErJHhUVVDJQQnHHVmgKMu3iPMVuDWQIx62B3rQ+W6NYyru4QZ6i52iwhJIcC4ApdLH3kg3DxHtcoZHcOmmw+9gl9LpCV41YG06sahthyT1QYBUdm4nVplLM1RGcG0ZSoWSuuMo8CD51oFI/CkzaL9VxT+e6SBB1Piwq8NBRo0GuurbMQ4t0NzzffaOEK4Qe8jSq5vXXWIQA4zCpH9OHktzQXyd9i0BnD8iEAbGCAQluMFZGCdGEY4Vmy3/P1AMwtaZp9tA0aaCx/p7JfHn/7V2hPULjkHs61LVrA+BquWCcCOXo1OOt+Wkqh+Y3MV8oo5QkFNbHrMdciLAt3wziIN+kDrd0uFXEsg6IxODXDx9nnnw+geIFNEwZtgtY+99BKVUX0AVGbY/fXjaKRveG4DmhtUEzKd5n0Go0tmhjhbMVx7XhzpY8aMJcSBM6SiqpT78yW2+X242IgbDT/3QPmpF4jJKOSx2XmG3yFyV0e0a4JE2bBQsRtiIx/T/M/XnPmmcurNJMnQnnGXMVpivUqbkNs5hTiy0xWaxgkytNRaB0zbhiatJv10yKdA8pJnf1FVe7EmjX/PGBQzDq5CHxojgTvXBgAvb+AyepsKgRQ7l8fEq6RXnkSKdCSZ+wARVdVuZIhj62IggzPRFu9k24FUGY7Ymw1DdhLeI2eiMU+yZsRlRxBgh/AOyP2bOECAAA";
    private static final Log log = LogFactory.getLog(HidorButtonDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel hidor1;
    protected JLabel hidor2;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private HidorButtonDemo $DemoPanel0 = this;
    private HBox $HBox0;
    private HBox $HBox1;
    private HidorButton $HidorButton0;
    private HidorButton $HidorButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public HidorButtonDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HidorButtonDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HidorButtonDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public HidorButtonDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HidorButtonDemo() {
        $initialize();
    }

    public HidorButtonDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public HidorButtonDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public HidorButtonDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getHidor1() {
        return hidor1;
    }

    public JLabel getHidor2() {
        return hidor2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected HBox get$HBox1() {
        return $HBox1;
    }

    protected HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected HidorButton get$HidorButton1() {
        return $HidorButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createHidor1() {
        $objectMap.put("hidor1", hidor1 = new JLabel());
        
        hidor1.setName("hidor1");
        hidor1.setText(t("Label 1"));
    }

    protected void createHidor2() {
        $objectMap.put("hidor2", hidor2 = new JLabel());
        
        hidor2.setName("hidor2");
        hidor2.setText(t("Label 2"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($HBox0);
        add($HBox1);
        // inline complete setup of $HBox0
        $HBox0.add($HidorButton0);
        $HBox0.add(hidor1);
        // inline complete setup of $HBox1
        $HBox1.add($HidorButton1);
        $HBox1.add(hidor2);
        
        // apply 5 property setters
        $HidorButton0.setTarget(hidor1);
        $HidorButton0.setTargetVisible(true);
        $HidorButton1.setTarget(hidor2);
        $HidorButton1.setTargetVisible(false);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        $HBox0.setHorizontalAlignment(0);
        $HBox0.setVerticalAlignment(0);
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new HidorButton());
        
        $HidorButton0.setName("$HidorButton0");
        $HidorButton0.setHideText("hide label1");
        $HidorButton0.setShowText("show label1");
        createHidor1();
        // inline creation of $HBox1
        $objectMap.put("$HBox1", $HBox1 = new HBox());
        
        $HBox1.setName("$HBox1");
        $HBox1.setHorizontalAlignment(0);
        $HBox1.setVerticalAlignment(0);
        // inline creation of $HidorButton1
        $objectMap.put("$HidorButton1", $HidorButton1 = new HidorButton());
        
        $HidorButton1.setName("$HidorButton1");
        $HidorButton1.setHideText("hide label2");
        $HidorButton1.setShowText("show label2");
        createHidor2();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new GridLayout(0,1));
        
        $completeSetup();
    }

}
