package jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import jaxx.demo.DemoHelpBroker;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.css.DataBinding;
import jaxx.runtime.css.Pseudoclasses;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class JButtonDemo extends DemoPanel implements JAXXHelpUI<DemoHelpBroker> {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Uy24TMRR1pk1C+oC2UV+iSAHKDiawQ2oFfakiVXiISqhqNjgzTuLKYxvb0067QHwCnwB7NkjsWCEWrFmwQfwCQizYIq6dZ9v0ISJlNLr33HOPj++ddz9RWit0dQcnia9ibmhE/I3lra3H1R0SmDWiA0WlEQo1fykPeRU0HHbi2qDrlbItL7bKi6sikoIT3lO9UEZD2uwzohuEGIOuHK4ItC5udtILiYxVm7Ujqh/rm9+/vNfhq7ceQokEdRk4SuGsqu5JBsvIo6FBE9BpFxcZ5nWQoSivg95RG1tlWOtHOCIv0EuULaOMxArIDLp2/iM7DlefSINGjJBrJBJPMCfMoBtObQgBP2hz+HoPJPgbK7ExgluwlI4gY9BogzCor+GYmRJIH7MqfavcbyrvQjOS8IBCj0mLSVqspQjXSSkQvAc4/2xFJLcNmj5kXRNvUxaX68CHNY0kI6BOcIPyveQtyRY40cEP1TAP9h3cRqZd1qC0C8OFXT7UFUbB745C965SFZRWMYQNmqkcn56nkGrOzcyRubGELvt3Kv/t448P6+1hyULvyb7QnlmHS5RKSKIMta0vNSclNpQVH2K5UEE5TRgsiluEuT7CNltpEAf9xt112XL/AdYNoEhnv3/6PPX86wDy1tEQEzhcxxZfQjnTUOCCYGEi7y85RSN7F+A5Bv8Bg3I18P+Wpgdgk3fnrjVaKFJXIuYwGINVFpM2qIYDeE8vK4pZAh7N9fGoI7Sa+/Inv/l+qe1TCnTPngjvepXeRhnKGeXErVVrY/qu0bDUJA5FdzP67QqCbcm2Jkp25sUmC+45f8wU74gHA4qELmR9svQw69RgRoMktgw33ensm9/bDFyLRKyJ2IVrP0/fFKxBQyh6ALWYLTNa55H7SkwsNg0pYAPLWY0NuXesc8o+87K1jqe0GLdyaNDTwEKX/p9w0JDkNI6p83DQwBp2cTHEBheqlIfwHTjhkLNn8tnwximKLMM/2XBwsrIGAAA=";
    private static final Log log = LogFactory.getLog(JButtonDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton fancyButon;
    protected ImageIcon pencil;
    protected JButton simpleButon;
    protected JButtonDemo topDemoPanel = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void buttonClicked(JButton button) {
        JOptionPane.showMessageDialog(this, button.getText() + " clicked!",
        "onActionPerformed",
        JOptionPane.INFORMATION_MESSAGE);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JButtonDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JButtonDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JButtonDemo() {
        $initialize();
    }

    public JButtonDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__fancyButon(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        buttonClicked((JButton) event.getSource());
    }

    public void doActionPerformed__on__simpleButon(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        buttonClicked((JButton) event.getSource());
    }

    public void doMouseEntered__on__fancyButon(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(JButtonDemo.this, fancyButon, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap(fancyButon.getForeground()), 0);
        if (!(value instanceof DataBinding)) {
            fancyButon.setForeground((Color) value);
        }
        value = Pseudoclasses.applyProperty(JButtonDemo.this, fancyButon, "font-style", "italic", Pseudoclasses.wrap((fancyButon.getFont().getStyle() & Font.ITALIC) != 0 ? "italic" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (fancyButon.getFont() != null) {
            if (((String) value).equals("italic")) {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() | Font.ITALIC));
            } else {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() & ~Font.ITALIC));
            }
        }
        }
    }

    public void doMouseExited__on__fancyButon(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(JButtonDemo.this, fancyButon, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap(fancyButon.getForeground()), 0);
        if (!(value instanceof DataBinding)) {
            fancyButon.setForeground((Color) value);
        }
        value = Pseudoclasses.removeProperty(JButtonDemo.this, fancyButon, "font-style", "italic", Pseudoclasses.wrap((fancyButon.getFont().getStyle() & Font.ITALIC) != 0 ? "italic" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (fancyButon.getFont() != null) {
            if (((String) value).equals("italic")) {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() | Font.ITALIC));
            } else {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() & ~Font.ITALIC));
            }
        }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getFancyButon() {
        return fancyButon;
    }

    public ImageIcon getPencil() {
        return pencil;
    }

    public JButton getSimpleButon() {
        return simpleButon;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(DemoHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTopDemoPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($VBox0);
    }

    protected void createFancyButon() {
        $objectMap.put("fancyButon", fancyButon = new JButton());
        
        fancyButon.setName("fancyButon");
        fancyButon.setText(t("Fancy Button"));
        if (fancyButon.getFont() != null) {
            fancyButon.setFont(fancyButon.getFont().deriveFont((float) 18));
        }
        fancyButon.setForeground(new Color(0, 0, 255));
        if (fancyButon.getFont() != null) {
            fancyButon.setFont(new Font("Arial", fancyButon.getFont().getStyle(), fancyButon.getFont().getSize()));
        }
        fancyButon.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fancyButon"));
        fancyButon.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__fancyButon"));
        fancyButon.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__fancyButon"));
    }

    @Override
    protected void createHelpDefaultId() {
        $objectMap.put("helpDefaultId", helpDefaultId = "ui.component.swing.buttons.JButtonDemo");
    }

    protected void createPencil() {
        $objectMap.put("pencil", pencil = new ImageIcon(getClass().getResource("/jaxx/demo/images/pencil_black.gif")));
    }

    protected void createSimpleButon() {
        $objectMap.put("simpleButon", simpleButon = new JButton());
        
        simpleButon.setName("simpleButon");
        simpleButon.setText(t("Simple Button"));
        simpleButon.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleButon"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTopDemoPanel();
        // inline complete setup of $VBox0
        $VBox0.add(simpleButon);
        $VBox0.add(fancyButon);
        
        // apply 1 property setters
        fancyButon.setIcon(pencil);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("topDemoPanel", topDemoPanel);
        createPencil();
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setVerticalAlignment(0);
        createSimpleButon();
        createFancyButon();
        // inline creation of topDemoPanel
        setName("topDemoPanel");
        
        $completeSetup();
    }

}