/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.jaxx.editor;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.Arrays;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.jaxx.editor.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.I18nEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class I18nEditorDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_POPUP_BORDER = "editor.popupBorder";
    public static final String BINDING_EDITOR_SHOW_ICON = "editor.showIcon";
    public static final String BINDING_EDITOR_SHOW_POPUP_ICON = "editor.showPopupIcon";
    public static final String BINDING_EDITOR_SHOW_POPUP_TEXT = "editor.showPopupText";
    public static final String BINDING_EDITOR_SHOW_TEXT = "editor.showText";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL1_TEXT = "$JLabel1.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2VPW/TQBjHL6FJmqalbzQqtEALkZhwqACB1Kr0jYhWoVS0Q0UWzvapcXF8h32m7oL4CHwE2FmQ2JgQAzMDC+IrIMTAinjubCd146QBkyFxnpff/Z+7ex6/+Y4yjo1m97HnKbZrcaNBlI3l3d0H6j7R+BpxNNtgnNrI/6TSKF1DBb1pdzi6XKuK9HKQXl6lDUYtYh3Jnq+iAYcfmsSpE8I5Oh/N0BynvN10z3vMtUNqU1Qc9dXPH+mX+ovXaYQ8BuoGoZSZk7JalfRVUdrQORqDlZ7hsomtPZBhG9Ye6B0StlUTO84mbpCn6DnKVVGWYRtgHF3qvWTJkPke46hQWiMNuoUtYl7jSJFidbAoWojwbUQ3AKKsz9227spHkcaYBGU5ypV2sGoSQExG6nUOQL0ifSIy30zoL22Ei46Jyrwg1LeKoMFWrFOnBzvEgzonIrGrdaI9WaGeiBuOhq9r1BL/z0R9Q8K3RZnLBK9rQAdCKHxO/B9t81WxGlOUtIqgqWbsMBOLrFBbJ7ZfWzGSImwVg5h6NC3rHwRHpZh9bjukY/sYyJPSLwY+G01FSHD3ldbdb13OVA1lbBfMcMS19nZ5CC6/USaPNYoASu/v4viX99/eVcLumIC1J2JDjzQ33FpmU0Zsboilh/3WcLlhlu9jNl9DeYeYMBlk50/HCNsO3CAO1hsV6YpIV+5hpw6ITO7rh4/Fx59PoXQFDZgU6xUs4tdRntdt2AVq6h67syQVDR70w/eI0AZHocrD4+j0go45nlENS4dTWPRgE6ZjNqGpRM1/+jW+/XYp3IgUCDvbMby1GZlHKGtYpmEROSiCGRA7GArMIa5OW70e1/0p8TvCgi6+Kr/nYis18SF1Zbvc8Fzxc1PKFk+3eqb0+ydFxIRb8OuYwRzmm+pyshjPHe+B28eDVl7+V4YwL3UhFHsiVBITummYTKyhN0I3DecSaziZAPfEFEOq4k+vDvftQmIlf0HooGG2h1pyJtUwDM0umFIPmMKRl0VCVOTtmIDT/qL8L7DwtZy0wsQcYb7ehXAl8f0RhD+5iR+h8AoAAA==";
    private static final Log log = LogFactory.getLog(jaxx.demo.component.jaxx.editor.I18nEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.editor.I18nEditor editor;
    protected javax.swing.JTextField popupBorderText;
    protected javax.swing.JCheckBox showIcon;
    protected javax.swing.JCheckBox showPopupIcon;
    protected javax.swing.JCheckBox showPopupText;
    protected javax.swing.JCheckBox showText;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private I18nEditorDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected Border getPopupBorder(String text) {
        if (text==null || text.trim().isEmpty()) {
            return null;
        }
        return new TitledBorder(_(text));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public I18nEditorDemo() {
        super();
        $initialize();
    }

    public I18nEditorDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.editor.I18nEditor getEditor() {
        return editor;
    }

    public javax.swing.JTextField getPopupBorderText() {
        return popupBorderText;
    }

    public javax.swing.JCheckBox getShowIcon() {
        return showIcon;
    }

    public javax.swing.JCheckBox getShowPopupIcon() {
        return showPopupIcon;
    }

    public javax.swing.JCheckBox getShowPopupText() {
        return showPopupText;
    }

    public javax.swing.JCheckBox getShowText() {
        return showText;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createEditor() {
        $objectMap.put("editor", editor = new jaxx.runtime.swing.editor.I18nEditor());
        
        editor.setName("editor");
    }

    protected void createPopupBorderText() {
        $objectMap.put("popupBorderText", popupBorderText = new javax.swing.JTextField());
        
        popupBorderText.setName("popupBorderText");
        popupBorderText.setColumns(15);
    }

    protected void createShowIcon() {
        $objectMap.put("showIcon", showIcon = new javax.swing.JCheckBox());
        
        showIcon.setName("showIcon");
        showIcon.setSelected(true);
        showIcon.setText(_("jaxxdemo.i18neditor.showIcon"));
    }

    protected void createShowPopupIcon() {
        $objectMap.put("showPopupIcon", showPopupIcon = new javax.swing.JCheckBox());
        
        showPopupIcon.setName("showPopupIcon");
        showPopupIcon.setSelected(true);
        showPopupIcon.setText(_("jaxxdemo.i18neditor.showPopupIcon"));
    }

    protected void createShowPopupText() {
        $objectMap.put("showPopupText", showPopupText = new javax.swing.JCheckBox());
        
        showPopupText.setName("showPopupText");
        showPopupText.setSelected(true);
        showPopupText.setText(_("jaxxdemo.i18neditor.showPopupText"));
    }

    protected void createShowText() {
        $objectMap.put("showText", showText = new javax.swing.JCheckBox());
        
        showText.setName("showText");
        showText.setSelected(true);
        showText.setText(_("jaxxdemo.i18neditor.showText"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(showText);
        $JPanel0.add(showIcon);
        $JPanel0.add(showPopupText);
        $JPanel0.add(showPopupIcon);
        $JPanel0.add($JPanel1);
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel0);
        $JPanel1.add(popupBorderText);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        $JPanel0.setBorder(new TitledBorder(_("jaxxdemo.i18neditor.configuration")));
        $JLabel0.setLabelFor(popupBorderText);
        jaxx.runtime.SwingUtil.setText(popupBorderText, _("jaxxdemo.i18neditor.popup.title"));
        
        editor.setLocales(Arrays.asList(I18n.getStore().getLocales()));
        $JLabel1.setBorder(new TitledBorder(_("jaxxdemo.i18neditor.selected.locale")));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0,1));
        createShowText();
        createShowIcon();
        createShowPopupText();
        createShowPopupIcon();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("jaxxdemo.i18neditor.popupBorderText"));
        createPopupBorderText();
        createEditor();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_POPUP_BORDER, true) {
        
            @Override
            public void applyDataBinding() {
                if (popupBorderText != null) {
                    $bindingSources.put("popupBorderText.getDocument()", popupBorderText.getDocument());
                    popupBorderText.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    popupBorderText.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_POPUP_BORDER));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (popupBorderText != null) {
                    editor.setPopupBorder(getPopupBorder(popupBorderText.getText()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (popupBorderText != null) {
                    javax.swing.text.Document $target = ((javax.swing.text.Document) $bindingSources.remove("popupBorderText.getDocument()"));
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    popupBorderText.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_POPUP_BORDER));
                }
            }
        
            public void $pr$u0(javax.swing.event.DocumentEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_ICON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showIcon != null) {
                    $bindingSources.put("showIcon.getModel()", showIcon.getModel());
                    showIcon.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    showIcon.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_ICON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showIcon != null) {
                    editor.setShowIcon(showIcon.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showIcon != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("showIcon.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    showIcon.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_ICON));
                }
            }
        
            public void $pr$u1(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_POPUP_ICON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupIcon != null) {
                    $bindingSources.put("showPopupIcon.getModel()", showPopupIcon.getModel());
                    showPopupIcon.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showPopupIcon.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_ICON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupIcon != null) {
                    editor.setShowPopupIcon(showPopupIcon.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupIcon != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("showPopupIcon.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showPopupIcon.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_ICON));
                }
            }
        
            public void $pr$u2(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_POPUP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupText != null) {
                    $bindingSources.put("showPopupText.getModel()", showPopupText.getModel());
                    showPopupText.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    showPopupText.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupText != null) {
                    editor.setShowPopupText(showPopupText.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupText != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("showPopupText.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    showPopupText.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_TEXT));
                }
            }
        
            public void $pr$u3(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (showText != null) {
                    $bindingSources.put("showText.getModel()", showText.getModel());
                    showText.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    showText.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showText != null) {
                    editor.setShowText(showText.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showText != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("showText.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    showText.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_TEXT));
                }
            }
        
            public void $pr$u4(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL1_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (editor != null) {
                    editor.addPropertyChangeListener("selectedLocale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editor != null && editor.getSelectedLocale() != null) {
                    $JLabel1.setText(_(editor.getSelectedLocale().toString()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editor != null) {
                    editor.removePropertyChangeListener("selectedLocale", this);
                }
            }
        });
    }

}