package jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class BeanDoubleListDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DOUBLE_LIST_FILTERABLE = "doubleList.filterable";
    public static final String BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT = "doubleList.highlightFilterText";
    public static final String BINDING_DOUBLE_LIST_SHOW_DECORATOR = "doubleList.showDecorator";
    public static final String BINDING_DOUBLE_LIST_SHOW_RESET = "doubleList.showReset";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28TRxR+cXF+OEBSUlAiKKQBqvjAuu2pUqoCThRR5CZRnAPCl469k3joemeZedtsZFH1T+ifQO+9IHHjhDhw5sAF8S+gqodeq74Zr9exM7apEimb6M37vv3eN++9/fMD5LWCLx6xJPFUHKJoce/+3QcPtuuPeAM3uG4oEaFU0PmZyEGuBrN+FtcI12sVAy+l8NK6bEUy5OEx9FoFChqPAq6bnCPC5/2Ihtalana8lkSx6rJmolysT//+K/e7/9sfOYAkInUzVMryOFSvkjMVyAkf4QK96RdWClh4QDKUCA9I7zkTWw+Y1lusxR/DrzBVgcmIKSJDWPn4ki2HxScRwuyNDd6SOyzkwVcI31ixPkW8RpfCszHuCyLxypyFGzKuB7wiNBpoFFmySYSpG3uMDohmsa9mfUgVePbMZM5kgAsNGe6Lg1gxFDK0Giho6kxS0H0bNOlnM9T8vgiQK0NXjhFliHCxD7Pe5I2fyzIx+XMZbKkpDpoB/eKmxe/xBDt4k/BZf/KcbsrDXa758JQFk7LBG5LUSzU8raN2O9xijaYcmlbwM1MRbjnsS/2vk/8Dl5C6o+ByH4x62Ov1cK/JJmqQVzGF6ZpqJ9t+l446Db840PCG0J7+e2nh7Yv3zze7XV6gd190ph4bUuq+SMmIKxTm1XOdFo9RBKUfWbRWo1nhAU24neArDmHV9JjE0fs+NXDPwL17TDeJIj/17uWrSz+9+QRym1AIJPM3mcn/AWawqcgFGfhJdPuOVXT2cJqe80YbwmRdKp+EQbkd8sPlPYEB98s2toqrK0aJnQjjfeeaArI9HZJjDbxSLD5JyLgrDuMy9fWZ1/8sVJ/d6Zo3QcUsDU3vGZh/CJMiDETI7ZJI59+5FGYjzWNf9ubcNfngHL8oneab9lk84VYOYbpzT5z21BlUMTd/aJQQvhxlVG9mk9hQ37Klm/9K4Bjp/6cjv88C3RNSGiXEsQVcioZvi9NYdHOUsmzluPQMLqTTqCiOU5FtNZcS19471XWNlNO3PZ1yHPt1nJw8wRz3i7DaHnrtntDVtILV4hOEc3020Ae47fBlEFTo9TnCtfZg159IF19/G+4ovi8SmpHMJvoytygZaWV2mwLhanugQ/rJXNYd++aMc8xsyYAdSWKG89/5DNlyXYQ+fZi+P8E8YZ6FsYwmHJnHYzfD/EdomjYds3cU8RE8V4nnPx+r3WhWCgAA";
    private static final Log log = LogFactory.getLog(BeanDoubleListDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configurationPanel;
    protected BeanDoubleList<People> doubleList;
    protected JCheckBox filterOnNachoButton;
    protected JCheckBox filterableButton;
    protected final BeanDoubleListDemoHandler handler = createHandler();
    protected JCheckBox highlightFilterTextButton;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanDoubleListDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanDoubleListDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BeanDoubleListDemo() {
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BeanDoubleListDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanDoubleListDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public BeanDoubleList<People> getDoubleList() {
        return doubleList;
    }

    public JCheckBox getFilterOnNachoButton() {
        return filterOnNachoButton;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public BeanDoubleListDemoHandler getHandler() {
        return handler;
    }

    public JCheckBox getHighlightFilterTextButton() {
        return highlightFilterTextButton;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(filterableButton);
        configurationPanel.add(highlightFilterTextButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(filterOnNachoButton);
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDoubleList() {
        $objectMap.put("doubleList", doubleList = new BeanDoubleList<People>());
        
        doubleList.setName("doubleList");
        doubleList.setI18nPrefix("jaxxdemo.common.");
    }

    protected void createFilterOnNachoButton() {
        $objectMap.put("filterOnNachoButton", filterOnNachoButton = new JCheckBox());
        
        filterOnNachoButton.setName("filterOnNachoButton");
        filterOnNachoButton.setText(t("jaxxdemo.beandoublelistdemo.filterOnNacho"));
        filterOnNachoButton.setSelected(false);
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
        filterableButton.setText(t("jaxxdemo.beandoublelistdemo.filterable"));
        filterableButton.setSelected(true);
    }

    protected BeanDoubleListDemoHandler createHandler() {
        return new BeanDoubleListDemoHandler();
    }

    protected void createHighlightFilterTextButton() {
        $objectMap.put("highlightFilterTextButton", highlightFilterTextButton = new JCheckBox());
        
        highlightFilterTextButton.setName("highlightFilterTextButton");
        highlightFilterTextButton.setText(t("jaxxdemo.beandoublelistdemo.highlightFilterText"));
        highlightFilterTextButton.setSelected(false);
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
        showDecoratorButton.setText(t("jaxxdemo.beandoublelistdemo.showDecorator"));
        showDecoratorButton.setSelected(true);
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setText(t("jaxxdemo.beandoublelistdemo.showReset"));
        showResetButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(doubleList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToConfigurationPanel();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        doubleList.setBeanType(People.class);
        configurationPanel.setBorder(new TitledBorder(t("jaxxdemo.beandoublelistdemo.configuration")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createHighlightFilterTextButton();
        createShowResetButton();
        createShowDecoratorButton();
        createFilterOnNachoButton();
        createDoubleList();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (highlightFilterTextButton != null) {
                    $bindingSources.put("highlightFilterTextButton.getModel()", highlightFilterTextButton.getModel());
                    highlightFilterTextButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    highlightFilterTextButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (highlightFilterTextButton != null) {
                    doubleList.setHighlightFilterText(highlightFilterTextButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (highlightFilterTextButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("highlightFilterTextButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    highlightFilterTextButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_SHOW_DECORATOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (showDecoratorButton != null) {
                    $bindingSources.put("showDecoratorButton.getModel()", showDecoratorButton.getModel());
                    showDecoratorButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    showDecoratorButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_DECORATOR));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showDecoratorButton != null) {
                    doubleList.setShowDecorator(showDecoratorButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showDecoratorButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showDecoratorButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    showDecoratorButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_DECORATOR));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_FILTERABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (filterableButton != null) {
                    $bindingSources.put("filterableButton.getModel()", filterableButton.getModel());
                    filterableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    filterableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_FILTERABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (filterableButton != null) {
                    doubleList.setFilterable(filterableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (filterableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("filterableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    filterableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_FILTERABLE));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    doubleList.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_RESET));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}