package jaxx.demo.component.swing;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import jaxx.demo.DemoHelpBroker;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.css.DataBinding;
import jaxx.runtime.css.Pseudoclasses;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class JButtonDemo extends DemoPanel implements JAXXHelpUI<DemoHelpBroker> {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1UO28TQRAeO7GD84AkVl4iSCGEBsEZChBSIshLEYnMQ0SgCBdhfbexN1rfLrd7ySUIxE/gJ0BPg0RHhSioKWgQfwEhClrE7Pp1iR1isOTTaXbmm29nvu/efIeUCuDsNokiJwh9zSrUWVvY2Lhb3KauXqbKDZjUIoDqL5GEZAH6vEZcaThXyJvyXK08tyQqUvjUj1XP5qFX6T1OVZlSreHMwQpXqdx643g2kmFQR22Qaof66ueP5EvvxeskQCSRXRqvMnVcVfMm3XlIMk/DMHbaITlO/BLSCJhfQr4DJrbEiVJ3SIU+gefQk4e0JAGCaZju/MoWw9ZHUkO/FnKZVsQ94lOu4bxl62HAcesYjtpFCs7aYqi18E2ylBYgrWGgTDnWb5GQ61WkPmhYOoa5U2XeTE1L6rsMe4yYnKiGulohJbrqCj+WOPNwUUSXNYwdGF013xyZvEwjvU+xiuQU2QlfQzYOXqNsEocb+b1bxHf3bLqJjNlTDSkbxoWdPtAVpeA0pdDcVaIAqSDEsIbxQqt67uNRVTfjh3RjAO3p79Hsl/ff3q3UxdKLvUfapsa0jkuUgZA00My0PlVVSqgZz90mcrYAGUU5GsUaYbINsfXaMZLDfkN2XabcuUVUGSFSPV8/fBx9/LkLkivQywXxVojJX4WMLgc4BcG9SN6ct4z6d0/gcxD/XRoyWzj/S4rt45iSV67XA1vExUBqIWCEm+GLgJYCEfoolu4iD2mEM5psM6MG0WLm06/s+tv5+pwSyHviyPTmrFKPIM18znxqbVVzTFsb9UlFQ080ndHOK4Bu6akpSjb0Yg6n7HOmZSgJzNo0BtFw4el0yFosVbRgKm6t6WdRaNAu2puaNwcOuVTWrNJB22udtnViJmpPIW6zf2BwtWMGTVu2JxDz7XH9k1ZoRo1mifhFYZpw5h6SX1dAvdZGsS2jhCsiVFTsoN86XHi2LAK2j7WEL3BW8iv28zw8V1XiFNH4VcTb0xstnRPmme1gtEOGDnNjDUzqg/8H7NY0+hvGaCcYzDUDOznnEU2misz3cM9HXHLiWDwT3vwLI4PwB9cT9pErCAAA";
    private static final Log log = LogFactory.getLog(JButtonDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton fancyButon;
    protected ImageIcon pencil;
    protected JButton simpleButon;
    protected JButtonDemo topDemoPanel = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void buttonClicked(JButton button) {
        JOptionPane.showMessageDialog(this, button.getText() + " clicked!",
        "onActionPerformed",
        JOptionPane.INFORMATION_MESSAGE);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JButtonDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JButtonDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JButtonDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JButtonDemo() {
        $initialize();
    }

    public JButtonDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__fancyButon(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        buttonClicked((JButton) event.getSource());
    }

    public void doActionPerformed__on__simpleButon(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        buttonClicked((JButton) event.getSource());
    }

    public void doMouseEntered__on__fancyButon(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(JButtonDemo.this, fancyButon, "font-style", "italic", Pseudoclasses.wrap((fancyButon.getFont().getStyle() & Font.ITALIC) != 0 ? "italic" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (fancyButon.getFont() != null) {
            if (((String) value).equals("italic")) {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() | Font.ITALIC));
            } else {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() & ~Font.ITALIC));
            }
        }
        }
        value = Pseudoclasses.applyProperty(JButtonDemo.this, fancyButon, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap(fancyButon.getForeground()), 0);
        if (!(value instanceof DataBinding)) {
            fancyButon.setForeground((Color) value);
        }
    }

    public void doMouseExited__on__fancyButon(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(JButtonDemo.this, fancyButon, "font-style", "italic", Pseudoclasses.wrap((fancyButon.getFont().getStyle() & Font.ITALIC) != 0 ? "italic" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (fancyButon.getFont() != null) {
            if (((String) value).equals("italic")) {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() | Font.ITALIC));
            } else {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() & ~Font.ITALIC));
            }
        }
        }
        value = Pseudoclasses.removeProperty(JButtonDemo.this, fancyButon, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap(fancyButon.getForeground()), 0);
        if (!(value instanceof DataBinding)) {
            fancyButon.setForeground((Color) value);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getFancyButon() {
        return fancyButon;
    }

    public ImageIcon getPencil() {
        return pencil;
    }

    public JButton getSimpleButon() {
        return simpleButon;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(DemoHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTopDemoPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($VBox0);
    }

    protected void createFancyButon() {
        $objectMap.put("fancyButon", fancyButon = new JButton());
        
        fancyButon.setName("fancyButon");
        fancyButon.setText(t("Fancy Button"));
        if (fancyButon.getFont() != null) {
            fancyButon.setFont(fancyButon.getFont().deriveFont((float) 18));
        }
        if (fancyButon.getFont() != null) {
            fancyButon.setFont(new Font("Arial", fancyButon.getFont().getStyle(), fancyButon.getFont().getSize()));
        }
        fancyButon.setForeground(new Color(0, 0, 255));
        fancyButon.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fancyButon"));
        fancyButon.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__fancyButon"));
        fancyButon.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__fancyButon"));
        fancyButon.putClientProperty("help", "ui.component.swing.buttons.JButtonDemo.fancyButon");
    }

    @Override
    protected void createHelpDefaultId() {
        $objectMap.put("helpDefaultId", helpDefaultId = "ui.component.swing.buttons.JButtonDemo");
    }

    protected void createPencil() {
        $objectMap.put("pencil", pencil = new ImageIcon(getClass().getResource("/jaxx/demo/images/pencil_black.gif")));
    }

    protected void createSimpleButon() {
        $objectMap.put("simpleButon", simpleButon = new JButton());
        
        simpleButon.setName("simpleButon");
        simpleButon.setText(t("Simple Button"));
        simpleButon.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleButon"));
        simpleButon.putClientProperty("help", "ui.component.swing.buttons.JButtonDemo.simpleButon");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTopDemoPanel();
        // inline complete setup of $VBox0
        $VBox0.add(simpleButon);
        $VBox0.add(fancyButon);
        
        // apply 1 property setters
        fancyButon.setIcon(pencil);
        // late initializer
        // help broker setup
        DemoHelpBroker _broker = getBroker();
        registerHelpId(_broker, topDemoPanel, "ui.component.swing.buttons.JButtonDemo");
        registerHelpId(_broker, simpleButon, "ui.component.swing.buttons.JButtonDemo.simpleButon");
        registerHelpId(_broker, fancyButon, "ui.component.swing.buttons.JButtonDemo.fancyButon");
        _broker.prepareUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("topDemoPanel", topDemoPanel);
        createPencil();
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setVerticalAlignment(0);
        createSimpleButon();
        createFancyButon();
        // inline creation of topDemoPanel
        setName("topDemoPanel");
        topDemoPanel.putClientProperty("help", "ui.component.swing.buttons.JButtonDemo");
        
        $completeSetup();
    }

}