package jaxx.demo;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import jaxx.demo.tree.DemoCellRenderer;
import jaxx.demo.tree.DemoTreeHelper;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.StatusMessagePanel;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class DemoUI extends JFrame implements JAXXHelpUI<DemoHelpBroker>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MAIN_FRAME_ICON_IMAGE = "mainFrame.iconImage";
    public static final String BINDING_MAIN_FRAME_UNDECORATED = "mainFrame.undecorated";
    public static final String BINDING_MENU_FILE_FULLSCREEN_VISIBLE = "menuFileFullscreen.visible";
    public static final String BINDING_MENU_FILE_LANGUAGE_FR_ENABLED = "menuFileLanguageFR.enabled";
    public static final String BINDING_MENU_FILE_LANGUAGE_UK_ENABLED = "menuFileLanguageUK.enabled";
    public static final String BINDING_MENU_FILE_NORMALSCREEN_VISIBLE = "menuFileNormalscreen.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(DemoUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected DemoHelpBroker broker;
    protected DemoConfig config;
    protected JPanel content;
    protected CardLayout2 contentLayout;
    protected final DemoUIHandler handler = createHandler();
    protected DemoUI mainFrame = this;
    protected JPanel mainPane;
    protected JMenuBar menu;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileExit;
    protected JMenuItem menuFileFullscreen;
    protected JMenu menuFileLanguage;
    protected JMenuItem menuFileLanguageFR;
    protected JMenuItem menuFileLanguageUK;
    protected JMenuItem menuFileNormalscreen;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpHelp;
    protected JMenuItem menuHelpLogs;
    protected JMenuItem menuHelpSite;
    protected JTree navigation;
    protected JScrollPane navigationPane;
    protected StatusMessagePanel p;
    protected JButton showHelp;
    protected JSplitPane splitPane;
    protected DemoTreeHelper treeHelper;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JToolBar $JToolBar0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public boolean acceptLocale(Locale l, String expected) {
      return l !=null && l.toString().equals(expected);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoUI() {
        $initialize();
    }

    public DemoUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(String param0) {
        super(param0);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuFileConfiguration(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showConfig(this);
    }

    public void doActionPerformed__on__menuFileExit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.close(this);
    }

    public void doActionPerformed__on__menuFileFullscreen(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeScreen(this, true);
    }

    public void doActionPerformed__on__menuFileLanguageFR(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__menuFileLanguageUK(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__menuFileNormalscreen(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeScreen(this, false);
    }

    public void doActionPerformed__on__menuHelpAbout(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showAbout(this);
    }

    public void doActionPerformed__on__menuHelpHelp(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showHelp(this, null);
    }

    public void doActionPerformed__on__menuHelpLogs(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showLogs(this);
    }

    public void doActionPerformed__on__menuHelpSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.gotoSite(this);
    }

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.close(mainFrame);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoHelpBroker getBroker() {
        return broker;
    }

    public DemoConfig getConfig() {
        return config;
    }

    public JPanel getContent() {
        return content;
    }

    public CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public DemoUIHandler getHandler() {
        return handler;
    }

    public JPanel getMainPane() {
        return mainPane;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenuItem getMenuFileFullscreen() {
        return menuFileFullscreen;
    }

    public JMenu getMenuFileLanguage() {
        return menuFileLanguage;
    }

    public JMenuItem getMenuFileLanguageFR() {
        return menuFileLanguageFR;
    }

    public JMenuItem getMenuFileLanguageUK() {
        return menuFileLanguageUK;
    }

    public JMenuItem getMenuFileNormalscreen() {
        return menuFileNormalscreen;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpHelp() {
        return menuHelpHelp;
    }

    public JMenuItem getMenuHelpLogs() {
        return menuHelpLogs;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public JTree getNavigation() {
        return navigation;
    }

    public JScrollPane getNavigationPane() {
        return navigationPane;
    }

    public StatusMessagePanel getP() {
        return p;
    }

    public JButton getShowHelp() {
        return showHelp;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public DemoTreeHelper getTreeHelper() {
        return treeHelper;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(DemoHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPane);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMainPane() {
        if (!allComponentsCreated) {
            return;
        }
        mainPane.add(splitPane, BorderLayout.CENTER);
        mainPane.add(p, BorderLayout.SOUTH);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuHelp);
        menu.add($JToolBar0);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileLanguage);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileFullscreen);
        menuFile.add(menuFileNormalscreen);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuFileLanguage() {
        if (!allComponentsCreated) {
            return;
        }
        menuFileLanguage.add(menuFileLanguageFR);
        menuFileLanguage.add(menuFileLanguageUK);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpLogs);
        menuHelp.add(menuHelpHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void addChildrenToNavigationPane() {
        if (!allComponentsCreated) {
            return;
        }
        navigationPane.getViewport().add(navigation);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add(navigationPane, JSplitPane.LEFT);
        splitPane.add(content, JSplitPane.RIGHT);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new DemoHelpBroker("ui.main.menu"));
    }

    protected void createConfig() {
        $objectMap.put("config", config = getContextValue(DemoConfig.class));
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
        content.putClientProperty("help", "ui.main.body.db.view.content");
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new CardLayout2());
        
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected DemoUIHandler createHandler() {
        return new DemoUIHandler();
    }

    protected void createMainPane() {
        $objectMap.put("mainPane", mainPane = new JPanel());
        
        mainPane.setName("mainPane");
        mainPane.setLayout(new BorderLayout());
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
        menu.putClientProperty("help", "ui.main.menu");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(t("jaxxdemo.menu.file"));
        menuFile.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(t("jaxxdemo.action.configuration"));
        menuFileConfiguration.setToolTipText(t("jaxxdemo.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
        menuFileConfiguration.putClientProperty("help", "ui.main.menu.file.configuration");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(t("jaxxdemo.action.exit"));
        menuFileExit.setToolTipText(t("jaxxdemo.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
        menuFileExit.putClientProperty("help", "ui.main.menu.file.exit");
    }

    protected void createMenuFileFullscreen() {
        $objectMap.put("menuFileFullscreen", menuFileFullscreen = new JMenuItem());
        
        menuFileFullscreen.setName("menuFileFullscreen");
        menuFileFullscreen.setText(t("jaxxdemo.action.fullscreen"));
        menuFileFullscreen.setToolTipText(t("jaxxdemo.action.fullscreen.tip"));
        menuFileFullscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileFullscreen"));
        menuFileFullscreen.putClientProperty("help", "ui.main.menu.file.fullscreen");
    }

    protected void createMenuFileLanguage() {
        $objectMap.put("menuFileLanguage", menuFileLanguage = new JMenu());
        
        menuFileLanguage.setName("menuFileLanguage");
        menuFileLanguage.setText(t("jaxxdemo.menu.file.locale"));
        menuFileLanguage.setToolTipText(t("jaxxdemo.menu.file.locale"));
        menuFileLanguage.putClientProperty("help", "ui.main.menu.file.locale");
    }

    protected void createMenuFileLanguageFR() {
        $objectMap.put("menuFileLanguageFR", menuFileLanguageFR = new JMenuItem());
        
        menuFileLanguageFR.setName("menuFileLanguageFR");
        menuFileLanguageFR.setText(t("jaxxdemo.action.locale.fr"));
        menuFileLanguageFR.setToolTipText(t("jaxxdemo.action.locale.fr.tip"));
        menuFileLanguageFR.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageFR"));
        menuFileLanguageFR.putClientProperty("help", "ui.main.menu.file.locale.fr");
    }

    protected void createMenuFileLanguageUK() {
        $objectMap.put("menuFileLanguageUK", menuFileLanguageUK = new JMenuItem());
        
        menuFileLanguageUK.setName("menuFileLanguageUK");
        menuFileLanguageUK.setText(t("jaxxdemo.action.locale.uk"));
        menuFileLanguageUK.setToolTipText(t("jaxxdemo.action.locale.uk.tip"));
        menuFileLanguageUK.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageUK"));
        menuFileLanguageUK.putClientProperty("help", "ui.main.menu.file.locale.uk");
    }

    protected void createMenuFileNormalscreen() {
        $objectMap.put("menuFileNormalscreen", menuFileNormalscreen = new JMenuItem());
        
        menuFileNormalscreen.setName("menuFileNormalscreen");
        menuFileNormalscreen.setText(t("jaxxdemo.action.normalscreen"));
        menuFileNormalscreen.setToolTipText(t("jaxxdemo.action.normalscreen.tip"));
        menuFileNormalscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileNormalscreen"));
        menuFileNormalscreen.putClientProperty("help", "ui.main.menu.file.leave-fullscreen");
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(t("jaxxdemo.menu.help"));
        menuHelp.putClientProperty("help", "ui.main.menu.help");
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(t("jaxxdemo.action.about"));
        menuHelpAbout.setToolTipText(t("jaxxdemo.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
        menuHelpAbout.putClientProperty("help", "ui.main.menu.help.about");
    }

    protected void createMenuHelpHelp() {
        $objectMap.put("menuHelpHelp", menuHelpHelp = new JMenuItem());
        
        menuHelpHelp.setName("menuHelpHelp");
        menuHelpHelp.setText(t("jaxxdemo.action.help"));
        menuHelpHelp.setToolTipText(t("jaxxdemo.action.help.tip"));
        menuHelpHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpHelp"));
        menuHelpHelp.putClientProperty("help", "ui.main.menu.help.help");
    }

    protected void createMenuHelpLogs() {
        $objectMap.put("menuHelpLogs", menuHelpLogs = new JMenuItem());
        
        menuHelpLogs.setName("menuHelpLogs");
        menuHelpLogs.setText(t("jaxxdemo.action.showLogs"));
        menuHelpLogs.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpLogs"));
        menuHelpLogs.putClientProperty("help", "ui.main.action.showLogs");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(t("jaxxdemo.action.site"));
        menuHelpSite.setToolTipText(t("jaxxdemo.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "ui.main.menu.help.site");
    }

    protected void createNavigation() {
        $objectMap.put("navigation", navigation = new JTree());
        
        navigation.setName("navigation");
        navigation.setRootVisible(false);
        if (navigation.getFont() != null) {
            navigation.setFont(navigation.getFont().deriveFont((float) 11));
        }
        navigation.setLargeModel(true);
        navigation.setShowsRootHandles(false);
    }

    protected void createNavigationPane() {
        $objectMap.put("navigationPane", navigationPane = new JScrollPane());
        
        navigationPane.setName("navigationPane");
    }

    protected void createP() {
        $objectMap.put("p", p = new StatusMessagePanel());
        
        p.setName("p");
    }

    protected void createShowHelp() {
        $objectMap.put("showHelp", showHelp = new JButton());
        
        showHelp.setName("showHelp");
        showHelp.setVisible(true);
        showHelp.setToolTipText(t("jaxxdemo.action.showHelp.tip"));
        showHelp.setBorderPainted(false);
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerSize(6);
    }

    protected void createTreeHelper() {
        $objectMap.put("treeHelper", treeHelper = getContextValue(DemoTreeHelper.class));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuFileLanguage();
        addChildrenToMenuHelp();
        // inline complete setup of $JToolBar0
        $JToolBar0.add(showHelp, BorderLayout.EAST);
        addChildrenToMainPane();
        addChildrenToSplitPane();
        addChildrenToNavigationPane();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 32 property setters
        menuFile.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.menu.file.mnemonic"),'Z'));
        menuFileConfiguration.setIcon(SwingUtil.createActionIcon("config"));
        menuFileConfiguration.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.configuration.mnemonic"),'Z'));
        menuFileLanguage.setIcon(SwingUtil.createActionIcon("translate"));
        menuFileLanguage.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.menu.file.locale.mnemonic"),'Z'));
        menuFileLanguageFR.setIcon(SwingUtil.createActionIcon("i18n-fr"));
        menuFileLanguageFR.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.locale.fr.mnemonic"),'Z'));
        menuFileLanguageUK.setIcon(SwingUtil.createActionIcon("i18n-uk"));
        menuFileLanguageUK.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.locale.uk.mnemonic"),'Z'));
        menuFileFullscreen.setIcon(SwingUtil.createActionIcon("fullscreen"));
        menuFileFullscreen.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.fullscreen.mnemonic"),'Z'));
        menuFileNormalscreen.setIcon(SwingUtil.createActionIcon("leave-fullscreen"));
        menuFileNormalscreen.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.normalscreen.mnemonic"),'Z'));
        menuFileExit.setIcon(SwingUtil.createActionIcon("exit"));
        menuFileExit.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.exit.mnemonic"),'Z'));
        menuHelp.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.menu.help.mnemonic"),'Z'));
        menuHelpLogs.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.showLogs.mnemonic"),'Z'));
        menuHelpHelp.setIcon(SwingUtil.createActionIcon("help"));
        menuHelpHelp.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.help.mnemonic"),'Z'));
        menuHelpSite.setIcon(SwingUtil.createActionIcon("site"));
        menuHelpSite.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.site.mnemonic"),'Z'));
        menuHelpAbout.setIcon(SwingUtil.createActionIcon("about"));
        menuHelpAbout.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.about.mnemonic"),'Z'));
        showHelp.setIcon(SwingUtil.createActionIcon("show-help"));
        navigationPane.setMinimumSize(new Dimension(230,0));
        navigationPane.setBorder(null);
        navigationPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        navigation.setModel(getTreeHelper().createModel());
        navigation.setCellRenderer(new DemoCellRenderer(getTreeHelper().getDataProvider()));
        // late initializer
        // help broker setup
        DemoHelpBroker _broker = getBroker();
        registerHelpId(_broker, menu, "ui.main.menu");
        registerHelpId(_broker, menuFile, "ui.main.menu.file");
        registerHelpId(_broker, menuFileConfiguration, "ui.main.menu.file.configuration");
        registerHelpId(_broker, menuFileLanguage, "ui.main.menu.file.locale");
        registerHelpId(_broker, menuFileLanguageFR, "ui.main.menu.file.locale.fr");
        registerHelpId(_broker, menuFileLanguageUK, "ui.main.menu.file.locale.uk");
        registerHelpId(_broker, menuFileFullscreen, "ui.main.menu.file.fullscreen");
        registerHelpId(_broker, menuFileNormalscreen, "ui.main.menu.file.leave-fullscreen");
        registerHelpId(_broker, menuFileExit, "ui.main.menu.file.exit");
        registerHelpId(_broker, menuHelp, "ui.main.menu.help");
        registerHelpId(_broker, menuHelpLogs, "ui.main.action.showLogs");
        registerHelpId(_broker, menuHelpHelp, "ui.main.menu.help.help");
        registerHelpId(_broker, menuHelpSite, "ui.main.menu.help.site");
        registerHelpId(_broker, menuHelpAbout, "ui.main.menu.help.about");
        registerHelpId(_broker, content, "ui.main.body.db.view.content");
        _broker.prepareUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("mainFrame", mainFrame);
        createContentLayout();
        createConfig();
        createTreeHelper();
        createBroker();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuFileLanguage();
        createMenuFileLanguageFR();
        createMenuFileLanguageUK();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileFullscreen();
        createMenuFileNormalscreen();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuHelp();
        createMenuHelpLogs();
        createMenuHelpHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setLayout(new BorderLayout());
        $JToolBar0.setFloatable(false);
        $JToolBar0.setOpaque(false);
        $JToolBar0.setBorderPainted(false);
        createShowHelp();
        createMainPane();
        createSplitPane();
        createNavigationPane();
        createNavigation();
        createContent();
        createP();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,800);
        SwingUtil.setComponentWidth(mainFrame,1024);
        setTitle(t("JAXX Demo"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_ICON_IMAGE, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("iconPath", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setIconImage(SwingUtil.createIcon(getConfig().getIconPath()).getImage());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("iconPath", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_UNDECORATED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fullScreen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setUndecorated(getConfig().isFullScreen());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fullScreen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageFR.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageUK.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_FULLSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileFullscreen.setVisible(!isUndecorated());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_NORMALSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileNormalscreen.setVisible(isUndecorated());
            }
        });
    }

}