/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id: DemoCellRenderer.java 2118 2010-10-26 17:44:57Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2.5/jaxx-demo/src/main/java/jaxx/demo/tree/DemoCellRenderer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.demo.tree;

import jaxx.demo.feature.nav.NavDemoDataProvider;
import jaxx.runtime.swing.nav.tree.AbstractNavTreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import java.awt.Component;

import static org.nuiton.i18n.I18n._;

/**
 * @author sletellier <letellier@codelutin.com>
 * @since 2.1
 */
public class DemoCellRenderer extends AbstractNavTreeCellRenderer<DefaultTreeModel, DemoNode> {

    /** Logger */
    protected static final Log log =
            LogFactory.getLog(DemoCellRenderer.class);


    public DemoCellRenderer(DemoDataProvider provider) {
        setDataProvider(provider);
    }

    @Override
    public NavDemoDataProvider getDataProvider() {
        return (NavDemoDataProvider) super.getDataProvider();
    }

    @Override
    protected String computeNodeText(DemoNode node) {

        if (node == null) {
            return "";
        }


        String toDecorate;

        String id = node.getId();

        if (node.isStringNode()) {

            // String node
            toDecorate = _(id);
        } else {

            // Demo node
            toDecorate = id;
        }

        if (log.isDebugEnabled()) {
            log.debug("Compute text for node " + node +
                      " (" + node.getInternalClass() + ") = " + toDecorate);
        }

        return toDecorate;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree,
                                                  Object value,
                                                  boolean sel,
                                                  boolean expanded,
                                                  boolean leaf, int row,
                                                  boolean hasFocus) {

        // get node
        DemoNode node = (DemoNode) value;

        // get text for node
        String text = getNodeText(node);

        // Render node
        return super.getTreeCellRendererComponent(tree, text, sel,
                                                  expanded, leaf,
                                                  row, hasFocus);
    }
}