/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.swing.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class JDialogDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL1_TEXT = "$JLabel1.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVy27TQBSdhCZt+m6qhrYUKUC6AAmHgliglr4VlSqFilaoIptO4lEyZeIx9rh1WQCfwCfAng0SO1aIBWsWbBC/gBALtog747ycuKmlZGE793HuOXd8r9//QjHbQleOsOtqlmMIWiXa9trBwaPiESmJTWKXLGoKbiHvF4miaAEN6Q27LdC1Ql6mZ2vp2Q1eNblBjJbsxTwatMUpI3aFECHQZX9Gybazew33oms6Vh21QSoI9e2f39E3+ut3UYRcE9iNgZT0eVlNJX15FKW6QEmodIyzDBtloGFRowx8R6Rtg2Hbfoir5Dl6ifrzKG5iC8AEuhpessJQ+a4p0FBmk1T5LjYIuyXQvCKrg0Ur1SE0+wQYaNubFDNeltGmqfLjAsUzT9a5C4kXfSq9DOmScYlGeCKzve4IwQ3ImJR63Dq4Z5Zhw23gC/LfqN8zkNnO46JinPTBKKsMSnbEKpyU3xfXlaZ2Mp7Spsr+zD4uMgLVpgNkKp+MnOmoebtRc67hG3FsYhlwhDlKGBx2yld6n7hCOfxJdcA7QYAmnOcJt/Qa4KwPcLfV2QFaP/dkW47hdbEZG+XP5NOEvFzvPM+FVqeFLvnaBNOkNaep+bpHCihmOWCGvhY6B/AxuLzRm24bPQmovP9Sk98//fyYq89bEmpPBYa2rAuYA9PiJrEElaXHvGFzBGXZHWwuFlDCJgx2jdolcwHE9mpuIAf1JmS6JtO1LWxXACLW/+Pzl9ThtwsomkODjGM9h2X8A5QQFQu6wJnumiuritHwyQBcxyU3eA0r3KIvuCEwW2O0bFTVbCeXqMGoQdJYwDIoOoIsu9CVuYCuNKgVE1//Tu59WK13JgJMZ84Mb3Yn9hTFvWpqF9XWTODuGTJt4ui8uU6CFkxE3kfM2izdVdd7QdInjuWBlFqEy9Al15G3+0qBfFoJDdgnYJS6YIyfiyHNWwKNLulY4HSRGjpMx3Iw2lQ4NHnZCUaYDqEpVuU6Zl1EzYYBEVR4C6sHkAEm11GOW10UpcP35Awm5yPAi6NT22T4lOg7BnybDFrqCVCaD7uImu9ZVDgE2hMCfNqgJdwRXZTcCIMCi4t63+UzUG723I9wCK+6cMj2zEEi/Ae5tNcdewoAAA==";
    private static final Log log = LogFactory.getLog(jaxx.demo.component.swing.JDialogDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JDialog dialog;
    protected javax.swing.JButton ok;
    protected javax.swing.JPasswordField passwordField;
    protected javax.swing.JTextField usernameField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JDialogDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.VBox $VBox0;
    private javax.swing.JButton $JButton0;
    private jaxx.runtime.swing.VBox $VBox1;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    String username;
    String password;
    private class OKAction extends javax.swing.AbstractAction {
        public OKAction() {
        putValue(NAME, "OK");
        }
    
        public void actionPerformed(ActionEvent e) {
        jaxx.runtime.JAXXUtil.assignment(username = usernameField.getText(), "username", jaxx.demo.component.swing.JDialogDemo.this);
        jaxx.runtime.JAXXUtil.assignment(password = new String(passwordField.getPassword()), "password", jaxx.demo.component.swing.JDialogDemo.this);
        dialog.dispose();
        }
        }private class CancelAction extends javax.swing.AbstractAction {
        public CancelAction() {
        putValue(NAME, "Cancel");
        }
    
    
        public void actionPerformed(ActionEvent e) {
        dialog.dispose();
        }
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JDialogDemo() {
        super();
        $initialize();
    }

    public JDialogDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        dialog.setVisible(true);
    }

    public void doWindowOpened__on__dialog(java.awt.event.WindowEvent event) {
        dialog.setLocationRelativeTo(JDialogDemo.this);                                                                     passwordField.setText("");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JDialog getDialog() {
        return dialog;
    }

    public javax.swing.JButton getOk() {
        return ok;
    }

    public javax.swing.JPasswordField getPasswordField() {
        return passwordField;
    }

    public javax.swing.JTextField getUsernameField() {
        return usernameField;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.VBox get$VBox0() {
        return $VBox0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected jaxx.runtime.swing.VBox get$VBox1() {
        return $VBox1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDialog() {
        if (!allComponentsCreated) {
            return;
        }
        dialog.getContentPane().add($Table0);
    }

    protected void createDialog() {
        $objectMap.put("dialog", dialog = new javax.swing.JDialog());
        
        dialog.setName("dialog");
        dialog.setModal(true);
        dialog.setTitle(_("Sign on"));
        dialog.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowOpened", this, "doWindowOpened__on__dialog"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new javax.swing.JButton());
        
        ok.setName("ok");
        ok.setText(_("OK"));
    }

    protected void createPasswordField() {
        $objectMap.put("passwordField", passwordField = new javax.swing.JPasswordField());
        
        passwordField.setName("passwordField");
        passwordField.setColumns(15);
    }

    protected void createUsernameField() {
        $objectMap.put("usernameField", usernameField = new javax.swing.JTextField());
        
        usernameField.setName("usernameField");
        usernameField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($VBox0);
        // inline complete setup of $VBox0
        $VBox0.add($JButton0);
        $VBox0.add($VBox1);
        // inline complete setup of $VBox1
        $VBox1.add($JLabel0);
        $VBox1.add($JLabel1);
        addChildrenToDialog();
        // inline complete setup of $Table0
        $Table0.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(usernameField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(passwordField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(ok);
        $JPanel0.add($JButton1);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        $JLabel2.setLabelFor(usernameField);
        $JLabel3.setLabelFor(passwordField);
        ok.setAction(new OKAction());
        $JButton1.setAction(new CancelAction());
        // late initializer
        dialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new jaxx.runtime.swing.VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setVerticalAlignment(0);
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("Show password dialog"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $VBox1
        $objectMap.put("$VBox1", $VBox1 = new jaxx.runtime.swing.VBox());
        
        $VBox1.setName("$VBox1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        createDialog();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("Username:"));
        $JLabel2.setDisplayedMnemonic(85);
        createUsernameField();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("Password:"));
        $JLabel3.setDisplayedMnemonic(80);
        createPasswordField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0, 6, 6));
        createOk();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("Cancel"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        {
            JRootPane rootPane = dialog.getRootPane();
            rootPane.setDefaultButton(ok);
            rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("ESCAPE"),
            "cancel");
            rootPane.getActionMap().put("cancel", new CancelAction());
            };// registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"username") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(_(username != null ? "Username: " + username : ""));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_TEXT, true ,"password") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setText(_(password != null ? "Password: " + password : ""));
            }
        });
    }

}