/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.swing.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class JTextAreaDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JTEXT_AREA0_TEXT = "$JTextArea0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRBdm9jxRwL5IF8kkQJYICFxDhJUiUiiRBZYDiCcIsINe3cr+8L6btndI5cG8RP4CdDTINFRIQpqChrEX0CIghYxu/adc+RiW+BifZ6d9+bN+M29+Y4ygqOLBzgIDO670mkTo7q1v3/fPCCW3CHC4g6THkedTyqN0g1UtKO4kOhyo6bg5S68vO21mecS9xh6rYYKQh5RIlqESImW4whLiHI9ul4LmM9D1khUEuurnz/SL+0Xr9MIBQzU5aGVlUGoXicjNZR2bImmoNIzXKbYbYIM7rhN0DuuYtsUC3EPt8lT9ByN1lCWYQ5kEl0avmXNofEBk6hY2iFt7wF2CV2V6KoWa0PEsEIKQxyCAqO6RwK5xQlW+YxphqxEo6U9bFIC2PlYox2QvlOZ+QiQK1Vr2NTVplRLQcivoyppLModL1XrFvcoVfoAMBcD9K7iqJzsKpVoJgYIO1B5UycE3VC/J/sI0Ann4wnFUsS6qkJz6rhwnDscbbxZHe1ScbQYGx24z+i5r2ePVANluA9hmHXjpGEfwlXHqvN/WVUR6tvfs9Nf3n97Vwn9WYDaM4mpx9YLfMO4xwiXjip9rmNOXzq0vIvZWgNcTijspt69pQRh9e41iIN6kwpuKLhxB4sWUGRGv374OPv48xmUrqAC9bBdwSr/LsrLFocpeNQO2MamVjR2mINzQmmD8VL1x1U8LtHZdRtLvGI6rg0Dvh3AGJYSxhBpMfOffk3X326Go0iBtIVT03vjyDxCWceljkv0snb3MHE5i0wQ3/Z6+5a0gSn1PcG6C3VFn9eSeh1RrgYbrXeqr2AJbwbTlwR6VSBDN6GeVofmnLQdwSg+IvauC1vtOpZKvfXvhNkWcZot2YdleiCLCt/swzD73wwLQzFs9GFYHGIWBRNbT5rc813tkuvJTMtDMOWI7cjwTXqKosE80VT6KPkDkwiYon8HAAA=";
    private static final Log log = LogFactory.getLog(jaxx.demo.component.swing.JTextAreaDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTextArea textArea;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JTextAreaDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JScrollPane $JScrollPane1;
    private javax.swing.JTextArea $JTextArea0;
    private javax.swing.JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextAreaDemo() {
        super();
        $initialize();
    }

    public JTextAreaDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTextArea getTextArea() {
        return textArea;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected javax.swing.JTextArea get$JTextArea0() {
        return $JTextArea0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createTextArea() {
        $objectMap.put("textArea", textArea = new javax.swing.JTextArea());
        
        textArea.setName("textArea");
        textArea.setColumns(15);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        jaxx.runtime.SwingUtil.setText(textArea, "Try typing some text here.");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(textArea);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add($JTextArea0);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        $JLabel0.setLabelFor(textArea);
        $JTextArea0.setBackground(null);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("Normal text:"));
        $JLabel0.setDisplayedMnemonic(78);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        SwingUtil.setComponentHeight($JScrollPane0,120);
        createTextArea();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("Upper case text:"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        SwingUtil.setComponentHeight($JScrollPane1,120);
        // inline creation of $JTextArea0
        $objectMap.put("$JTextArea0", $JTextArea0 = new javax.swing.JTextArea());
        
        $JTextArea0.setName("$JTextArea0");
        $JTextArea0.setColumns(15);
        $JTextArea0.setLineWrap(true);
        $JTextArea0.setWrapStyleWord(true);
        $JTextArea0.setEditable(false);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JTEXT_AREA0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (textArea != null) {
                    $bindingSources.put("textArea.getDocument()", textArea.getDocument());
                    textArea.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    textArea.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JTextAreaDemo.this, BINDING_$JTEXT_AREA0_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (textArea != null && textArea.getText() != null) {
                    jaxx.runtime.SwingUtil.setText($JTextArea0, textArea.getText().toUpperCase());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (textArea != null) {
                    javax.swing.text.Document $target = ((javax.swing.text.Document) $bindingSources.remove("textArea.getDocument()"));
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    textArea.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JTextAreaDemo.this, BINDING_$JTEXT_AREA0_TEXT));
                }
            }
        
            public void $pr$u0(javax.swing.event.DocumentEvent event) {
                propertyChange(null);
            }
        });
    }

}