package jaxx.demo.feature.validation.simple;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.Identity;
import jaxx.demo.entities.Model;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageListModel;
import jaxx.runtime.validator.swing.SwingValidatorMessageListRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.IconValidationUI;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import jaxx.runtime.validator.swing.ui.TranslucentValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

public class SimpleBeanValidationByListDemo extends DemoPanel implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AGE_VALUE = "age.value";
    public static final String BINDING_CONFIG_TEXT = "config.text";
    public static final String BINDING_DIR_TEXT = "dir.text";
    public static final String BINDING_EMAIL2_TEXT = "email2.text";
    public static final String BINDING_FIRST_NAME_TEXT = "firstName.text";
    public static final String BINDING_LAST_NAME_TEXT = "lastName.text";
    public static final String BINDING_RATIO_VALUE = "ratio.value";
    public static final String BINDING_TEXT2_TEXT = "text2.text";
    public static final String BINDING_TEXT_TEXT = "text.text";
    public static final String BINDING__RATIO_VALUE = "_ratio.value";
    public static final String BINDING__TEXT2_TEXT = "_text2.text";
    public static final String BINDING__TEXT_TEXT = "_text.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL13_TEXT = "$JLabel13.text";
    private static final String BINDING_$JLABEL15_TEXT = "$JLabel15.text";
    private static final String BINDING_$JLABEL17_TEXT = "$JLabel17.text";
    private static final String BINDING_$JLABEL25_TEXT = "$JLabel25.text";
    private static final String BINDING_$JLABEL27_TEXT = "$JLabel27.text";
    private static final String BINDING_$JLABEL29_TEXT = "$JLabel29.text";
    private static final String BINDING_$JLABEL31_TEXT = "$JLabel31.text";
    private static final String BINDING_$JLABEL33_TEXT = "$JLabel33.text";
    private static final String BINDING_$JLABEL35_TEXT = "$JLabel35.text";
    private static final String BINDING_$JLABEL4_TEXT = "$JLabel4.text";
    private static final String BINDING_$JLABEL6_TEXT = "$JLabel6.text";
    private static final String BINDING_$JLABEL8_TEXT = "$JLabel8.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SimpleBeanValidationByListDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator2",  propertyName = "ratio",  editorName = "_ratio")
    protected JSlider _ratio;
    @ValidatorField( validatorId = "validator2",  propertyName = "text",  editorName = "_text")
    protected JTextField _text;
    @ValidatorField( validatorId = "validator2",  propertyName = "text2",  editorName = "_text2")
    protected JTextField _text2;
    @ValidatorField( validatorId = "validator3",  propertyName = "age",  editorName = "age")
    protected JSlider age;
    protected JButton cancel;
    @ValidatorField( validatorId = "validator3",  propertyName = "config",  editorName = "config")
    protected JTextField config;
    @ValidatorField( validatorId = "validator3",  propertyName = "dir",  editorName = "dir")
    protected JTextField dir;
    @ValidatorField( validatorId = "validator3",  propertyName = "email",  editorName = "email2")
    protected JTextField email2;
    protected JList errorList;
    protected SwingValidatorMessageListModel errorListModel;
    @ValidatorField( validatorId = "validator3",  propertyName = "firstName",  editorName = "firstName")
    protected JTextField firstName;
    protected Identity identity;
    @ValidatorField( validatorId = "validator3",  propertyName = "lastName",  editorName = "lastName")
    protected JTextField lastName;
    protected Model model1;
    protected Model model2;
    protected JButton ok;
    @ValidatorField( validatorId = "validator",  propertyName = "ratio",  editorName = "ratio")
    protected JSlider ratio;
    @ValidatorField( validatorId = "validator",  propertyName = "text",  editorName = "text")
    protected JTextField text;
    @ValidatorField( validatorId = "validator",  propertyName = "text2",  editorName = "text2")
    protected JTextField text2;
    @Validator( validatorId = "validator")
    protected SwingValidator<Model> validator;
    @Validator( validatorId = "validator2")
    protected SwingValidator<Model> validator2;
    @Validator( validatorId = "validator3")
    protected SwingValidator<Identity> validator3;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SimpleBeanValidationByListDemo $DemoPanel0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel10;
    private JLabel $JLabel11;
    private JLabel $JLabel12;
    private JLabel $JLabel13;
    private JLabel $JLabel14;
    private JLabel $JLabel15;
    private JLabel $JLabel16;
    private JLabel $JLabel17;
    private JLabel $JLabel18;
    private JLabel $JLabel19;
    private JLabel $JLabel2;
    private JLabel $JLabel20;
    private JLabel $JLabel21;
    private JLabel $JLabel22;
    private JLabel $JLabel23;
    private JLabel $JLabel24;
    private JLabel $JLabel25;
    private JLabel $JLabel26;
    private JLabel $JLabel27;
    private JLabel $JLabel28;
    private JLabel $JLabel29;
    private JLabel $JLabel3;
    private JLabel $JLabel30;
    private JLabel $JLabel31;
    private JLabel $JLabel32;
    private JLabel $JLabel33;
    private JLabel $JLabel34;
    private JLabel $JLabel35;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JLabel $JLabel8;
    private JLabel $JLabel9;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private JPanel $JPanel5;
    private JPanel $JPanel6;
    private JPanel $JPanel7;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;
    private Table $Table4;
    private Table $Table5;
    private Table $Table6;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return addDefaultSources(
            "Validation.css",
            "/jaxx.demo.entities.Identity.java",
            "/jaxx.demo.entities.Identity-error-validation.xml",
            "/jaxx.demo.entities.Identity-info-validation.xml",
            "/jaxx.demo.entities.Identity-warning-validation.xml",
            "/jaxx.demo.entities.Model.java",
            "/jaxx.demo.entities.Model-error-validation.xml",
            "/jaxx.demo.entities.Model-info-validation.xml",
            "/jaxx.demo.entities.Model-warning-validation.xml"
        );
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SimpleBeanValidationByListDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimpleBeanValidationByListDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SimpleBeanValidationByListDemo() {
        $initialize();
    }

    public SimpleBeanValidationByListDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SimpleBeanValidationByListDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public SimpleBeanValidationByListDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimpleBeanValidationByListDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SimpleBeanValidationByListDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        JOptionPane.showMessageDialog(this, cancel.getText() + " clicked!", "onActionPerformed", JOptionPane.INFORMATION_MESSAGE);
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        JOptionPane.showMessageDialog(this, ok.getText() + " clicked!", "onActionPerformed", JOptionPane.INFORMATION_MESSAGE);
    }

    public void doContentsChanged__on__errorListModel(ListDataEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        ok.setEnabled(errorListModel.isEmpty());
    }

    public void doKeyReleased__on___text(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model2.setText(_text.getText());
    }

    public void doKeyReleased__on___text2(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model2.setText2(_text2.getText());
    }

    public void doKeyReleased__on__config(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        identity.setConfig(new File(config.getText()));
    }

    public void doKeyReleased__on__dir(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        identity.setDir(new File(dir.getText()));
    }

    public void doKeyReleased__on__email2(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        identity.setEmail(email2.getText());
    }

    public void doKeyReleased__on__firstName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        identity.setFirstName(firstName.getText());
    }

    public void doKeyReleased__on__lastName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        identity.setLastName(lastName.getText());
    }

    public void doKeyReleased__on__text(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model1.setText(text.getText());
    }

    public void doKeyReleased__on__text2(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model1.setText2(text2.getText());
    }

    public void doStateChanged__on___ratio(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model2.setRatio(_ratio.getValue());
    }

    public void doStateChanged__on__age(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        identity.setAge(age.getValue());
    }

    public void doStateChanged__on__ratio(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model1.setRatio(ratio.getValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JSlider getAge() {
        return age;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JTextField getConfig() {
        return config;
    }

    public JTextField getDir() {
        return dir;
    }

    public JTextField getEmail2() {
        return email2;
    }

    public JList getErrorList() {
        return errorList;
    }

    public SwingValidatorMessageListModel getErrorListModel() {
        return errorListModel;
    }

    public JTextField getFirstName() {
        return firstName;
    }

    public Identity getIdentity() {
        return identity;
    }

    public JTextField getLastName() {
        return lastName;
    }

    public Model getModel1() {
        return model1;
    }

    public Model getModel2() {
        return model2;
    }

    public JButton getOk() {
        return ok;
    }

    public JSlider getRatio() {
        return ratio;
    }

    public JTextField getText() {
        return text;
    }

    public JTextField getText2() {
        return text2;
    }

    public SwingValidator<Model> getValidator() {
        return validator;
    }

    public SwingValidator<Model> getValidator2() {
        return validator2;
    }

    public SwingValidator<Identity> getValidator3() {
        return validator3;
    }

    public JSlider get_ratio() {
        return _ratio;
    }

    public JTextField get_text() {
        return _text;
    }

    public JTextField get_text2() {
        return _text2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel10() {
        return $JLabel10;
    }

    protected JLabel get$JLabel11() {
        return $JLabel11;
    }

    protected JLabel get$JLabel12() {
        return $JLabel12;
    }

    protected JLabel get$JLabel13() {
        return $JLabel13;
    }

    protected JLabel get$JLabel14() {
        return $JLabel14;
    }

    protected JLabel get$JLabel15() {
        return $JLabel15;
    }

    protected JLabel get$JLabel16() {
        return $JLabel16;
    }

    protected JLabel get$JLabel17() {
        return $JLabel17;
    }

    protected JLabel get$JLabel18() {
        return $JLabel18;
    }

    protected JLabel get$JLabel19() {
        return $JLabel19;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel20() {
        return $JLabel20;
    }

    protected JLabel get$JLabel21() {
        return $JLabel21;
    }

    protected JLabel get$JLabel22() {
        return $JLabel22;
    }

    protected JLabel get$JLabel23() {
        return $JLabel23;
    }

    protected JLabel get$JLabel24() {
        return $JLabel24;
    }

    protected JLabel get$JLabel25() {
        return $JLabel25;
    }

    protected JLabel get$JLabel26() {
        return $JLabel26;
    }

    protected JLabel get$JLabel27() {
        return $JLabel27;
    }

    protected JLabel get$JLabel28() {
        return $JLabel28;
    }

    protected JLabel get$JLabel29() {
        return $JLabel29;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel30() {
        return $JLabel30;
    }

    protected JLabel get$JLabel31() {
        return $JLabel31;
    }

    protected JLabel get$JLabel32() {
        return $JLabel32;
    }

    protected JLabel get$JLabel33() {
        return $JLabel33;
    }

    protected JLabel get$JLabel34() {
        return $JLabel34;
    }

    protected JLabel get$JLabel35() {
        return $JLabel35;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected JPanel get$JPanel6() {
        return $JPanel6;
    }

    protected JPanel get$JPanel7() {
        return $JPanel7;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected Table get$Table4() {
        return $Table4;
    }

    protected Table get$Table5() {
        return $Table5;
    }

    protected Table get$Table6() {
        return $Table6;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorListModel(errorListModel);
        SwingValidatorUtil.registerErrorListMouseListener(errorList);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model1);
    }

    protected void addChildrenToValidator2() {
        if (!allComponentsCreated) {
            return;
        }
        validator2.setErrorListModel(errorListModel);
        SwingValidatorUtil.registerErrorListMouseListener(errorList);
        validator2.setUiClass(IconValidationUI.class);
        validator2.setBean(model2);
    }

    protected void addChildrenToValidator3() {
        if (!allComponentsCreated) {
            return;
        }
        validator3.setErrorListModel(errorListModel);
        SwingValidatorUtil.registerErrorListMouseListener(errorList);
        validator3.setUiClass(TranslucentValidationUI.class);
        validator3.setBean(identity);
    }

    protected void createAge() {
        $objectMap.put("age", age = new JSlider());
        
        age.setName("age");
        age.setValue(0);
        age.setMaximum(100);
        age.setMinimum(0);
        age.setMajorTickSpacing(10);
        age.setPaintTicks(true);
        age.setMinorTickSpacing(5);
        age.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__age"));
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createConfig() {
        $objectMap.put("config", config = new JTextField());
        
        config.setName("config");
        config.setColumns(15);
        config.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__config"));
    }

    protected void createDir() {
        $objectMap.put("dir", dir = new JTextField());
        
        dir.setName("dir");
        dir.setColumns(15);
        dir.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__dir"));
    }

    protected void createEmail2() {
        $objectMap.put("email2", email2 = new JTextField());
        
        email2.setName("email2");
        email2.setColumns(15);
        email2.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__email2"));
    }

    protected void createErrorList() {
        $objectMap.put("errorList", errorList = new JList());
        
        errorList.setName("errorList");
    }

    protected void createErrorListModel() {
        $objectMap.put("errorListModel", errorListModel = new SwingValidatorMessageListModel());
        
        errorListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__errorListModel"));
    }

    protected void createFirstName() {
        $objectMap.put("firstName", firstName = new JTextField());
        
        firstName.setName("firstName");
        firstName.setColumns(15);
        firstName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__firstName"));
    }

    protected void createIdentity() {
        $objectMap.put("identity", identity = new Identity());
    }

    protected void createLastName() {
        $objectMap.put("lastName", lastName = new JTextField());
        
        lastName.setName("lastName");
        lastName.setColumns(15);
        lastName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__lastName"));
    }

    protected void createModel1() {
        $objectMap.put("model1", model1 = new Model());
    }

    protected void createModel2() {
        $objectMap.put("model2", model2 = new Model());
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("valid"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createRatio() {
        $objectMap.put("ratio", ratio = new JSlider());
        
        ratio.setName("ratio");
        ratio.setValue(0);
        ratio.setMaximum(100);
        ratio.setMinimum(0);
        ratio.setMajorTickSpacing(10);
        ratio.setPaintTicks(true);
        ratio.setMinorTickSpacing(5);
        ratio.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__ratio"));
        ratio.putClientProperty("validatorLabel", n("form.ratio"));
    }

    protected void createText() {
        $objectMap.put("text", text = new JTextField());
        
        text.setName("text");
        text.setColumns(15);
        text.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__text"));
        text.putClientProperty("validatorLabel", n("form.text"));
    }

    protected void createText2() {
        $objectMap.put("text2", text2 = new JTextField());
        
        text2.setName("text2");
        text2.setColumns(15);
        text2.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__text2"));
        text2.putClientProperty("validatorLabel", n("form.text2"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Model.class, null));
    }

    protected void createValidator2() {
        $objectMap.put("validator2", validator2 = SwingValidator.newValidator(Model.class, null));
    }

    protected void createValidator3() {
        $objectMap.put("validator3", validator3 = SwingValidator.newValidator(Identity.class, null));
    }

    protected void create_ratio() {
        $objectMap.put("_ratio", _ratio = new JSlider());
        
        _ratio.setName("_ratio");
        _ratio.setValue(0);
        _ratio.setMaximum(100);
        _ratio.setMinimum(0);
        _ratio.setMajorTickSpacing(10);
        _ratio.setPaintTicks(true);
        _ratio.setMinorTickSpacing(5);
        _ratio.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on___ratio"));
        _ratio.putClientProperty("validatorLabel", n("form2.ratio"));
    }

    protected void create_text() {
        $objectMap.put("_text", _text = new JTextField());
        
        _text.setName("_text");
        _text.setColumns(15);
        _text.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on___text"));
        _text.putClientProperty("validatorLabel", n("form2.text"));
    }

    protected void create_text2() {
        $objectMap.put("_text2", _text2 = new JTextField());
        
        _text2.setName("_text2");
        _text2.setColumns(15);
        _text2.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on___text2"));
        _text2.putClientProperty("validatorLabel", n("form2.text2"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        addChildrenToValidator();
        addChildrenToValidator2();
        addChildrenToValidator3();
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel4, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel5, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel6, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel7, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($Table1);
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(text), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(text2), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(ratio), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add($Table2);
        // inline complete setup of $Table2
        $Table2.add($JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel4, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel6, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel7, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel8, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel2
        $JPanel2.add($Table3);
        // inline complete setup of $Table3
        $Table3.add($JLabel9, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(SwingUtil.boxComponentWithJxLayer(_text), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel10, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(SwingUtil.boxComponentWithJxLayer(_text2), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel11, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(SwingUtil.boxComponentWithJxLayer(_ratio), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel3
        $JPanel3.add($Table4);
        // inline complete setup of $Table4
        $Table4.add($JLabel12, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel13, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel14, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel15, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel16, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel17, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel4
        $JPanel4.add($Table5);
        // inline complete setup of $Table5
        $Table5.add($JLabel18, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(firstName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JLabel19, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(lastName), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JLabel20, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(email2), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JLabel21, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(age), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JLabel22, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(config), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JLabel23, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(dir), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel5
        $JPanel5.add($Table6);
        // inline complete setup of $Table6
        $Table6.add($JLabel24, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel25, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel26, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel27, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel28, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel29, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel30, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel31, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel32, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel33, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel34, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel35, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel6
        $JPanel6.add($JScrollPane0);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(errorList);
        // inline complete setup of $JPanel7
        $JPanel7.add(cancel);
        $JPanel7.add(ok);
        
        // apply 24 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        $JPanel0.setBorder(BorderFactory.createTitledBorder("Form"));
        $JPanel1.setBorder(BorderFactory.createTitledBorder("Model"));
        $JPanel2.setBorder(BorderFactory.createTitledBorder("Form2"));
        $JPanel3.setBorder(BorderFactory.createTitledBorder("Model2"));
        $JPanel4.setBorder(BorderFactory.createTitledBorder("Identify Form"));
        $JPanel5.setBorder(BorderFactory.createTitledBorder("Identity Model"));
        $JPanel6.setBorder(BorderFactory.createTitledBorder("Messages"));
        errorList.setCellRenderer(new SwingValidatorMessageListRenderer());
        errorList.setModel(errorListModel);
        // late initializer
        // register 3 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel1();
        createModel2();
        createIdentity();
        createErrorListModel();
        createValidator();
        createValidator2();
        createValidator3();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        SwingUtil.setComponentHeight($JPanel0,120);
        $JPanel0.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel0,250);
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("Text:"));
        createText();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("Text2:"));
        createText2();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("Ratio:"));
        createRatio();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        SwingUtil.setComponentHeight($JPanel1,120);
        $JPanel1.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel1,250);
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("Text:"));
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("Text2:"));
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(t("Ratio:"));
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new JLabel());
        
        $JLabel8.setName("$JLabel8");
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        SwingUtil.setComponentHeight($JPanel2,120);
        $JPanel2.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel2,250);
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        // inline creation of $JLabel9
        $objectMap.put("$JLabel9", $JLabel9 = new JLabel());
        
        $JLabel9.setName("$JLabel9");
        $JLabel9.setText(t("Text:"));
        create_text();
        // inline creation of $JLabel10
        $objectMap.put("$JLabel10", $JLabel10 = new JLabel());
        
        $JLabel10.setName("$JLabel10");
        $JLabel10.setText(t("Text2:"));
        create_text2();
        // inline creation of $JLabel11
        $objectMap.put("$JLabel11", $JLabel11 = new JLabel());
        
        $JLabel11.setName("$JLabel11");
        $JLabel11.setText(t("Ratio:"));
        create_ratio();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        SwingUtil.setComponentHeight($JPanel3,120);
        $JPanel3.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel3,250);
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new Table());
        
        $Table4.setName("$Table4");
        // inline creation of $JLabel12
        $objectMap.put("$JLabel12", $JLabel12 = new JLabel());
        
        $JLabel12.setName("$JLabel12");
        $JLabel12.setText(t("Text:"));
        // inline creation of $JLabel13
        $objectMap.put("$JLabel13", $JLabel13 = new JLabel());
        
        $JLabel13.setName("$JLabel13");
        // inline creation of $JLabel14
        $objectMap.put("$JLabel14", $JLabel14 = new JLabel());
        
        $JLabel14.setName("$JLabel14");
        $JLabel14.setText(t("Text2:"));
        // inline creation of $JLabel15
        $objectMap.put("$JLabel15", $JLabel15 = new JLabel());
        
        $JLabel15.setName("$JLabel15");
        // inline creation of $JLabel16
        $objectMap.put("$JLabel16", $JLabel16 = new JLabel());
        
        $JLabel16.setName("$JLabel16");
        $JLabel16.setText(t("Ratio:"));
        // inline creation of $JLabel17
        $objectMap.put("$JLabel17", $JLabel17 = new JLabel());
        
        $JLabel17.setName("$JLabel17");
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        SwingUtil.setComponentHeight($JPanel4,180);
        $JPanel4.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel4,250);
        // inline creation of $Table5
        $objectMap.put("$Table5", $Table5 = new Table());
        
        $Table5.setName("$Table5");
        // inline creation of $JLabel18
        $objectMap.put("$JLabel18", $JLabel18 = new JLabel());
        
        $JLabel18.setName("$JLabel18");
        $JLabel18.setText(t("FirstName:"));
        createFirstName();
        // inline creation of $JLabel19
        $objectMap.put("$JLabel19", $JLabel19 = new JLabel());
        
        $JLabel19.setName("$JLabel19");
        $JLabel19.setText(t("LastName:"));
        createLastName();
        // inline creation of $JLabel20
        $objectMap.put("$JLabel20", $JLabel20 = new JLabel());
        
        $JLabel20.setName("$JLabel20");
        $JLabel20.setText(t("Email:"));
        createEmail2();
        // inline creation of $JLabel21
        $objectMap.put("$JLabel21", $JLabel21 = new JLabel());
        
        $JLabel21.setName("$JLabel21");
        $JLabel21.setText(t("Age:"));
        createAge();
        // inline creation of $JLabel22
        $objectMap.put("$JLabel22", $JLabel22 = new JLabel());
        
        $JLabel22.setName("$JLabel22");
        $JLabel22.setText(t("Config file :"));
        createConfig();
        // inline creation of $JLabel23
        $objectMap.put("$JLabel23", $JLabel23 = new JLabel());
        
        $JLabel23.setName("$JLabel23");
        $JLabel23.setText(t("Working directory:"));
        createDir();
        // inline creation of $JPanel5
        $objectMap.put("$JPanel5", $JPanel5 = new JPanel());
        
        $JPanel5.setName("$JPanel5");
        SwingUtil.setComponentHeight($JPanel5,120);
        $JPanel5.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel5,250);
        // inline creation of $Table6
        $objectMap.put("$Table6", $Table6 = new Table());
        
        $Table6.setName("$Table6");
        // inline creation of $JLabel24
        $objectMap.put("$JLabel24", $JLabel24 = new JLabel());
        
        $JLabel24.setName("$JLabel24");
        $JLabel24.setText(t("FirstName:"));
        // inline creation of $JLabel25
        $objectMap.put("$JLabel25", $JLabel25 = new JLabel());
        
        $JLabel25.setName("$JLabel25");
        // inline creation of $JLabel26
        $objectMap.put("$JLabel26", $JLabel26 = new JLabel());
        
        $JLabel26.setName("$JLabel26");
        $JLabel26.setText(t("LastName:"));
        // inline creation of $JLabel27
        $objectMap.put("$JLabel27", $JLabel27 = new JLabel());
        
        $JLabel27.setName("$JLabel27");
        // inline creation of $JLabel28
        $objectMap.put("$JLabel28", $JLabel28 = new JLabel());
        
        $JLabel28.setName("$JLabel28");
        $JLabel28.setText(t("Email:"));
        // inline creation of $JLabel29
        $objectMap.put("$JLabel29", $JLabel29 = new JLabel());
        
        $JLabel29.setName("$JLabel29");
        // inline creation of $JLabel30
        $objectMap.put("$JLabel30", $JLabel30 = new JLabel());
        
        $JLabel30.setName("$JLabel30");
        $JLabel30.setText(t("Age:"));
        // inline creation of $JLabel31
        $objectMap.put("$JLabel31", $JLabel31 = new JLabel());
        
        $JLabel31.setName("$JLabel31");
        // inline creation of $JLabel32
        $objectMap.put("$JLabel32", $JLabel32 = new JLabel());
        
        $JLabel32.setName("$JLabel32");
        $JLabel32.setText(t("Config file:"));
        // inline creation of $JLabel33
        $objectMap.put("$JLabel33", $JLabel33 = new JLabel());
        
        $JLabel33.setName("$JLabel33");
        // inline creation of $JLabel34
        $objectMap.put("$JLabel34", $JLabel34 = new JLabel());
        
        $JLabel34.setName("$JLabel34");
        $JLabel34.setText(t("Directory file:"));
        // inline creation of $JLabel35
        $objectMap.put("$JLabel35", $JLabel35 = new JLabel());
        
        $JLabel35.setName("$JLabel35");
        // inline creation of $JPanel6
        $objectMap.put("$JPanel6", $JPanel6 = new JPanel());
        
        $JPanel6.setName("$JPanel6");
        SwingUtil.setComponentHeight($JPanel6,200);
        $JPanel6.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel6,500);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createErrorList();
        // inline creation of $JPanel7
        $objectMap.put("$JPanel7", $JPanel7 = new JPanel());
        
        $JPanel7.setName("$JPanel7");
        $JPanel7.setLayout(new GridLayout(1,2,0,0));
        createCancel();
        createOk();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 24 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 24 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TEXT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model1 != null) {
                    model1.addPropertyChangeListener("text", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    SwingUtil.setText(text, model1.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model1 != null) {
                    model1.removePropertyChangeListener("text", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TEXT2_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model1 != null) {
                    model1.addPropertyChangeListener("text2", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    SwingUtil.setText(text2, model1.getText2());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model1 != null) {
                    model1.removePropertyChangeListener("text2", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RATIO_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model1 != null) {
                    model1.addPropertyChangeListener("ratio", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    ratio.setValue(model1.getRatio());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model1 != null) {
                    model1.removePropertyChangeListener("ratio", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL4_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model1 != null) {
                    model1.addPropertyChangeListener("text", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    $JLabel4.setText(t(model1.getText()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model1 != null) {
                    model1.removePropertyChangeListener("text", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL6_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model1 != null) {
                    model1.addPropertyChangeListener("text2", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    $JLabel6.setText(t(model1.getText2()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model1 != null) {
                    model1.removePropertyChangeListener("text2", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL8_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model1 != null) {
                    model1.addPropertyChangeListener("ratio", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    $JLabel8.setText(t(model1.getRatio()+""));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model1 != null) {
                    model1.removePropertyChangeListener("ratio", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING__TEXT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model2 != null) {
                    model2.addPropertyChangeListener("text", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model2 != null) {
                    SwingUtil.setText(_text, model2.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model2 != null) {
                    model2.removePropertyChangeListener("text", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING__TEXT2_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model2 != null) {
                    model2.addPropertyChangeListener("text2", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model2 != null) {
                    SwingUtil.setText(_text2, model2.getText2());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model2 != null) {
                    model2.removePropertyChangeListener("text2", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING__RATIO_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model2 != null) {
                    model2.addPropertyChangeListener("ratio", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model2 != null) {
                    _ratio.setValue(model2.getRatio());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model2 != null) {
                    model2.removePropertyChangeListener("ratio", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL13_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model2 != null) {
                    model2.addPropertyChangeListener("text", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model2 != null) {
                    $JLabel13.setText(t(model2.getText()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model2 != null) {
                    model2.removePropertyChangeListener("text", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL15_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model2 != null) {
                    model2.addPropertyChangeListener("text2", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model2 != null) {
                    $JLabel15.setText(t(model2.getText2()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model2 != null) {
                    model2.removePropertyChangeListener("text2", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL17_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model2 != null) {
                    model2.addPropertyChangeListener("ratio", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model2 != null) {
                    $JLabel17.setText(t(model2.getRatio()+""));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model2 != null) {
                    model2.removePropertyChangeListener("ratio", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIRST_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("firstName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    SwingUtil.setText(firstName, identity.getFirstName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("firstName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LAST_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("lastName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    SwingUtil.setText(lastName, identity.getLastName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("lastName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EMAIL2_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("email", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    SwingUtil.setText(email2, identity.getEmail());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("email", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AGE_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("age", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    age.setValue(identity.getAge());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("age", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CONFIG_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("config", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    SwingUtil.setText(config, identity.getConfig()+"");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("config", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DIR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("dir", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    SwingUtil.setText(dir, identity.getDir()+"");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("dir", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL25_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("firstName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    $JLabel25.setText(t(identity.getFirstName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("firstName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL27_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("lastName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    $JLabel27.setText(t(identity.getLastName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("lastName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL29_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("email", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    $JLabel29.setText(t(identity.getEmail()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("email", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL31_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("age", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    $JLabel31.setText(t(identity.getAge()+""));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("age", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL33_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("config", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    $JLabel33.setText(t(identity.getConfig()+""));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("config", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL35_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (identity != null) {
                    identity.addPropertyChangeListener("dir", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (identity != null) {
                    $JLabel35.setText(t(identity.getDir()+""));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (identity != null) {
                    identity.removePropertyChangeListener("dir", this);
                }
            }
        });
    }

}