/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.feature.nav.content;

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.entities.*;
import jaxx.demo.feature.nav.content.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class MoviesContentUI extends jaxx.demo.feature.nav.content.AbstractContentUI<java.util.List<Movie>> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VTU8TURR9rbSlfNMqHwEVpBsXTEGXEOTDECBFCVVC7MbXmQcd8jpveHOnDC6MP8GfoHs3Ju5cGReuXbgx/gVjXLg13jfTdqiU0li7mGnvPfe8c++cO33zncQcSaaPqOdp0rXALDNta2V//2HxiOlwnzm6NG0QkgSfSJREC6TXqMcdIDOFnCrPVsuza6JsC4tZZ6oXcqTHgVPOnBJjAOR6Y4XuONl8Pb3g2a6ssdZFNWN99fNH9KXx4nWUEM9GdT3YytRlVWEnXTkSNQ0gKTypQrOcWocoQ5rWIertV7E1Th3nAS2zY/KcJHIkblOJZEButd+yz+HXezaQdGal6ICkOqwJC7Di8eYckFlftMHKQjtgFFzJNItWND2AaNuiYjKnXmDbPl8cSJdBgQIZUFo1F0yu5UwHwnx3ZmuHWozjESmF8TTnBNvTgqgCJevY/sxWXpeCc5XDgtGGgjCl4IOhAo4HAhluACsRKp+qwxIgBC9SCeRqA/IRhlepbOSsqZ5Xv4fVZayeS2a2Vl0AYaHCdANVEFawifNon+rmBck7Z5OSTDQ4CL2phd4MzRMpkJh0MQxkrHDezruYCow89peRFaGf/T2S/vL+27v1mnsH8exrTaFnlg9dZUthMwmmOnowsK569Nltai8USNJhHDfX38zJJsLy1TSKw/OGQ+dsUKeEFLHE1w8fR55+vkKi66SHC2qsU4XfJEkoSZyC4IZn31v2FfWddON1SGkDEuf0VOBAycCisuVU0bQMfDJLHg5hsskQ6kqKyU+/0vm3y7VBRFDY+IXwcBixJyRuWty0mL/I1R1turi9tsNcQ4S72Gw7I+o+ZFfX57Z/nW3aaVFIg/munfNcdZv3Zatvd32WdBssQ7rgbtnaYBS59kx20iHfeElI8xm+JCgPthUXa0dwUz/tkHi0ouym/2/aPp1xvsss7L7lLEfa4IqVhRG80DogSR6g3YEWOe55ajFw1hQF/EcousCWmhOPt+MXYdNj1/fi3r+yqHC2RYOTbehIMEt1Z7SgudEGTRcwD1o0czmHCpstGKbbYmjVx0zHGhTDH4xkAJEfCQAA";
    private static final Log log = LogFactory.getLog(jaxx.demo.feature.nav.content.MoviesContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List< Movie > data;
    protected javax.swing.JList list;
    protected javax.swing.JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MoviesContentUI $AbstractContentUI0 = this;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JButton $JButton2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private void $afterCompleteSetup() {
    
        addPropertyChangeListener(PROPERTY_DATA, new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                java.util.List<Movie> ms = getData();
    
                if (ms != null) {
                    DefaultListModel model = (DefaultListModel) list.getModel();
                    for (Movie m : ms) {
                        model.addElement(m);
                    }
                } else {
                    // clean list model
                    DefaultListModel model = (DefaultListModel) list.getModel();
                    model.removeAllElements();
                }
            }
        });
    }
    
    protected void selectChild() {
        Movie selected = (Movie)list.getSelectedValue();
        getTreeHelper().selectNode(selected.getId());
        getTreeTableHelper().selectNode(selected.getId());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MoviesContentUI() {
        super();
        $initialize();
    }

    public MoviesContentUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        selectChild();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.util.List< Movie > getData() {
        return data;
    }

    public javax.swing.JList getList() {
        return list;
    }

    public javax.swing.JToolBar getToolbar() {
        return toolbar;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(java.util.List< Movie > newValue) {
        java.util.List< Movie > oldValue = this.data;
        this.data = newValue;
        firePropertyChange(PROPERTY_DATA, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add($JPanel1);
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createList() {
        $objectMap.put("list", list = new javax.swing.JList());
        
        list.setName("list");
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new javax.swing.JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setOpaque(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $AbstractContentUI0
        add($JPanel0);
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(toolbar, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(list);
        addChildrenToToolbar();
        // inline complete setup of $JPanel1
        $JPanel1.add($JButton0);
        $JPanel1.add($JButton1);
        $JPanel1.add($JButton2);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        $JScrollPane0.setBorder(new TitledBorder(_("jaxxdemo.navigation.movies.title")));
        $JScrollPane0.setColumnHeaderView(toolbar);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        list.setCellRenderer(getContextValue(DecoratorProviderListCellRenderer.class));
        list.setModel(new DefaultListModel());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AbstractContentUI0", this);
        createData();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createList();
        createToolbar();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("jaxxdemo.action.show"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("jaxxdemo.action.add"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("jaxxdemo.action.remove"));
        // inline creation of $AbstractContentUI0
        setName("$AbstractContentUI0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.nav.content.MoviesContentUI.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    $JButton0.setEnabled(list.getSelectedIndex()!=-1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    javax.swing.ListSelectionModel $target = ((javax.swing.ListSelectionModel) $bindingSources.remove("list.getSelectionModel()"));
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.nav.content.MoviesContentUI.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            public void $pr$u0(javax.swing.event.ListSelectionEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON2_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.nav.content.MoviesContentUI.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    $JButton2.setEnabled(list.getSelectedIndex()!=-1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    javax.swing.ListSelectionModel $target = ((javax.swing.ListSelectionModel) $bindingSources.remove("list.getSelectionModel()"));
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.nav.content.MoviesContentUI.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            public void $pr$u1(javax.swing.event.ListSelectionEvent event) {
                propertyChange(null);
            }
        });
    }

}