/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id: NavDemoDataProvider.java 2015 2010-06-30 17:49:34Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.1/jaxx-demo/src/main/java/jaxx/demo/feature/nav/NavDemoDataProvider.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.demo.feature.nav;

import jaxx.demo.entities.Movie;
import jaxx.demo.entities.People;
import jaxx.runtime.swing.nav.NavDataProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author sletellier <letellier@codelutin.com>
 * @since 2.1
 */
public class NavDemoDataProvider implements NavDataProvider {

    /** Logger */
    static private final Log log = LogFactory.getLog(NavDemoDataProvider.class);

    protected Map<String, Movie> movies;

    protected Map<String, People> peoples;

    public NavDemoDataProvider() {

        movies = new HashMap<String, Movie>();
        peoples = new HashMap<String, People>();

        log.info("for " + this);
        People a = new People("0", "Jack", "Black", 0, "/jaxx/demo/images/jack.jpg");
        People a2 = new People("1", "Héctor", "Jiménez", 0, "/jaxx/demo/images/hector.jpg");
        People a3 = new People("2", "Ana", "de la Reguera", 0, "/jaxx/demo/images/ana.jpg");

        Movie m = new Movie("0", "Nacho libre", 1996, "/jaxx/demo/images/nacho.jpg");
        m.addActor(a);
        m.addActor(a2);
        m.addActor(a3);

        Movie m2 = new Movie("1", "Nacho 2", 2009, "/jaxx/demo/images/nacho2.png");
        m2.addActor(a);
        m2.addActor(a2);

        movies.put(m.getId(), m);
        movies.put(m2.getId(), m2);

        peoples.put(a.getId(), a);
        peoples.put(a2.getId(), a2);
        peoples.put(a3.getId(), a3);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public Movie getMovie(String id) {
        return movies.get(id);
    }

    public People getPeople(String id) {
        return peoples.get(id);
    }

    public List<Movie> getMovies() {
        return new ArrayList<Movie>(movies.values());
    }

    public List<People> getPeoples() {
        return new ArrayList<People>(peoples.values());
    }

    public List<People> getPeoples(Movie m) {
        return m.getActors();
    }

    public List<People> getPeoples(String moviesId) {

        if (log.isDebugEnabled()) {
            log.debug("Get people for movie " + moviesId);
        }

        return movies.get(moviesId).getActors();
    }
}
