/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.jaxx.editor;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.jaxx.editor.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class NumberEditorDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_AUTO_POPUP = "editor.autoPopup";
    public static final String BINDING_EDITOR_PROPERTY = "editor.property";
    public static final String BINDING_EDITOR_SHOW_POPUP_BUTTON = "editor.showPopupButton";
    public static final String BINDING_EDITOR_SHOW_RESET = "editor.showReset";
    public static final String BINDING_EDITOR_USE_FLOAT = "editor.useFloat";
    public static final String BINDING_EDITOR_USE_SIGN = "editor.useSign";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL1_TEXT = "$JLabel1.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVz08TQRTHpxVKCyIK8itABGkwXrYYg8aAiBQbJAUJ9UDsxdnuhC5ud8adWVkuxj/BP0HvXky8eTIePHvwYvwXjPHg1fhmuu1S2JaV7WG3+3589jtv57159xN1cwfN7GPP0xzXFmaNaBv3d3cf6fukItYIrzgmE9RB9V8iiZJl1Gc07Vyg2XJRpuf89Fye1hi1iX0ke7GIerk4tAivEiIEmmrNqHCeKzXdix5znQa1KSqM+ub3r+Rr49XbJEIeA3X9sJTp07KClXQVUdI0BBqEN73AOQvbeyDDMe090NsvbXkLc76Fa+Q5eol6iijFsAMwga5GX7JiqHyPCdSXXSM1uo1tYs0LNK/EGmDRKg2EpmzEMAGibbk1nTgP1INMZEyhUgJlZNYmNYgl0ML/YlRewOrJPsa6RUDQWEv1+AHUQlM+GZlpJqSzG40lDMo6eX5o3SqDBoJYl5OCRTFUbbglNl8llWer1JNxg4EWCC+Ze7Z8HG11DfAqPdimzGWrrhC0bcgO4US0DclgV1BFCXGm6gUTaC6kECHFPLZUvyw35PPlE74i1kNKpqwyaPZErOJc830OmmjRBE2jBU0T7OpEGXU7Lpjha5ZP9tkOuOodNnaswyRQef+ODH37+ONDodFWo/Du4dDQI1MBtjtzKCOOMOWrB+o95QrTym1itlhGGU4sGClqZEyGCCv5bhAH77sk0zWZrq1jXgVEd8/3T59Hnn49h5IF1AsbyihgGf8QZUTVgSpQy/DYvRWl6PxBGq4XpTb4qDp1DBCGLiwZWOBp3bQNKP2yB0WYDClCU4me+fJnqPR+pVGIBAgbbxseFKP7CUqZtmXaRE0Yf3iETpQ+xolr0GBIhI2NhLwPMb9hc+p6M3SlFj6krpD+W54rb7eVbPnvTmRKuv6liByNS/V1TEP7OqbuCrIczh2JwO0SxFPa8mdlSPNqB8J4JMJ6bEInDROxNUQjdNIwFVtDNEInDVdiazidcHyat9n0M1E2p06wHZOR9ifgYUxO2EEXA5dpHopx19c4ymNyjp7xZ8ZI80IHQjYS4W5swnoHwlxswnUg/AMiiWvrpQsAAA==";
    private static final Log log = LogFactory.getLog(jaxx.demo.component.jaxx.editor.NumberEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JCheckBox autoPopup;
    protected jaxx.demo.component.jaxx.editor.NumberEditorDemoModel demoModel;
    protected jaxx.runtime.swing.editor.NumberEditor editor;
    protected javax.swing.JCheckBox showPopupButton;
    protected javax.swing.JCheckBox showResetButton;
    protected javax.swing.JCheckBox useFloat;
    protected javax.swing.JCheckBox useSign;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NumberEditorDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    void $afterCompleteSetup() {
        editor.init();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditorDemo() {
        super();
        $initialize();
    }

    public NumberEditorDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JCheckBox getAutoPopup() {
        return autoPopup;
    }

    public jaxx.demo.component.jaxx.editor.NumberEditorDemoModel getDemoModel() {
        return demoModel;
    }

    public jaxx.runtime.swing.editor.NumberEditor getEditor() {
        return editor;
    }

    public javax.swing.JCheckBox getShowPopupButton() {
        return showPopupButton;
    }

    public javax.swing.JCheckBox getShowResetButton() {
        return showResetButton;
    }

    public javax.swing.JCheckBox getUseFloat() {
        return useFloat;
    }

    public javax.swing.JCheckBox getUseSign() {
        return useSign;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAutoPopup() {
        $objectMap.put("autoPopup", autoPopup = new javax.swing.JCheckBox());
        
        autoPopup.setName("autoPopup");
        autoPopup.setSelected(false);
        autoPopup.setText(_("jaxxdemo.numbereditor.autoPopup"));
    }

    protected void createDemoModel() {
        $objectMap.put("demoModel", demoModel = new jaxx.demo.component.jaxx.editor.NumberEditorDemoModel());
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new jaxx.runtime.swing.editor.NumberEditor(this));
        
        editor.setName("editor");
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = new javax.swing.JCheckBox());
        
        showPopupButton.setName("showPopupButton");
        showPopupButton.setSelected(true);
        showPopupButton.setText(_("jaxxdemo.numbereditor.showPopupButton"));
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new javax.swing.JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setSelected(true);
        showResetButton.setText(_("jaxxdemo.numbereditor.showReset"));
    }

    protected void createUseFloat() {
        $objectMap.put("useFloat", useFloat = new javax.swing.JCheckBox());
        
        useFloat.setName("useFloat");
        useFloat.setSelected(true);
        useFloat.setText(_("jaxxdemo.numbereditor.useFloat"));
    }

    protected void createUseSign() {
        $objectMap.put("useSign", useSign = new javax.swing.JCheckBox());
        
        useSign.setName("useSign");
        useSign.setSelected(true);
        useSign.setText(_("jaxxdemo.numbereditor.useSign"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(useFloat);
        $JPanel0.add(useSign);
        $JPanel0.add(showPopupButton);
        $JPanel0.add(showResetButton);
        $JPanel0.add(autoPopup);
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel0);
        $JPanel1.add($JLabel1);
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        $JPanel0.setBorder(new TitledBorder(_("jaxxdemo.numbereditor.configuration")));
        editor.setBean(demoModel);
        $JPanel1.setBorder(new TitledBorder(_("jaxxdemo.numbereditor.model")));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        createDemoModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0,1));
        createUseFloat();
        createUseSign();
        createShowPopupButton();
        createShowResetButton();
        createAutoPopup();
        createEditor();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(0,1));
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_AUTO_POPUP, true) {
        
            @Override
            public void applyDataBinding() {
                if (autoPopup != null) {
                    $bindingSources.put("autoPopup.getModel()", autoPopup.getModel());
                    autoPopup.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    autoPopup.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_AUTO_POPUP));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (autoPopup != null) {
                    editor.setAutoPopup(autoPopup.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (autoPopup != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("autoPopup.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    autoPopup.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_AUTO_POPUP));
                }
            }
        
            public void $pr$u0(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_PROPERTY, true) {
        
            @Override
            public void applyDataBinding() {
                if (useFloat != null) {
                    $bindingSources.put("useFloat.getModel()", useFloat.getModel());
                    useFloat.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    useFloat.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_PROPERTY));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (useFloat != null) {
                    editor.setProperty(useFloat.isSelected() ? "floatProperty" : "integerProperty");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (useFloat != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("useFloat.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    useFloat.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_PROPERTY));
                }
            }
        
            public void $pr$u1(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_POPUP_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupButton != null) {
                    $bindingSources.put("showPopupButton.getModel()", showPopupButton.getModel());
                    showPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupButton != null) {
                    editor.setShowPopupButton(showPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupButton != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("showPopupButton.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            public void $pr$u2(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    editor.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("showResetButton.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u3(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_USE_FLOAT, true) {
        
            @Override
            public void applyDataBinding() {
                if (useFloat != null) {
                    $bindingSources.put("useFloat.getModel()", useFloat.getModel());
                    useFloat.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    useFloat.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_USE_FLOAT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (useFloat != null) {
                    editor.setUseFloat(useFloat.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (useFloat != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("useFloat.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    useFloat.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_USE_FLOAT));
                }
            }
        
            public void $pr$u4(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_USE_SIGN, true) {
        
            @Override
            public void applyDataBinding() {
                if (useSign != null) {
                    $bindingSources.put("useSign.getModel()", useSign.getModel());
                    useSign.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    useSign.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_USE_SIGN));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (useSign != null) {
                    editor.setUseSign(useSign.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (useSign != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("useSign.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    useSign.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_USE_SIGN));
                }
            }
        
            public void $pr$u5(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoModel != null) {
                    demoModel.addPropertyChangeListener("integerProperty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoModel != null) {
                    $JLabel0.setText(_("jaxxdemo.numbereditor.model.int", demoModel.getIntegerProperty()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoModel != null) {
                    demoModel.removePropertyChangeListener("integerProperty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL1_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoModel != null) {
                    demoModel.addPropertyChangeListener("floatProperty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoModel != null) {
                    $JLabel1.setText(_("jaxxdemo.numbereditor.model.float", demoModel.getFloatProperty()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoModel != null) {
                    demoModel.removePropertyChangeListener("floatProperty", this);
                }
            }
        });
    }

}